/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShaderInventory
implements Container {
    private CapabilityShader.ShaderWrapper wrapper;
    private AbstractContainerMenu container;
    @Nonnull
    public ItemStack shader;
    private ResourceLocation name;

    public ShaderInventory(AbstractContainerMenu par1Container, CapabilityShader.ShaderWrapper wrapper) {
        this.container = par1Container;
        this.wrapper = wrapper;
        this.shader = ShaderRegistry.makeShaderStack(wrapper.getShader());
        this.name = wrapper.getShaderType();
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shader.isEmpty();
    }

    public ItemStack getItem(int i) {
        return this.shader;
    }

    public ItemStack removeItemNoUpdate(int i) {
        if (!this.shader.isEmpty()) {
            ItemStack itemstack = this.shader.copy();
            this.shader = ItemStack.EMPTY;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int i, int j) {
        if (!this.shader.isEmpty()) {
            if (this.shader.getCount() <= j) {
                ItemStack itemstack = this.shader.copy();
                this.shader = ItemStack.EMPTY;
                this.setChanged();
                this.container.slotsChanged((Container)this);
                return itemstack;
            }
            ItemStack itemstack = this.shader.split(j);
            if (this.shader.getCount() == 0) {
                this.shader = ItemStack.EMPTY;
            }
            this.container.slotsChanged((Container)this);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int i, ItemStack stack) {
        this.shader = stack;
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.container.slotsChanged((Container)this);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        Item item;
        if (this.wrapper != null && (item = this.shader.getItem()) instanceof IShaderItem) {
            IShaderItem shaderItem = (IShaderItem)item;
            this.wrapper.setShader(shaderItem.getShaderName());
        }
    }

    public boolean stillValid(Player entityplayer) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void clearContent() {
    }
}

