/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.register.IEIngredients;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public record IngredientFluidStack(FluidTagInput fluidTagInput) implements ICustomIngredient
{
    public static final DualMapCodec<RegistryFriendlyByteBuf, IngredientFluidStack> CODEC = FluidTagInput.MAP_CODECS.map(IngredientFluidStack::new, IngredientFluidStack::getFluidTagInput);

    public IngredientFluidStack(TagKey<Fluid> tag, int amount) {
        this(new FluidTagInput(tag, amount, DataComponentPredicate.EMPTY));
    }

    public FluidTagInput getFluidTagInput() {
        return this.fluidTagInput;
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        return this.fluidTagInput.getMatchingFluidStacks().stream().map(FluidUtil::getFilledBucket).filter(s -> !s.isEmpty());
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Optional handler = FluidUtil.getFluidHandler((ItemStack)stack);
        return handler.isPresent() && this.fluidTagInput.extractFrom((IFluidHandler)handler.get(), IFluidHandler.FluidAction.SIMULATE);
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack getExtractedStack(ItemStack input) {
        IFluidHandlerItem handler = (IFluidHandlerItem)input.copyWithCount(1).getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            this.fluidTagInput.extractFrom((IFluidHandler)handler, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }
        return input.getCraftingRemainingItem();
    }

    public IngredientType<?> getType() {
        return (IngredientType)IEIngredients.FLUID_STACK.value();
    }
}

