/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.metal.CrafterPatternInventory;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AssemblerLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AssemblerMenu
extends IEContainerMenu {
    public final List<IItemHandlerModifiable> patterns;
    public final IItemHandler inv;
    public final FluidTank[] tanks;
    public final EnergyStorage energy;
    public final GetterAndSetter<Boolean> recursiveIngredients;

    public static AssemblerMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, final IEContainerMenu.MultiblockMenuContext<AssemblerLogic.State> ctx) {
        AssemblerLogic.State state = ctx.mbContext().getState();
        ArrayList<IItemHandlerModifiable> patterns = new ArrayList<IItemHandlerModifiable>(3);
        for (final CrafterPatternInventory pattern : state.patterns) {
            patterns.add((IItemHandlerModifiable)new ItemStackHandler(pattern.inv){

                protected void onContentsChanged(int slot) {
                    pattern.recalculateOutput(ctx.mbContext().getLevel().getRawLevel());
                }

                public int getSlotLimit(int slot) {
                    return 1;
                }
            });
        }
        return new AssemblerMenu(AssemblerMenu.multiblockCtx(type, id, ctx), invPlayer, patterns, (IItemHandler)state.inventory, state.tanks, state.energy, new GetterAndSetter<Boolean>(() -> state.recursiveIngredients, b -> {
            state.recursiveIngredients = b;
        }));
    }

    public static AssemblerMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        ArrayList<IItemHandlerModifiable> patterns = new ArrayList<IItemHandlerModifiable>(3);
        for (int i = 0; i < 3; ++i) {
            patterns.add((IItemHandlerModifiable)new ItemStackHandler(10));
        }
        FluidTank[] tanks = new FluidTank[3];
        for (int i = 0; i < tanks.length; ++i) {
            tanks[i] = new FluidTank(8000);
        }
        return new AssemblerMenu(AssemblerMenu.clientCtx(type, id), invPlayer, patterns, (IItemHandler)new ItemStackHandler(21), tanks, new MutableEnergyStorage(32000), GetterAndSetter.standalone(false));
    }

    private AssemblerMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, List<IItemHandlerModifiable> patterns, IItemHandler inv, FluidTank[] tanks, MutableEnergyStorage energy, GetterAndSetter<Boolean> recursiveIngredients) {
        super(ctx);
        int i;
        this.patterns = patterns;
        this.inv = inv;
        this.tanks = tanks;
        this.energy = energy;
        this.recursiveIngredients = recursiveIngredients;
        for (i = 0; i < 3; ++i) {
            IItemHandler itemHandler = (IItemHandler)patterns.get(i);
            for (int j = 0; j < 9; ++j) {
                int x = 9 + i * 58 + j % 3 * 18;
                int y = 7 + j / 3 * 18;
                this.addSlot((Slot)new IESlot.ItemHandlerGhost(itemHandler, j, x, y));
            }
            this.addSlot((Slot)new IESlot.NewOutput(inv, 18 + i, 27 + i * 58, 64));
        }
        for (i = 0; i < 18; ++i) {
            this.addSlot((Slot)new SlotItemHandler(inv, i, 13 + i % 9 * 18, 87 + i / 9 * 18));
        }
        this.ownSlotCount = 21;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 13 + j * 18, 137 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 13 + i * 18, 195));
        }
        this.addGenericData(GenericContainerData.energy(energy));
        for (i = 0; i < 3; ++i) {
            this.addGenericData(GenericContainerData.fluid(tanks[i]));
        }
        for (IItemHandlerModifiable pattern : patterns) {
            this.addGenericData(new GenericContainerData<ItemStack>(GenericDataSerializers.ITEM_STACK, () -> pattern.getStackInSlot(9), s -> pattern.setStackInSlot(9, s)));
        }
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, recursiveIngredients));
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem() && !(slotObject instanceof IESlot.ItemHandlerGhost)) {
            ItemStack stackInSlot = slotObject.getItem();
            stack = stackInSlot.copy();
            if (slot < 48 ? !this.moveItemStackTo(stackInSlot, 48, 84, true) : !this.moveItemStackTo(stackInSlot, 30, 48, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.set(ItemStack.EMPTY);
            } else {
                slotObject.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(player, stackInSlot);
        }
        return stack;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        block5: {
            block3: {
                int id;
                block4: {
                    super.receiveMessageFromScreen(nbt);
                    if (!nbt.contains("buttonID", 3)) break block3;
                    id = nbt.getInt("buttonID");
                    if (id < 0 || id >= this.patterns.size()) break block4;
                    IItemHandlerModifiable pattern = this.patterns.get(id);
                    for (int i = 0; i < pattern.getSlots(); ++i) {
                        pattern.setStackInSlot(i, ItemStack.EMPTY);
                    }
                    break block5;
                }
                if (id != 3) break block5;
                this.recursiveIngredients.set(this.recursiveIngredients.get() == false);
                break block5;
            }
            if (nbt.contains("patternSync", 3)) {
                int r = nbt.getInt("recipe");
                ListTag list = nbt.getList("patternSync", 10);
                IItemHandlerModifiable pattern = this.patterns.get(r);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag itemTag = list.getCompound(i);
                    pattern.setStackInSlot(itemTag.getInt("slot"), ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)itemTag));
                }
            }
        }
    }
}

