/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual;

import blusunrize.immersiveengineering.data.manual.ManualDataGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagLoader;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public record TagExports(PackOutput output, ExistingFileHelper helper, Path outPath) implements DataProvider
{
    private static final Gson GSON = new Gson();

    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        try {
            this.actuallyRun();
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException x) {
            return CompletableFuture.failedFuture(x);
        }
    }

    private void actuallyRun() throws IOException {
        TagLoader loader = new TagLoader(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getOptional(arg_0), Registries.tagsDirPath((ResourceKey)Registries.ITEM));
        try (ReloadableResourceManager resourceManager = ManualDataGenerator.makeFullResourceManager(PackType.SERVER_DATA, this.output, this.helper);){
            Map tags = loader.loadAndBuild((ResourceManager)resourceManager);
            for (Map.Entry entry : tags.entrySet()) {
                JsonArray elements = new JsonArray();
                ((Collection)entry.getValue()).stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).sorted().forEach(arg_0 -> ((JsonArray)elements).add(arg_0));
                ResourceLocation tagName = (ResourceLocation)entry.getKey();
                Path tagPath = this.outPath.resolve(tagName.getNamespace()).resolve(tagName.getPath() + ".json");
                Files.createDirectories(tagPath.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(tagPath, new OpenOption[0]);
                try {
                    writer.write(GSON.toJson((JsonElement)elements));
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
        }
    }

    @Nonnull
    public String getName() {
        return "Tag export for online manual";
    }
}

