/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SurveyToolsItem;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IEDataComponents {
    private static final DeferredRegister<DataComponentType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"immersiveengineering");
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> BALLOON_OFFSET = IEDataComponents.make("balloon_offset", DualCodecs.INT);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<LogicCircuitHandler.LogicCircuitInstruction>> CIRCUIT_INSTRUCTION = IEDataComponents.make("logic_instruction", LogicCircuitHandler.LogicCircuitInstruction.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<List<LogicCircuitHandler.LogicCircuitInstruction>>> CIRCUIT_INSTRUCTIONS = IEDataComponents.make("logic_instructions", LogicCircuitHandler.LogicCircuitInstruction.CODECS.listOf());
    public static DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> GENERIC_FLUID = REGISTER.register("fluid", () -> DataComponentType.builder().persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC).build());
    public static DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> GENERIC_ITEMS = REGISTER.register("items", () -> DataComponentType.builder().persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).build());
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> GENERIC_ENERGY = IEDataComponents.make("energy", DualCodecs.INT);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<CoresampleItem.ItemData>> CORESAMPLE = IEDataComponents.make("coresample_data", CoresampleItem.ItemData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Color4>> COLOR = IEDataComponents.make("color", Color4.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Block>> DEFAULT_COVER = IEDataComponents.make("default_cover", DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK));
    public static DeferredHolder<DataComponentType<?>, DataComponentType<CapacitorBlockEntity.CapacitorState>> CAPACITOR_CONFIG = IEDataComponents.make("cap_config", CapacitorBlockEntity.CapacitorState.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<EarmuffsItem.EarmuffData>> EARMUFF_DATA = IEDataComponents.make("earmuff_data", EarmuffsItem.EarmuffData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<AttachedItem>> CONTAINED_EARMUFF = IEDataComponents.make("contained_earmuff", AttachedItem.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<AttachedItem>> CONTAINED_POWERPACK = IEDataComponents.make("contained_powerpack", AttachedItem.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<ChemthrowerItem.ChemthrowerData>> CHEMTHROWER_DATA = IEDataComponents.make("chemthrower_data", ChemthrowerItem.ChemthrowerData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<TurretBlockEntity.TurretConfig>> TURRET_DATA = IEDataComponents.make("turret_data", TurretBlockEntity.TurretConfig.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<List<SurveyToolsItem.VeinEntry>>> SURVERYTOOL_DATA = IEDataComponents.make("surveytool_data", SurveyToolsItem.VeinEntry.CODECS.listOf());
    public static DeferredHolder<DataComponentType<?>, DataComponentType<UpgradeData>> UPGRADE_DATA = IEDataComponents.make("upgrade_nbt", UpgradeData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SKYHOOK_SPEED_LIMIT = IEDataComponents.make("speed_limit", DualCodecs.BOOL);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DRILL_SINGLEBLOCK = IEDataComponents.make("drill_singleblock", DualCodecs.BOOL);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<HammerItem.MultiblockRestriction>> MULTIBLOCK_RESTRICTION = IEDataComponents.make("multiblock_restriction", HammerItem.MultiblockRestriction.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<RevolverItem.Perks>> REVOLVER_PERKS = IEDataComponents.make("revolver_perks", RevolverItem.Perks.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<String>> REVOLVER_ELITE = IEDataComponents.make("revolver_elite", DualCodecs.STRING);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<String>> REVOLVER_FLAVOUR = IEDataComponents.make("revolver_flavour", DualCodecs.STRING);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<FluorescentTubeItem.LitState>> FLUORESCENT_TUBE_LIT = IEDataComponents.make("fluorescent_tube", FluorescentTubeItem.LitState.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> WINDMILL_BLADES = IEDataComponents.make("windmill_blades", DualCodecs.INT);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<RevolverItem.RevolverCooldowns>> REVOLVER_COOLDOWN = IEDataComponents.make("revolver_cooldown", RevolverItem.RevolverCooldowns.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<UpgradeData>> BASE_UPGRADES = IEDataComponents.make("base_upgrades", UpgradeData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<FeedthroughBlockEntity.ItemData>> FEEDTHROUGH_DATA = IEDataComponents.make("feedthrough_data", FeedthroughBlockEntity.ItemData.CODECS);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> RAILGUN_AMMO_SLOT = IEDataComponents.make("railgun_ammo_slot", DualCodecs.INT);
    public static DeferredHolder<DataComponentType<?>, DataComponentType<CoresampleItem.CoresampleMapData>> CORESAMPLE_MAP_DATA = IEDataComponents.make("coresample_map_data", CoresampleItem.CoresampleMapData.CODECS);
    private static final Map<BulletHandler.IBullet<?>, Supplier<DataComponentType<?>>> BULLETS = new IdentityHashMap();
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> JERRYCAN_DRAIN = REGISTER.register("jerrycan_drain", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());

    public static void init(IEventBus bus) {
        REGISTER.register(bus);
        for (ResourceLocation name : BulletHandler.getAllKeys()) {
            BulletHandler.IBullet<?> bullet = BulletHandler.getBullet(name);
            BulletHandler.CodecsAndDefault<?> codecs = bullet.getCodec();
            if (codecs.vanillaDataComponent() != null) {
                BULLETS.put(bullet, codecs::vanillaDataComponent);
                continue;
            }
            String path = (String)(name.getNamespace().equals("immersiveengineering") ? "" : name.getNamespace() + "_") + name.getPath();
            DeferredHolder<DataComponentType<?>, DataComponentType<?>> entry = IEDataComponents.make(path, codecs.codecs());
            BULLETS.put(bullet, () -> entry.get());
        }
        IEApiDataComponents.WIRE_LINK = IEDataComponents.make("wire_link", WireLink.CODECS);
        IEApiDataComponents.BLUEPRINT_TYPE = IEDataComponents.make("blueprint", DualCodecs.STRING);
        IEApiDataComponents.ATTACHED_SHADER = IEDataComponents.make("shader", DualCodecs.RESOURCE_LOCATION);
        IEApiDataComponents.FLUID_PRESSURIZED = IEDataComponents.make("fluid_pressurized", DualCodecs.unit((Object)Unit.INSTANCE));
    }

    public static <T> DataComponentType<T> getBulletData(BulletHandler.IBullet<T> bullet) {
        return BULLETS.get(bullet).get();
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> make(String name, DualCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return REGISTER.register(name, () -> DataComponentType.builder().persistent(codec.codec()).networkSynchronized(codec.streamCodec()).build());
    }
}

