/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.AbstractArrowAccess;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SawbladeEntity
extends IEProjectileEntity {
    private ItemStack ammo = ItemStack.EMPTY;
    private static final EntityDataAccessor<ItemStack> dataMarker_ammo = SynchedEntityData.defineId(SawbladeEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public SawbladeEntity(EntityType<SawbladeEntity> type, Level world) {
        super(type, world);
        this.pickup = AbstractArrow.Pickup.ALLOWED;
    }

    public SawbladeEntity(Level world, @Nonnull LivingEntity living, float velocity, float accuracy, ItemStack ammo) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.SAWBLADE.get()), world, living, velocity, accuracy);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        ((AbstractArrowAccess)((Object)this)).invokeSetPierceLevel((byte)3);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(dataMarker_ammo, (Object)ItemStack.EMPTY);
    }

    @Nonnull
    protected ItemStack getDefaultPickupItem() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().isEmpty()) {
            this.entityData.set(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.entityData.get(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    @Override
    public double getDefaultGravity() {
        return 0.005;
    }

    @Override
    public int getMaxTicksInGround() {
        return 1200;
    }

    public void baseTick() {
        if (this.getAmmo().isEmpty() && this.level().isClientSide) {
            this.ammo = this.getAmmoSynced();
        }
        super.baseTick();
    }

    private void damageSawblade() {
        int dmg = Math.round((float)this.getAmmo().getMaxDamage() * 0.05f);
        Entity shooter = this.getOwner();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getAmmo().hurtAndBreak(dmg, serverLevel, shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null, i -> this.discard());
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.damageSawblade();
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity shooter = this.getOwner();
        Entity target = result.getEntity();
        float damage = (float)(12.0 * (Double)IEServerConfig.TOOLS.railgun_damage.get());
        target.hurt(IEDamageSources.causeSawbladeDamage(this, shooter), damage);
        this.handlePiecing(target);
        this.damageSawblade();
    }

    @Override
    protected void handlePiecing(Entity target) {
        super.handlePiecing(target);
        Entity owner = this.getOwner();
        if (this.piercedEntities.size() >= 3 && owner instanceof Player) {
            Player shooter = (Player)owner;
            Utils.unlockIEAdvancement(shooter, "tools/secret_ravenholm");
        }
    }

    protected boolean canHitEntity(Entity target) {
        if (this.piercedEntities != null && this.piercedEntities.contains(target.getId())) {
            return false;
        }
        return !target.isSpectator() && target.isAlive() && target.isPickable();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (!this.ammo.isEmpty()) {
            nbt.put("ammo", this.ammo.save((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.ammo = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)nbt.getCompound("ammo"));
    }
}

