/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoresampleBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds {
    public static final String CORESAMPLE_MAP_PREFIX = "ie:coresample_";
    public CoresampleItem.ItemData containedSample = CoresampleItem.ItemData.EMPTY;
    private Component[] overlay = null;
    private static final VoxelShape AABB_CORESAMPLE_X = Shapes.box((double)0.0, (double)0.0, (double)0.28125, (double)1.0, (double)1.0, (double)0.71875);
    private static final VoxelShape AABB_CORESAMPLE_Z = Shapes.box((double)0.28125, (double)0.0, (double)0.0, (double)0.71875, (double)1.0, (double)1.0);

    public CoresampleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CORE_SAMPLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.containedSample = CoresampleItem.ItemData.CODECS.codec().decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("coresample")).result().map(Pair::getFirst).orElse(CoresampleItem.ItemData.EMPTY);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.put("coresample", (Tag)CoresampleItem.ItemData.CODECS.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.containedSample).getOrThrow());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.isShiftKeyDown()) {
            if (!this.level.isClientSide) {
                ItemEntity entityitem = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.makeSampleStack(), 0.0, 0.0, 0.0);
                this.level.removeBlock(this.worldPosition, false);
                this.level.addFreshEntity((Entity)entityitem);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (!heldItem.isEmpty() && heldItem.getItem() == Items.FILLED_MAP) {
            MapItemSavedData mapData;
            if (!this.level.isClientSide && (mapData = MapItem.getSavedData((ItemStack)heldItem, (Level)player.getCommandSenderWorld())) != null) {
                if (mapData.dimension != this.containedSample.position().dimension()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.coresample.mapDimension"));
                    return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
                }
                String ident = CORESAMPLE_MAP_PREFIX + String.valueOf(this.containedSample.position().position());
                MapDecorations oldDecorations = (MapDecorations)heldItem.getOrDefault(DataComponents.MAP_DECORATIONS, (Object)MapDecorations.EMPTY);
                if (oldDecorations.decorations().containsKey(ident)) {
                    HashMap newMap = new HashMap(oldDecorations.decorations());
                    newMap.remove(ident);
                    heldItem.set(DataComponents.MAP_DECORATIONS, (Object)new MapDecorations(newMap));
                    CoresampleItem.CoresampleMapData mineralData = (CoresampleItem.CoresampleMapData)heldItem.getOrDefault(IEDataComponents.CORESAMPLE_MAP_DATA, (Object)CoresampleItem.CoresampleMapData.EMPTY);
                    heldItem.set(IEDataComponents.CORESAMPLE_MAP_DATA, (Object)mineralData.remove(ident));
                } else {
                    double sampleX = (double)this.containedSample.position().x() + 0.5;
                    double sampleZ = (double)this.containedSample.position().z() + 0.5;
                    int mapScale = 1 << mapData.scale;
                    float distX = (float)(sampleX - (double)mapData.centerX) / (float)mapScale;
                    float distZ = (float)(sampleZ - (double)mapData.centerZ) / (float)mapScale;
                    if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                        MapDecorations.Entry sampleEntry = new MapDecorations.Entry(MapDecorationTypes.TARGET_POINT, sampleX, sampleZ, 180.0f);
                        CoresampleItem.CoresampleMapData mineralData = (CoresampleItem.CoresampleMapData)heldItem.getOrDefault(IEDataComponents.CORESAMPLE_MAP_DATA, (Object)CoresampleItem.CoresampleMapData.EMPTY);
                        List<ResourceLocation> minerals = this.containedSample.veins().stream().map(CoresampleItem.VeinSample::mineral).toList();
                        heldItem.set(IEDataComponents.CORESAMPLE_MAP_DATA, (Object)mineralData.with(ident, minerals));
                        heldItem.set(DataComponents.MAP_DECORATIONS, (Object)oldDecorations.withDecoration(ident, sampleEntry));
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.coresample.mapFail"));
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        drop.accept(this.makeSampleStack());
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.containedSample = (CoresampleItem.ItemData)ctx.getItemInHand().getOrDefault(IEDataComponents.CORESAMPLE, (Object)CoresampleItem.ItemData.EMPTY);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (this.overlay == null) {
            ArrayList<Component> list = new ArrayList<Component>();
            CoresampleItem.getCoresampleInfo(this.containedSample, list, ChatFormatting.WHITE, this.level, false, false);
            this.overlay = list.toArray(new Component[0]);
        }
        return this.overlay;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getFacing().getAxis() == Direction.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
    }

    public ItemStack makeSampleStack() {
        ItemStack coresampleStack = IEItems.Misc.CORESAMPLE.asItem().getDefaultInstance();
        coresampleStack.set(IEDataComponents.CORESAMPLE, (Object)this.containedSample);
        return coresampleStack;
    }
}

