/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntToDoubleFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MultiblockProcessor<R extends MultiblockRecipe, CTX extends ProcessContext<R>> {
    private final List<MultiblockProcess<R, CTX>> processQueue = new ArrayList<MultiblockProcess<R, CTX>>();
    private final int maxQueueLength;
    private final IntToDoubleFunction minDelayAfter;
    private final int maxProcessPerTick;
    private final Runnable markDirty;
    private final Runnable onQueueChange;
    private final BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID;

    public MultiblockProcessor(int maxQueueLength, float minDelayAfter, int maxProcessPerTick, Runnable markDirty, BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID) {
        this(maxQueueLength, $ -> minDelayAfter, maxProcessPerTick, markDirty, () -> {}, getRecipeFromID);
    }

    public MultiblockProcessor(int maxQueueLength, IntToDoubleFunction minDelayAfter, int maxProcessPerTick, Runnable markDirty, Runnable onQueueChange, BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID) {
        this.maxQueueLength = maxQueueLength;
        this.minDelayAfter = minDelayAfter;
        this.maxProcessPerTick = maxProcessPerTick;
        this.markDirty = markDirty;
        this.onQueueChange = onQueueChange;
        this.getRecipeFromID = getRecipeFromID;
    }

    public boolean tickServer(CTX ctx, IMultiblockLevel level, boolean canWork) {
        ctx.getEnergy().updateAverage();
        if (!canWork) {
            return false;
        }
        int i = 0;
        Iterator<MultiblockProcess<R, CTX>> processIterator = this.processQueue.iterator();
        boolean tickedAny = false;
        while (processIterator.hasNext() && i++ < this.maxProcessPerTick) {
            MultiblockProcess<R, CTX> process = processIterator.next();
            if (process.canProcess(ctx, level.getRawLevel())) {
                process.doProcessTick(ctx, level);
                tickedAny = true;
            }
            if (!process.clearProcess) continue;
            processIterator.remove();
            this.onQueueChange.run();
        }
        if (tickedAny) {
            this.markDirty.run();
        }
        return tickedAny;
    }

    public Tag toNBT(HolderLookup.Provider provider) {
        ListTag processList = new ListTag();
        for (MultiblockProcess<R, CTX> process : this.processQueue) {
            CompoundTag tag = new CompoundTag();
            tag.putString("recipe", process.getRecipeId().toString());
            tag.putInt("process_processTick", process.processTick);
            process.writeExtraDataToNBT(tag, provider);
            processList.add((Object)tag);
        }
        return processList;
    }

    public void fromNBT(Tag nbt, ProcessLoader<R, CTX> loader, HolderLookup.Provider provider) {
        if (!(nbt instanceof ListTag)) {
            return;
        }
        ListTag list = (ListTag)nbt;
        this.processQueue.clear();
        for (Tag tag : list) {
            CompoundTag processTag;
            MultiblockProcess<R, CTX> loadedProcess;
            if (!(tag instanceof CompoundTag) || (loadedProcess = loader.fromNBT(this.getRecipeFromID, processTag = (CompoundTag)tag, provider)) == null) continue;
            this.processQueue.add(loadedProcess);
        }
    }

    public BiFunction<Level, ResourceLocation, R> recipeGetter() {
        return this.getRecipeFromID;
    }

    public boolean addProcessToQueue(MultiblockProcess<R, CTX> process, Level level, boolean simulate) {
        return this.addProcessToQueue(process, level, simulate, false);
    }

    public boolean addProcessToQueue(MultiblockProcess<R, CTX> process, Level level, boolean simulate, boolean addToPrevious) {
        if (addToPrevious && process instanceof MultiblockProcessInWorld) {
            MultiblockProcessInWorld newProcess = (MultiblockProcessInWorld)process;
            for (MultiblockProcess<R, CTX> curr : this.processQueue) {
                if (!(curr instanceof MultiblockProcessInWorld) || !process.getRecipeId().equals((Object)curr.getRecipeId())) continue;
                boolean canStack = true;
                MultiblockProcessInWorld existingProcess = (MultiblockProcessInWorld)curr;
                for (ItemStack old : existingProcess.inputItems) {
                    for (ItemStack in : newProcess.inputItems) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)old, (ItemStack)in) || old.getCount() + in.getCount() <= old.getMaxStackSize()) continue;
                        canStack = false;
                        break;
                    }
                    if (canStack) continue;
                    break;
                }
                if (!canStack) continue;
                if (!simulate) {
                    block3: for (ItemStack old : existingProcess.inputItems) {
                        for (ItemStack in : newProcess.inputItems) {
                            if (!ItemStack.isSameItemSameComponents((ItemStack)old, (ItemStack)in)) continue;
                            old.grow(in.getCount());
                            continue block3;
                        }
                    }
                }
                return true;
            }
        }
        if (this.maxQueueLength < 0 || this.processQueue.size() < this.maxQueueLength) {
            int maxTime;
            MultiblockProcess<R, CTX> previousProcess;
            float dist;
            if (!this.processQueue.isEmpty() && (double)(dist = (float)previousProcess.processTick / (float)(maxTime = (previousProcess = this.processQueue.get(this.processQueue.size() - 1)).getMaxTicks(level))) < this.minDelayAfter.applyAsDouble(maxTime)) {
                return false;
            }
            if (!simulate) {
                this.processQueue.add(process);
            }
            this.markDirty.run();
            this.onQueueChange.run();
            return true;
        }
        return false;
    }

    public int getMaxQueueSize() {
        return this.maxQueueLength;
    }

    public int getQueueSize() {
        return this.processQueue.size();
    }

    public float getQueueFill(boolean allowStacking) {
        if (this.maxQueueLength <= 0) {
            return 0.0f;
        }
        if (!allowStacking) {
            return (float)this.getQueueSize() / (float)this.maxQueueLength;
        }
        return this.getQueue().stream().map(process -> {
            if (process instanceof MultiblockProcessInWorld) {
                MultiblockProcessInWorld inWorld = (MultiblockProcessInWorld)process;
                float f = 0.0f;
                for (ItemStack stack : inWorld.inputItems) {
                    if (stack.isEmpty()) continue;
                    f = (float)stack.getCount() / (float)stack.getMaxStackSize();
                }
                return Float.valueOf(f / (float)inWorld.inputItems.size());
            }
            return Float.valueOf(1.0f);
        }).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue() / (float)this.maxQueueLength;
    }

    public MachineInterfaceHandler.CheckOption<MultiblockProcessor<R, CTX>>[] getMachineInterfaceOptions(boolean allowStacking) {
        return MachineInterfaceHandler.buildComparativeConditions(value -> value.getQueueFill(allowStacking));
    }

    public List<MultiblockProcess<R, CTX>> getQueue() {
        return Collections.unmodifiableList(this.processQueue);
    }

    public void clear() {
        this.processQueue.clear();
        this.markDirty.run();
        this.onQueueChange.run();
    }

    public static interface ProcessLoader<R extends MultiblockRecipe, CTX extends ProcessContext<R>> {
        public MultiblockProcess<R, CTX> fromNBT(BiFunction<Level, ResourceLocation, R> var1, CompoundTag var2, HolderLookup.Provider var3);
    }

    public static interface InWorldProcessLoader<R extends MultiblockRecipe>
    extends ProcessLoader<R, ProcessContext.ProcessContextInWorld<R>> {
    }

    public static class InMachineProcessor<R extends MultiblockRecipe>
    extends MultiblockProcessor<R, ProcessContext.ProcessContextInMachine<R>> {
        public InMachineProcessor(int maxQueueLength, float minDelayAfter, int maxProcessPerTick, Runnable markDirty, BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID) {
            super(maxQueueLength, minDelayAfter, maxProcessPerTick, markDirty, getRecipeFromID);
        }

        public InMachineProcessor(int maxQueueLength, IntToDoubleFunction minDelayAfter, int maxProcessPerTick, Runnable markDirty, Runnable onQueueChange, BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID) {
            super(maxQueueLength, minDelayAfter, maxProcessPerTick, markDirty, onQueueChange, getRecipeFromID);
        }
    }

    public static class InWorldProcessor<R extends MultiblockRecipe>
    extends MultiblockProcessor<R, ProcessContext.ProcessContextInWorld<R>> {
        public InWorldProcessor(int maxQueueLength, IntToDoubleFunction minDelayAfter, int maxProcessPerTick, Runnable markDirty, Runnable onQueueChange, BiFunction<Level, ResourceLocation, @Nullable R> getRecipeFromID) {
            super(maxQueueLength, minDelayAfter, maxProcessPerTick, markDirty, onQueueChange, getRecipeFromID);
        }
    }
}

