/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.upgrade;

import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.utils.codec.IECodecs;
import com.mojang.datafixers.util.Unit;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;

public record UpgradeData(List<UpgradeEntry<?>> entries) {
    public static final DualCodec<ByteBuf, UpgradeData> CODECS = UpgradeEntry.CODECS.listOf().map(UpgradeData::new, UpgradeData::entries);
    public static final DualCodec<ByteBuf, UpgradeData> SPECIAL_REVOLVER_CODEC = new DualCodec(IECodecs.directDispatchMap(s -> UpgradeEffect.get(s).entryCodec().codec(), e -> e.type.name()).xmap(UpgradeData::new, UpgradeData::entries), CODECS.streamCodec());
    public static final UpgradeData EMPTY = new UpgradeData(List.of());

    public UpgradeData {
        entries = List.copyOf(entries);
    }

    public <T> boolean has(UpgradeEffect<T> effect) {
        return this.getIndex(effect) >= 0;
    }

    public <T> T get(UpgradeEffect<T> effect) {
        int i = this.getIndex(effect);
        if (i >= 0) {
            return this.entries.get((int)i).value;
        }
        return effect.defaultValue();
    }

    public UpgradeData with(UpgradeEffect<Unit> effect) {
        return this.with(effect, Unit.INSTANCE);
    }

    public <T> UpgradeData with(UpgradeEffect<T> effect, T newValue) {
        return this.withModified(effect, $ -> newValue);
    }

    public <T> UpgradeData withModified(UpgradeEffect<T> effect, UnaryOperator<T> modify) {
        int i = this.getIndex(effect);
        ArrayList newEntries = new ArrayList(this.entries);
        if (i >= 0) {
            newEntries.set(i, new UpgradeEntry<T>(effect, modify.apply(this.entries.get((int)i).value)));
        } else {
            newEntries.add(new UpgradeEntry<T>(effect, modify.apply(effect.defaultValue())));
        }
        return new UpgradeData(newEntries);
    }

    private int getIndex(UpgradeEffect<?> effect) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get((int)i).type != effect) continue;
            return i;
        }
        return -1;
    }

    public UpgradeData add(UpgradeEffect<Integer> effect, int i) {
        return this.withModified(effect, a -> a + i);
    }

    public UpgradeData add(UpgradeEffect<Float> effect, float i) {
        return this.withModified(effect, a -> Float.valueOf(a.floatValue() + i));
    }

    public record UpgradeEntry<T>(UpgradeEffect<T> type, T value) {
        public static final DualCodec<ByteBuf, UpgradeEntry<?>> CODECS = DualCodecs.STRING.dispatch(e -> e.type.name(), s -> UpgradeEffect.get(s).entryCodec().fieldOf("data"));
    }
}

