/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.links.EntryWithLinks;
import blusunrize.lib.manual.links.Link;
import blusunrize.lib.manual.utils.ManualLogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;

public class TextSplitter {
    public static final String START = "start";
    private final Function<String, Integer> width;
    private final int lineWidth;
    private final IntSupplier pixelsPerLine;
    private final Map<String, Map<Integer, SpecialManualElement>> specialByAnchor = new HashMap<String, Map<Integer, SpecialManualElement>>();
    private final Function<String, String> tokenTransform;
    private final int pixelsPerPage;

    public TextSplitter(Function<String, Integer> w, int lineWidthPixel, int pageHeightPixel, IntSupplier pixelsPerLine, Function<String, String> tokenTransform) {
        this.width = w;
        this.lineWidth = lineWidthPixel;
        this.pixelsPerPage = pageHeightPixel;
        this.pixelsPerLine = pixelsPerLine;
        this.tokenTransform = tokenTransform;
        this.clearSpecialByAnchor();
    }

    public TextSplitter(ManualInstance m) {
        this(m, Function.identity());
    }

    public TextSplitter(ManualInstance m, Function<String, String> tokenTransform) {
        this(m.fontRenderer(), m.pageWidth, m.pageHeight, tokenTransform.andThen(s -> {
            String extraFormat = ChatFormatting.BOLD.toString();
            if (m.improveReadability() && ((String)s).charAt(0) != '<' && !((String)s).trim().isEmpty()) {
                for (ChatFormatting f : ChatFormatting.values()) {
                    if (f.isFormat()) continue;
                    s = ((String)s).replace(f.toString(), String.valueOf(f) + extraFormat);
                }
                s = extraFormat + (String)s;
            }
            return s;
        }));
    }

    public TextSplitter(Font fontRenderer, int width, int height, Function<String, String> tokenTransform) {
        this(arg_0 -> ((Font)fontRenderer).width(arg_0), width, height, () -> {
            Objects.requireNonNull(fontRenderer);
            return 9;
        }, tokenTransform);
    }

    public void clearSpecialByAnchor() {
        this.specialByAnchor.clear();
        this.specialByAnchor.put(START, new HashMap());
    }

    public void addSpecialPage(String ref, int offset, SpecialManualElement element) {
        if (offset < 0 || ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.specialByAnchor.containsKey(ref)) {
            this.specialByAnchor.put(ref, new HashMap());
        }
        this.specialByAnchor.get(ref).put(offset, element);
    }

    public SplitResult split(String in) {
        return this.split(EntryWithLinks.splitWhitespace(in).stream().map(Either::left).collect(Collectors.toList()));
    }

    public SplitResult split(List<Either<String, Link>> unsizedTokens) {
        int n;
        for (Map<Integer, SpecialManualElement> forAnchor : this.specialByAnchor.values()) {
            for (SpecialManualElement e : forAnchor.values()) {
                e.recalculateCraftingRecipes();
            }
        }
        ArrayList<List<List<SplitResult.Token>>> entry = new ArrayList<List<List<SplitResult.Token>>>();
        Object2IntOpenHashMap pageByAnchor = new Object2IntOpenHashMap();
        pageByAnchor.put((Object)START, 0);
        List<TokenWithWidth> wordsAndSpaces = this.convertToSplitterTokens(unsizedTokens);
        NextPageData pageOverflow = new NextPageData();
        while (pageOverflow != null && pageOverflow.topLine != null) {
            Page nextPage = this.parsePage(pageOverflow, wordsAndSpaces, arg_0 -> this.lambda$split$2(entry, (Object2IntMap)pageByAnchor, arg_0), arg_0 -> this.lambda$split$3((Object2IntMap)pageByAnchor, entry, arg_0));
            nextPage.anchorsOnPage.forEach(arg_0 -> TextSplitter.lambda$split$4((Object2IntMap)pageByAnchor, entry, arg_0));
            entry.add(nextPage.lines);
            pageOverflow = nextPage.nextPage;
        }
        for (List list : entry) {
            for (List line : list) {
                for (int i = 0; i < line.size(); ++i) {
                    SplitResult.Token t = (SplitResult.Token)line.get(i);
                    line.set(i, ((SplitResult.Token)line.get(i)).replace('\u00a0', ' '));
                }
            }
        }
        Int2ObjectOpenHashMap specialByPage = new Int2ObjectOpenHashMap();
        boolean bl = false;
        for (Object2IntMap.Entry forAnchor : pageByAnchor.object2IntEntrySet()) {
            for (Map.Entry<Integer, SpecialManualElement> element : this.getElements((String)forAnchor.getKey()).entrySet()) {
                int page = forAnchor.getIntValue() + element.getKey();
                Preconditions.checkState((!specialByPage.containsKey(page) ? 1 : 0) != 0);
                specialByPage.put(page, (Object)element.getValue());
                if (page <= n) continue;
                n = page;
            }
        }
        while (entry.size() <= n) {
            entry.add(new ArrayList());
        }
        return new SplitResult(entry, (Object2IntMap<String>)pageByAnchor, (Int2ObjectMap<SpecialManualElement>)specialByPage);
    }

    private boolean noCollidingElements(List<String> newAnchors, int anchorPage, Object2IntMap<String> pageByAnchor) {
        IntArraySet pagesWithSpecials = new IntArraySet();
        for (String newAnchor : newAnchors) {
            for (int offset : this.getElements(newAnchor).keySet()) {
                if (pagesWithSpecials.add(offset + anchorPage)) continue;
                return false;
            }
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            for (int offset : this.getElements((String)e.getKey()).keySet()) {
                if (pagesWithSpecials.add(offset + e.getIntValue())) continue;
                return false;
            }
        }
        return true;
    }

    private Optional<SpecialManualElement> findElement(Object2IntMap<String> pageByAnchor, int newAnchorPage, List<String> newAnchors) {
        for (String newAnchor : newAnchors) {
            Map<Integer, SpecialManualElement> forNewAnchor = this.getElements(newAnchor);
            if (!forNewAnchor.containsKey(0)) continue;
            return Optional.of(forNewAnchor.get(0));
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            int offset;
            Map<Integer, SpecialManualElement> forAnchor = this.getElements((String)e.getKey());
            if (!forAnchor.containsKey(offset = newAnchorPage - e.getIntValue())) continue;
            return Optional.of(forAnchor.get(offset));
        }
        return Optional.empty();
    }

    private Map<Integer, SpecialManualElement> getElements(String anchor) {
        if (!this.specialByAnchor.containsKey(anchor)) {
            ManualLogger.LOGGER.warn("Tried to access invalid anchor \"{}\"", (Object)anchor);
            return ImmutableMap.of();
        }
        return this.specialByAnchor.get(anchor);
    }

    private Page parsePage(NextPageData overflow, List<TokenWithWidth> wordsAndSpaces, Predicate<List<String>> canPlaceAnchors, Function<List<String>, Integer> getLines) {
        ArrayList<List<SplitResult.Token>> page = new ArrayList<List<SplitResult.Token>>();
        NextLineData lineOverflow = overflow.topLine;
        ArrayList<String> anchorsOnPage = new ArrayList<String>();
        while (page.size() < getLines.apply(anchorsOnPage) && lineOverflow != null) {
            Function<List<String>, AnchorViability> getAnchorViability = anchors -> {
                ArrayList withNewAnchor = new ArrayList(anchorsOnPage);
                withNewAnchor.addAll(anchors);
                if (!canPlaceAnchors.test(withNewAnchor)) {
                    return AnchorViability.NOT_VALID;
                }
                if (page.size() + 1 > (Integer)getLines.apply(withNewAnchor)) {
                    return AnchorViability.VALID_IF_ALONE;
                }
                return AnchorViability.VALID;
            };
            Line next = this.parseLine(lineOverflow, getAnchorViability, wordsAndSpaces);
            AnchorViability viability = getAnchorViability.apply(next.anchorsBeforeLine);
            Preconditions.checkState((viability != AnchorViability.NOT_VALID ? 1 : 0) != 0);
            if (viability == AnchorViability.VALID_IF_ALONE && !page.isEmpty()) break;
            anchorsOnPage.addAll(next.anchorsBeforeLine);
            if (!page.isEmpty() || !next.line.isEmpty()) {
                page.add(next.line);
            }
            if ((lineOverflow = next.overflow) == null || !lineOverflow.putOnNewPage) continue;
            break;
        }
        while (!page.isEmpty() && ((List)page.get(page.size() - 1)).stream().allMatch(t -> t.getText().trim().isEmpty())) {
            page.remove(page.size() - 1);
        }
        return new Page(page, anchorsOnPage, lineOverflow);
    }

    private Line parseLine(NextLineData lastOverflow, Function<List<String>, AnchorViability> canPlaceAnchors, List<TokenWithWidth> wordsAndSpaces) {
        int currentWidth;
        int pos = lastOverflow.firstToken;
        ArrayList<String> anchorsBeforeLine = new ArrayList<String>();
        ArrayList<TokenWithWidth> lineTokens = new ArrayList<TokenWithWidth>();
        if (!lastOverflow.overflow.getText().isEmpty()) {
            int overflowLength = this.getWidth(lastOverflow.overflow.getText());
            lineTokens.add(new TokenWithWidth(lastOverflow.overflow, overflowLength));
            currentWidth = overflowLength;
        } else {
            currentWidth = 0;
        }
        while (this.canAddToLine(wordsAndSpaces, currentWidth, pos)) {
            TokenWithWidth token = wordsAndSpaces.get(pos);
            if (token.getText().equals("<np>")) {
                return new Line(lineTokens, pos + 1, true, anchorsBeforeLine);
            }
            if (this.isLinebreak(token.getText())) {
                return new Line(lineTokens, pos + 1, false, anchorsBeforeLine);
            }
            if (token.getText().startsWith("<&") && token.getText().endsWith(">")) {
                String anchor = this.toAnchor(token.getText());
                ArrayList<String> withNewAdded = new ArrayList<String>(anchorsBeforeLine);
                withNewAdded.add(anchor);
                AnchorViability allowed = canPlaceAnchors.apply(withNewAdded);
                if (allowed == AnchorViability.VALID_IF_ALONE && currentWidth == 0 && anchorsBeforeLine.isEmpty()) {
                    return new Line((List<TokenWithWidth>)ImmutableList.of(), pos + 1, true, (List<String>)ImmutableList.of((Object)anchor));
                }
                if (allowed != AnchorViability.VALID) {
                    return new Line(lineTokens, pos, true, anchorsBeforeLine);
                }
                anchorsBeforeLine.add(anchor);
            } else if (!token.baseToken.isWhitespace() || currentWidth != 0) {
                lineTokens.add(token);
                currentWidth += token.width;
            }
            ++pos;
        }
        if ((currentWidth = this.removeEndWhitespace(lineTokens, currentWidth)) > this.lineWidth) {
            TokenWithWidth lastToken = (TokenWithWidth)lineTokens.get(lineTokens.size() - 1);
            String lastTokenText = lastToken.getText();
            int trimTo = this.lineWidth - (currentWidth - lastToken.width);
            Object upToWidth = "";
            for (int i = 0; i < lastTokenText.length() && this.getWidth((String)upToWidth) < trimTo; ++i) {
                upToWidth = (String)upToWidth + lastTokenText.charAt(i);
            }
            String overflowText = lastTokenText.substring(((String)upToWidth).length());
            SplitResult.Token overflow = lastToken.baseToken.copyWithText(overflowText);
            TokenWithWidth trimmedLastToken = lastToken.copyWithText((String)upToWidth, trimTo);
            lineTokens.set(lineTokens.size() - 1, trimmedLastToken);
            return new Line(lineTokens, pos, false, anchorsBeforeLine, overflow);
        }
        if (pos < wordsAndSpaces.size()) {
            return new Line(lineTokens, pos, false, anchorsBeforeLine);
        }
        return new Line(lineTokens, null, anchorsBeforeLine);
    }

    private boolean canAddToLine(List<TokenWithWidth> allTokens, int currentWidth, int nextToken) {
        if (nextToken >= allTokens.size()) {
            return false;
        }
        return currentWidth == 0 || currentWidth + allTokens.get((int)nextToken).width <= this.lineWidth;
    }

    private int removeEndWhitespace(List<TokenWithWidth> tokens, int totalLength) {
        int lastIndex = tokens.size() - 1;
        while (!tokens.isEmpty() && tokens.get((int)lastIndex).baseToken.isWhitespace()) {
            totalLength -= tokens.remove((int)lastIndex--).width;
        }
        if (lastIndex >= 0) {
            TokenWithWidth lastToken = tokens.get(lastIndex);
            Object newText = lastToken.getText().trim();
            StringBuilder postFormat = new StringBuilder();
            while (((String)newText).length() >= 2 && ((String)newText).charAt(((String)newText).length() - 2) == '\u00a7') {
                postFormat.insert(0, ((String)newText).substring(((String)newText).length() - 2));
                newText = ((String)newText).substring(0, ((String)newText).length() - 2).trim();
            }
            if (!((String)(newText = (String)newText + String.valueOf(postFormat))).equals(lastToken.getText())) {
                tokens.set(lastIndex, lastToken.copyWithText((String)newText, this.getWidth((String)newText)));
            }
        }
        return totalLength;
    }

    private String toAnchor(String token) {
        return token.substring(2, token.length() - 1);
    }

    private int getWidth(String text) {
        if (this.isLinebreak(text)) {
            return 0;
        }
        switch (text) {
            case "<br>": 
            case "<np>": {
                return 0;
            }
        }
        return this.width.apply(text);
    }

    private int getLinesOnPage(Optional<SpecialManualElement> elementOnPage) {
        int pixels = this.pixelsPerPage;
        if (elementOnPage.isPresent()) {
            pixels = this.pixelsPerPage - elementOnPage.get().getPixelsTaken();
        }
        return Mth.floor((double)((double)pixels / (double)this.pixelsPerLine.getAsInt()));
    }

    private List<TokenWithWidth> convertToSplitterTokens(List<Either<String, Link>> rawTokens) {
        ArrayList<TokenWithWidth> ret = new ArrayList<TokenWithWidth>(rawTokens.size());
        for (Either<String, Link> e : rawTokens) {
            e.ifLeft(s -> {
                String transformed = this.tokenTransform.apply((String)s);
                ret.add(new TokenWithWidth((Either<String, SplitResult.LinkPart>)Either.left((Object)transformed), this.getWidth(transformed)));
            });
            e.ifRight(l -> l.getParts().stream().map(this.tokenTransform).map(s -> new TokenWithWidth((Either<String, SplitResult.LinkPart>)Either.right((Object)new SplitResult.LinkPart((Link)l, (String)s)), this.getWidth((String)s))).forEach(ret::add));
        }
        return ret;
    }

    private boolean isLinebreak(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$split$4(Object2IntMap pageByAnchor, List entry, String anchor) {
        pageByAnchor.put((Object)anchor, entry.size());
    }

    private /* synthetic */ Integer lambda$split$3(Object2IntMap pageByAnchor, List entry, List str) {
        Optional<SpecialManualElement> element = this.findElement((Object2IntMap<String>)pageByAnchor, entry.size(), str);
        return this.getLinesOnPage(element);
    }

    private /* synthetic */ boolean lambda$split$2(List entry, Object2IntMap pageByAnchor, List anchors) {
        return this.noCollidingElements(anchors, entry.size(), (Object2IntMap<String>)pageByAnchor);
    }

    private static class NextPageData {
        private final NextLineData topLine;

        private NextPageData(NextLineData topLine) {
            this.topLine = topLine;
        }

        public NextPageData() {
            this(new NextLineData(0, false, new SplitResult.Token((Either<String, SplitResult.LinkPart>)Either.left((Object)""))));
        }
    }

    private static class NextLineData {
        private final int firstToken;
        private final boolean putOnNewPage;
        private final SplitResult.Token overflow;

        private NextLineData(int firstToken, boolean putOnNewPage, SplitResult.Token overflow) {
            this.firstToken = firstToken;
            this.putOnNewPage = putOnNewPage;
            this.overflow = overflow;
        }
    }

    private static class Page {
        private final List<List<SplitResult.Token>> lines;
        private final List<String> anchorsOnPage;
        private final NextPageData nextPage;

        private Page(List<List<SplitResult.Token>> lines, List<String> anchorsOnPage, NextPageData nextPage) {
            this.lines = lines;
            this.anchorsOnPage = anchorsOnPage;
            this.nextPage = nextPage;
        }

        public Page(List<List<SplitResult.Token>> page, List<String> anchorsOnPage, NextLineData overflow) {
            this(page, anchorsOnPage, overflow == null ? null : new NextPageData(overflow));
        }
    }

    private static class Line {
        private final List<SplitResult.Token> line;
        private final NextLineData overflow;
        private final List<String> anchorsBeforeLine;

        private Line(List<TokenWithWidth> line, NextLineData overflow, List<String> anchorsBeforeLine) {
            this.line = line.stream().map(t -> t.baseToken).collect(Collectors.toList());
            this.overflow = overflow;
            this.anchorsBeforeLine = anchorsBeforeLine;
        }

        public Line(List<TokenWithWidth> line, int firstToken, boolean endPageAfterLine, List<String> anchorBeforeLine, SplitResult.Token textOverflow) {
            this(line, new NextLineData(firstToken, endPageAfterLine, textOverflow.copyWithText(Line.getFormattingAtEnd(line) + textOverflow.getText())), anchorBeforeLine);
        }

        public Line(List<TokenWithWidth> line, int firstToken, boolean endPageAfterLine, List<String> anchorBeforeLine) {
            this(line, firstToken, endPageAfterLine, anchorBeforeLine, new SplitResult.Token(""));
        }

        private static String getFormattingAtEnd(List<TokenWithWidth> tokens) {
            ArrayList<ChatFormatting> ret = new ArrayList<ChatFormatting>();
            for (TokenWithWidth token : tokens) {
                String tokenText = token.getText();
                int start = -1;
                while ((start = tokenText.indexOf(167, start + 1)) != -1) {
                    ChatFormatting textformatting;
                    if (start >= tokenText.length() - 1 || (textformatting = ChatFormatting.getByCode((char)tokenText.charAt(start + 1))) == null) continue;
                    if (!textformatting.isFormat()) {
                        ret.clear();
                    }
                    if (textformatting == ChatFormatting.RESET) continue;
                    ret.remove(textformatting);
                    ret.add(textformatting);
                }
            }
            return ret.stream().map(ChatFormatting::toString).collect(Collectors.joining());
        }
    }

    private static enum AnchorViability {
        NOT_VALID,
        VALID,
        VALID_IF_ALONE;

    }

    private static class TokenWithWidth {
        private final SplitResult.Token baseToken;
        private final int width;

        private TokenWithWidth(Either<String, SplitResult.LinkPart> text, int width) {
            this(new SplitResult.Token(text), width);
        }

        private TokenWithWidth(SplitResult.Token text, int width) {
            this.baseToken = text;
            this.width = width;
        }

        public String getText() {
            return this.baseToken.getText();
        }

        public TokenWithWidth copyWithText(String text, int newWidth) {
            return new TokenWithWidth(this.baseToken.copyWithText(text), newWidth);
        }
    }
}

