/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TemplateMultiblock
implements MultiblockHandler.IMultiblock {
    private static final SetRestrictedField<Function<BlockState, ItemStack>> PICK_BLOCK = SetRestrictedField.common();
    private static final SetRestrictedField<Function<StructureTemplate, List<StructureTemplate.Palette>>> GET_PALETTES = SetRestrictedField.common();
    public static final Map<ResourceLocation, StructureTemplate> SYNCED_CLIENT_TEMPLATES = new HashMap<ResourceLocation, StructureTemplate>();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation loc;
    protected final BlockPos masterFromOrigin;
    protected final BlockPos triggerFromOrigin;
    protected final BlockPos size;
    protected final List<BlockMatcher.MatcherPredicate> additionalPredicates;
    @Nullable
    private TemplateData template;

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, List<BlockMatcher.MatcherPredicate> additionalPredicates) {
        this.loc = loc;
        this.masterFromOrigin = masterFromOrigin;
        this.triggerFromOrigin = triggerFromOrigin;
        this.size = size;
        this.additionalPredicates = additionalPredicates;
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size) {
        this(loc, masterFromOrigin, triggerFromOrigin, size, (Map<Block, TagKey<Block>>)ImmutableMap.of());
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, Map<Block, TagKey<Block>> tags) {
        this(loc, masterFromOrigin, triggerFromOrigin, size, (List<BlockMatcher.MatcherPredicate>)ImmutableList.of((expected, found, world, pos) -> {
            TagKey tag = (TagKey)tags.get(expected.getBlock());
            if (tag != null) {
                if (found.is(tag)) {
                    return BlockMatcher.Result.allow(2);
                }
                return BlockMatcher.Result.deny(2);
            }
            return BlockMatcher.Result.DEFAULT;
        }));
    }

    public ResourceLocation getTemplateLocation() {
        return this.loc;
    }

    @Nonnull
    public TemplateData getTemplate(@Nonnull Level level) {
        this.ensureStructureInitialized(level);
        return Objects.requireNonNull(this.template);
    }

    private void ensureStructureInitialized(@Nonnull Level level) {
        StructureTemplate newTemplate;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            newTemplate = serverLevel.getStructureManager().get(this.loc).orElse(null);
        } else {
            if (!(DatagenModLoader.isRunningDataGen() || level != null && level.isClientSide)) {
                throw new RuntimeException("Unexpected level parameter: " + String.valueOf(level));
            }
            newTemplate = SYNCED_CLIENT_TEMPLATES.get(this.loc);
        }
        if (newTemplate == null) {
            throw new RuntimeException("Template " + String.valueOf(this.loc) + " does not exist!");
        }
        if (this.template != null && newTemplate == this.template.template) {
            return;
        }
        ArrayList<StructureTemplate.StructureBlockInfo> blocksWithoutAir = new ArrayList<StructureTemplate.StructureBlockInfo>(TemplateMultiblock.getStructureFromTemplate(newTemplate));
        Iterator it = blocksWithoutAir.iterator();
        BlockState trigger = null;
        while (it.hasNext()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)it.next();
            if (info.pos().equals((Object)this.triggerFromOrigin)) {
                trigger = info.state();
            }
            if (info.state() == Blocks.AIR.defaultBlockState()) {
                it.remove();
                continue;
            }
            if (!info.state().isAir()) continue;
            LOGGER.error("Found non-default air block in template {}", (Object)this.loc);
        }
        Preconditions.checkState((trigger != null ? 1 : 0) != 0, (Object)("Trigger state was not found in template for " + String.valueOf(this.loc)));
        this.template = new TemplateData(newTemplate, blocksWithoutAir, trigger);
    }

    @Override
    public ResourceLocation getUniqueName() {
        return this.loc;
    }

    @Override
    public boolean isBlockTrigger(BlockState state, Direction d, @Nonnull Level world) {
        this.getTemplate(world);
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, d.getOpposite());
        if (rot == null) {
            return false;
        }
        BlockState trigger = this.getTemplate((Level)world).triggerState;
        for (Mirror mirror : this.getPossibleMirrorStates()) {
            BlockState modifiedTrigger = this.applyToState(trigger, mirror, rot);
            if (!BlockMatcher.matches(modifiedTrigger, state, null, null, this.additionalPredicates).isAllow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean createStructure(Level world, BlockPos pos, Direction side, Player player) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, side.getOpposite());
        if (rot == null) {
            return false;
        }
        List<StructureTemplate.StructureBlockInfo> structure = this.getStructure(world);
        block0: for (Mirror mirror : this.getPossibleMirrorStates()) {
            StructurePlaceSettings placeSet = new StructurePlaceSettings().setMirror(mirror).setRotation(rot);
            BlockPos origin = pos.subtract((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)placeSet, (BlockPos)this.triggerFromOrigin));
            for (StructureTemplate.StructureBlockInfo info : structure) {
                BlockState inWorld;
                BlockPos realRelPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)placeSet, (BlockPos)info.pos());
                BlockPos here = origin.offset((Vec3i)realRelPos);
                BlockState expected = this.applyToState(info.state(), mirror, rot);
                if (BlockMatcher.matches(expected, inWorld = world.getBlockState(here), world, here, this.additionalPredicates).isAllow()) continue;
                continue block0;
            }
            if (!world.isClientSide) {
                this.form(world, origin, rot, mirror, side);
            }
            return true;
        }
        return false;
    }

    private BlockState applyToState(BlockState in, Mirror m, Rotation r) {
        return in.mirror(m).rotate(r);
    }

    private List<Mirror> getPossibleMirrorStates() {
        if (this.canBeMirrored()) {
            return ImmutableList.of((Object)Mirror.NONE, (Object)Mirror.FRONT_BACK);
        }
        return ImmutableList.of((Object)Mirror.NONE);
    }

    protected void form(Level world, BlockPos pos, Rotation rot, Mirror mirror, Direction sideHit) {
        BlockPos masterPos = TemplateMultiblock.withSettingsAndOffset(pos, this.masterFromOrigin, mirror, rot);
        for (StructureTemplate.StructureBlockInfo block : this.getStructure(world)) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(pos, block.pos(), mirror, rot);
            this.replaceStructureBlock(block, world, actualPos, mirror != Mirror.NONE, sideHit, (Vec3i)actualPos.subtract((Vec3i)masterPos));
        }
    }

    public BlockPos getMasterFromOriginOffset() {
        return this.masterFromOrigin;
    }

    protected abstract void replaceStructureBlock(StructureTemplate.StructureBlockInfo var1, Level var2, BlockPos var3, boolean var4, Direction var5, Vec3i var6);

    @Override
    public List<StructureTemplate.StructureBlockInfo> getStructure(@Nonnull Level world) {
        return this.getTemplate(world).blocksWithoutAir();
    }

    private static List<StructureTemplate.StructureBlockInfo> getStructureFromTemplate(StructureTemplate template) {
        return GET_PALETTES.get().apply(template).get(0).blocks();
    }

    @Override
    public Vec3i getSize(@Nonnull Level world) {
        return this.getTemplate(world).template().getSize();
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, Mirror mirror, Rotation rot) {
        return origin.offset((Vec3i)TemplateMultiblock.getAbsoluteOffset(relative, mirror, rot));
    }

    public static BlockPos getAbsoluteOffset(BlockPos relative, Mirror mirror, Rotation rot) {
        StructurePlaceSettings settings = new StructurePlaceSettings().setMirror(mirror).setRotation(rot);
        return StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)relative);
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, boolean mirrored, Direction facing) {
        return origin.offset((Vec3i)TemplateMultiblock.getAbsoluteOffset(relative, mirrored, facing));
    }

    public static BlockPos getAbsoluteOffset(BlockPos relative, boolean mirrored, Direction facing) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, facing);
        if (rot == null) {
            return BlockPos.ZERO;
        }
        return TemplateMultiblock.getAbsoluteOffset(relative, mirrored ? Mirror.FRONT_BACK : Mirror.NONE, rot);
    }

    @Override
    public void disassemble(Level world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, clickDirectionAtCreation);
        Preconditions.checkNotNull((Object)rot);
        for (StructureTemplate.StructureBlockInfo block : this.getStructure(world)) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(origin, block.pos(), mirror, rot);
            this.prepareBlockForDisassembly(world, actualPos);
            world.setBlockAndUpdate(actualPos, this.applyToState(block.state(), mirror, rot));
        }
    }

    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
    }

    @Override
    public BlockPos getTriggerOffset() {
        return this.triggerFromOrigin;
    }

    public boolean canBeMirrored() {
        return true;
    }

    public static void setCallbacks(Function<BlockState, ItemStack> pickBlock, Function<StructureTemplate, List<StructureTemplate.Palette>> getPalettes) {
        PICK_BLOCK.setValue(pickBlock);
        GET_PALETTES.setValue(getPalettes);
    }

    public record TemplateData(StructureTemplate template, List<StructureTemplate.StructureBlockInfo> blocksWithoutAir, BlockState triggerState) {
    }
}

