/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SqueezerRecipeBuilder
extends IERecipeBuilder<SqueezerRecipeBuilder>
implements BaseHelpers.ItemInput<SqueezerRecipeBuilder>,
BaseHelpers.ItemOutput<SqueezerRecipeBuilder> {
    private IngredientWithSize input;
    private FluidStack fluidOutput = FluidStack.EMPTY;
    private TagOutput itemOutput = TagOutput.EMPTY;
    private int energy;

    private SqueezerRecipeBuilder() {
    }

    public static SqueezerRecipeBuilder builder() {
        return new SqueezerRecipeBuilder();
    }

    @Override
    public SqueezerRecipeBuilder input(IngredientWithSize input) {
        this.input = input;
        return this;
    }

    @Override
    public SqueezerRecipeBuilder output(TagOutput output) {
        this.itemOutput = output;
        return this;
    }

    public SqueezerRecipeBuilder output(Fluid output, int amount) {
        return this.output(new FluidStack(output, amount));
    }

    public SqueezerRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public SqueezerRecipeBuilder output(FluidStack output) {
        this.fluidOutput = output;
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        SqueezerRecipe recipe = new SqueezerRecipe(this.fluidOutput, this.itemOutput, this.input, this.energy);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

