/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;

public class MineralMixBuilder
extends IERecipeBuilder<MineralMixBuilder> {
    private final List<StackWithChance> outputs = new ArrayList<StackWithChance>();
    private final List<StackWithChance> spoils = new ArrayList<StackWithChance>();
    private int weight;
    private float failChance;
    private List<MineralMix.BiomeTagPredicate> biomeTagPredicates = new ArrayList<MineralMix.BiomeTagPredicate>();
    private Block background = Blocks.STONE;

    private MineralMixBuilder() {
    }

    public static MineralMixBuilder builder() {
        return new MineralMixBuilder();
    }

    @SafeVarargs
    public final MineralMixBuilder biomeCondition(TagKey<Biome> ... tags) {
        this.biomeTagPredicates.add(new MineralMix.BiomeTagPredicate((Set)ImmutableSet.copyOf((Object[])tags)));
        return this;
    }

    public MineralMixBuilder dimensionOverworld() {
        this.biomeTagPredicates.add(new MineralMix.BiomeTagPredicate(BiomeTags.IS_OVERWORLD));
        return this;
    }

    public MineralMixBuilder dimensionNether() {
        this.biomeTagPredicates.add(new MineralMix.BiomeTagPredicate(BiomeTags.IS_NETHER));
        return this;
    }

    public MineralMixBuilder background(Block background) {
        this.background = background;
        return this;
    }

    public MineralMixBuilder spoil(ItemLike output, float weight) {
        this.spoils.add(new StackWithChance(new ItemStack(output), weight));
        return this;
    }

    public MineralMixBuilder ore(ItemLike output, float weight) {
        this.outputs.add(new StackWithChance(new ItemStack(output), weight));
        return this;
    }

    public MineralMixBuilder ore(TagKey<Item> output, float weight, ICondition ... conditions) {
        this.outputs.add(new StackWithChance(new TagOutput(output), weight, conditions));
        return this;
    }

    public MineralMixBuilder weight(int weight) {
        this.weight = weight;
        return this;
    }

    public MineralMixBuilder failchance(float failchance) {
        this.failChance = failchance;
        return this;
    }

    public MineralMixBuilder addOverworldSpoils() {
        return this.spoil((ItemLike)Items.GRAVEL, 0.2f).spoil((ItemLike)Items.COBBLESTONE, 0.5f).spoil((ItemLike)Items.COBBLED_DEEPSLATE, 0.3f);
    }

    public MineralMixBuilder addSoilSpoils() {
        return this.spoil((ItemLike)Items.GRAVEL, 0.6f).spoil((ItemLike)Items.COBBLESTONE, 0.3f).spoil((ItemLike)Items.COARSE_DIRT, 0.1f);
    }

    public MineralMixBuilder addSeabedSpoils() {
        return this.spoil((ItemLike)Items.SANDSTONE, 0.6f).spoil((ItemLike)Items.GRAVEL, 0.3f).spoil((ItemLike)Items.SAND, 0.1f);
    }

    public MineralMixBuilder addNetherSpoils() {
        return this.spoil((ItemLike)Items.NETHERRACK, 0.5f).spoil((ItemLike)Blocks.BASALT, 0.3f).spoil((ItemLike)Blocks.GRAVEL, 0.2f);
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        MineralMix recipe = new MineralMix(this.outputs, this.spoils, this.weight, this.failChance, this.biomeTagPredicates, this.background);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

