/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermenterRecipeBuilder
extends IERecipeBuilder<FermenterRecipeBuilder>
implements BaseHelpers.ItemInput<FermenterRecipeBuilder>,
BaseHelpers.ItemOutput<FermenterRecipeBuilder> {
    private IngredientWithSize input;
    private FluidStack fluidOutput;
    private TagOutput itemOutput = TagOutput.EMPTY;
    private int energy;

    private FermenterRecipeBuilder() {
    }

    public static FermenterRecipeBuilder builder() {
        return new FermenterRecipeBuilder();
    }

    @Override
    public FermenterRecipeBuilder input(IngredientWithSize input) {
        this.input = input;
        return this;
    }

    @Override
    public FermenterRecipeBuilder output(TagOutput output) {
        this.itemOutput = output;
        return this;
    }

    public FermenterRecipeBuilder output(Fluid output, int amount) {
        return this.output(new FluidStack(output, amount));
    }

    public FermenterRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public FermenterRecipeBuilder output(FluidStack output) {
        this.fluidOutput = output;
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        FermenterRecipe recipe = new FermenterRecipe(this.fluidOutput, this.itemOutput, this.input, this.energy);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

