/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.dynregistry;

import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BannerTags
extends TagsProvider<BannerPattern> {
    public BannerTags(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, Registries.BANNER_PATTERN, provider, "immersiveengineering", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider p_256380_) {
        for (IEBannerPatterns.BannerEntry entry : IEBannerPatterns.ALL_BANNERS) {
            this.tag(entry.tag()).addAll(entry.patterns());
        }
    }

    public static void bootstrap(BootstrapContext<BannerPattern> ctx) {
        for (IEBannerPatterns.BannerEntry entry : IEBannerPatterns.ALL_BANNERS) {
            for (ResourceKey pattern : entry.patterns()) {
                ctx.register(pattern, (Object)new BannerPattern(pattern.location(), "block.minecraft.banner." + pattern.location().toShortLanguageKey()));
            }
        }
    }
}

