/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class DirectionalMiningExplosion
extends Explosion {
    private static final int SIZE = 8;
    private static final int SCAN = 7;
    private static final float BLASTING_LENGTH = 80.0f;
    private static final float SUBSURFACE_LENGTH = 175.0f;
    private static final int THIRD_VOLUME = 714;
    private static final float MAX_SHOCKWAVE_RESISTANCE = 0.4f;
    private static final float MAX_SURFACE_RESISTANCE = 1.75f;
    private static final float MAX_SUBSURFACE_RESISTANCE = 6.0f;
    private static final float MAX_BLASTING_RESISTANCE = 25.0f;
    private static final float BLASTING_SHAPING_RESISTANCE = 10000.0f;
    private static final int BASE_DAMAGE = 192;
    private final Level world;
    private final DamageSource damageSource;

    public DirectionalMiningExplosion(Level world, Entity igniter, double x, double y, double z, boolean isFlaming) {
        super(world, igniter, x, y, z, 8.0f, isFlaming, Explosion.BlockInteraction.DESTROY);
        this.world = world;
        this.damageSource = world.damageSources().explosion((Explosion)this);
    }

    public void explode() {
        Vec3 center = this.center();
        BlockPos centerBlock = new BlockPos((int)(center.x - 0.5), (int)(center.y > 0.0 ? center.y + 0.5 : center.y - 0.5), (int)(center.z - 0.5));
        int totalBlocks = 0;
        float totalResistance = 0.0f;
        Vec3 weaknesses = new Vec3(0.0, 0.0, 0.0);
        Vec3 blastWeaknesses = new Vec3(0.0, 0.0, 0.0);
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    BlockPos pos = centerBlock.offset(x, y, z);
                    double length = new Vec3((double)x, (double)y, (double)z).length();
                    if (!(length <= 7.0)) continue;
                    BlockState cBlock = this.world.getBlockState(pos);
                    FluidState cFluid = this.world.getFluidState(pos);
                    if (!cBlock.isAir() || !cFluid.isEmpty()) {
                        totalResistance += cBlock.getExplosionResistance((BlockGetter)this.world, pos, (Explosion)this) + cFluid.getExplosionResistance((BlockGetter)this.world, pos, (Explosion)this);
                        ++totalBlocks;
                    }
                    if (!cBlock.canBeReplaced() || !cFluid.isEmpty()) continue;
                    weaknesses = weaknesses.add(x == 0 ? 0.0 : 1.0 / (double)x, y == 0 ? 0.0 : 1.0 / (double)y, z == 0 ? 0.0 : 1.0 / (double)z);
                    if (!(length < 5.0)) continue;
                    blastWeaknesses = blastWeaknesses.add(x == 0 ? 0.0 : 1.0 / (double)x, y == 0 ? 0.0 : 1.0 / (double)y, z == 0 ? 0.0 : 1.0 / (double)z);
                }
            }
        }
        Vec3 step = blastWeaknesses.scale((5.0 - Math.sqrt(blastWeaknesses.length() / 8.0)) / blastWeaknesses.length());
        if (weaknesses.length() < 80.0 && totalBlocks >= 714 && totalResistance <= 10000.0f) {
            this.stagedExplosionDetonation(centerBlock, step, 3.2f, 3.2f, 25.0f, true);
        } else if (weaknesses.length() < 175.0 && totalBlocks >= 714) {
            this.stagedExplosionDetonation(centerBlock, null, 3.0f, 11.0f, 6.0f, false);
        } else {
            this.stagedExplosionDetonation(centerBlock, null, 2.0f, 16.0f, 1.75f, false);
        }
    }

    private void stagedExplosionDetonation(BlockPos center, Vec3 step, float crater, float shockwave, float resistance, boolean blasting) {
        this.clearToBlow();
        int shock = (int)shockwave;
        for (int x = -shock; x <= shock; ++x) {
            for (int y = -shock; y <= shock; ++y) {
                for (int z = -shock; z <= shock; ++z) {
                    double length = Math.sqrt(x * x + y * y + z * z);
                    if (length < (double)(crater - 0.9f)) {
                        this.scheduleBlockExplosion(center.offset(x, y, z), resistance, 0.0f);
                        continue;
                    }
                    if (length < (double)crater) {
                        this.scheduleBlockExplosion(center.offset(x, y, z), resistance, 0.1f);
                        continue;
                    }
                    if (!(length < (double)shock)) continue;
                    this.scheduleBlockExplosion(center.offset(x, y, z), 0.4f, 0.0f);
                }
            }
        }
        ArrayList<Entity> damage = new ArrayList<Entity>(this.world.getEntities(this.getDirectSourceEntity(), new AABB((double)(center.getX() - shock), (double)(center.getY() - shock), (double)(center.getZ() - shock), (double)(center.getX() + shock), (double)(center.getY() + shock), (double)(center.getZ() + shock))));
        this.damageEntities(damage, shockwave / 8.0f);
        if (blasting) {
            BlockPos centerOffset = center.offset((int)step.x(), (int)step.y(), (int)step.z());
            int blast1 = (int)(crater * 1.25f);
            for (int x = -blast1; x <= blast1; ++x) {
                for (int y = -blast1; y <= blast1; ++y) {
                    for (int z = -blast1; z <= blast1; ++z) {
                        int length = (int)Math.sqrt(x * x + y * y + z * z);
                        if ((float)length < (float)blast1 - 0.9f) {
                            this.scheduleBlockExplosion(centerOffset.offset(x, y, z), resistance, 0.0f);
                            continue;
                        }
                        if (length >= blast1) continue;
                        this.scheduleBlockExplosion(centerOffset.offset(x, y, z), resistance, 0.1f);
                    }
                }
            }
            centerOffset = center.offset((int)step.x() * 2, (int)step.y() * 2, (int)step.z() * 2);
            int blast2 = (int)(crater * 1.5f);
            for (int x = -blast2; x <= blast2; ++x) {
                for (int y = -blast2; y <= blast2; ++y) {
                    for (int z = -blast2; z <= blast2; ++z) {
                        int length = (int)Math.sqrt(x * x + y * y + z * z);
                        if ((float)length < (float)blast2 - 0.9f) {
                            this.scheduleBlockExplosion(centerOffset.offset(x, y, z), resistance, 0.0f);
                            continue;
                        }
                        if (length >= blast2) continue;
                        this.scheduleBlockExplosion(centerOffset.offset(x, y, z), resistance, 0.1f);
                    }
                }
            }
        }
    }

    private void scheduleBlockExplosion(BlockPos pos, float resistance, float chance) {
        BlockState state = this.world.getBlockState(pos);
        if (!state.isAir() && state.getExplosionResistance((BlockGetter)this.world, pos, (Explosion)this) <= resistance && ApiUtils.RANDOM.nextFloat() > chance) {
            this.getToBlow().add(pos);
        }
    }

    private void damageEntities(List<Entity> list, float intensity) {
        EventHooks.onExplosionDetonate((Level)this.world, (Explosion)this, list, (double)16.0);
        for (Entity entity : list) {
            double knockback;
            double z;
            double y;
            double x;
            float length;
            if (entity.ignoreExplosion((Explosion)this) || entity instanceof ItemEntity || !((length = (float)Math.sqrt((x = entity.getX() - this.center().x()) * x + (y = entity.getY() + (double)(entity.getBbHeight() / 2.0f) - this.center().y()) * y + (z = entity.getZ() - this.center().z()) * z)) < intensity * 8.0f)) continue;
            double x2 = x / (double)length;
            double y2 = y / (double)length;
            double z2 = z / (double)length;
            float damage = intensity * intensity * intensity / (length * length) * 192.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                knockback = Math.sqrt((double)damage * (1.0 - living.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE)));
            } else {
                knockback = damage;
            }
            entity.hurt(this.damageSource, damage);
            entity.setDeltaMovement(entity.getDeltaMovement().add(org.joml.Math.clamp((double)-5.0, (double)5.0, (double)(x2 * knockback)), org.joml.Math.clamp((double)-5.0, (double)5.0, (double)(y2 * knockback)), org.joml.Math.clamp((double)-5.0, (double)5.0, (double)(z2 * knockback))));
            System.out.println(entity.getDeltaMovement().length());
        }
    }
}

