/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.mixin.accessors.DamageSourcesAccess;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.Tags;

public class RailgunProjectiles {
    public static void register() {
        RailgunHandler.registerStandardProjectile(IETags.ironRod, 16.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.aluminumRod, 10.0, 1.05).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.steelRod, 24.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xB4B4B4, 0xB4B4B4, 0xB4B4B4, 0x7A7A7A, 0x555555, 0x555555));
        RailgunHandler.registerStandardProjectile(IETags.netheriteRod, 30.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0x5A575A, 0x484548, 0x484548, 0x3C3232, 3221802, 3221802));
        RailgunHandler.registerStandardProjectile(new ItemStack(IEItems.Misc.GRAPHITE_ELECTRODE), 30.0, 0.9).setColorMap(new RailgunHandler.RailgunRenderColors(0x242424, 0x242424, 0x242424, 0x171717, 0x171717, 657930));
        RailgunHandler.registerProjectile(() -> Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), new RailgunHandler.StandardRailgunProjectile(10.0, 1.05){

            @Override
            public void onHitTarget(Level world, HitResult target, @Nullable UUID shooter, Entity projectile) {
                if (target instanceof EntityHitResult) {
                    ((EntityHitResult)target).getEntity().igniteForSeconds(5.0f);
                }
            }

            @Override
            public double getBreakChance(@Nullable UUID shooter, ItemStack ammo) {
                return 1.0;
            }
        }.setColorMap(new RailgunHandler.RailgunRenderColors(16773933, 16761088, 11758361, 12540416, 12540416, 9777920)));
        RailgunHandler.registerProjectile(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.END_ROD}), new RailgunHandler.StandardRailgunProjectile(10.0, 1.05){

            @Override
            public double getDamage(Level world, Entity target, @Nullable UUID shooter, Entity projectile) {
                double d = super.getDamage(world, target, shooter, projectile);
                if (target instanceof EnderMan) {
                    d *= 2.0;
                }
                return d;
            }

            @Override
            public DamageSource getDamageSource(Level world, Entity target, @Nullable UUID shooter, Entity projectile) {
                if (target instanceof EnderMan) {
                    Player p;
                    EnderMan enderMan = (EnderMan)target;
                    enderMan.addEffect(new MobEffectInstance(IEPotions.STUNNED, 200));
                    DamageSourcesAccess sources = (DamageSourcesAccess)world.damageSources();
                    if (shooter != null && (p = world.getPlayerByUUID(shooter)) != null) {
                        return sources.invokeSource(Lib.DamageTypes.RAILGUN.turretType(), (Entity)p, null);
                    }
                    return sources.invokeSource(Lib.DamageTypes.RAILGUN.playerType(), null, null);
                }
                return null;
            }
        }.setColorMap(new RailgunHandler.RailgunRenderColors(16179917, 0xFFF6E6, 0xFFFFFF, 0xFFF6F6, 16179917, 7562597)));
        RailgunHandler.registerProjectile(() -> Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Tools.SAWBLADE}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                return new SawbladeEntity(defaultProjectile.level(), (LivingEntity)shooter, 20.0f, 0.0f, ammo);
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIDENT}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    ammo.hurtAndBreak(1, (LivingEntity)shooter, EquipmentSlot.MAINHAND);
                    ThrownTrident trident = new ThrownTrident(shooter.level(), (LivingEntity)shooter, ammo);
                    trident.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 5.0f, 0.0f);
                    if (shooter.getAbilities().instabuild) {
                        trident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    return trident;
                }
                return defaultProjectile;
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    ThrownEnderpearl pearl = new ThrownEnderpearl(shooter.level(), (LivingEntity)shooter);
                    pearl.setItem(ammo);
                    pearl.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.0f);
                    return pearl;
                }
                return defaultProjectile;
            }
        });
    }
}

