/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.entities.GunpowderBarrelEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class GunpowderBarrelBlock
extends TntBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(2.0f, 5.0f);

    public GunpowderBarrelBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!world.isClientSide) {
            GunpowderBarrelEntity explosive = this.spawnExplosive(world, pos, state, igniter);
            world.playSound(null, explosive.getX(), explosive.getY(), explosive.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.removeBlock(pos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (!world.isClientSide) {
            GunpowderBarrelEntity explosive = this.spawnExplosive(world, pos, state, explosion.getIndirectSourceEntity());
            explosive.setFuse((short)(world.random.nextInt(explosive.getFuse() / 4) + explosive.getFuse() / 8));
        }
    }

    private GunpowderBarrelEntity spawnExplosive(Level world, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity igniter) {
        GunpowderBarrelEntity explosive = new GunpowderBarrelEntity(world, pos, igniter, state, 8.0f);
        world.addFreshEntity((Entity)explosive);
        return explosive;
    }

    public void wasExploded(Level worldIn, BlockPos pos, Explosion explosionIn) {
    }
}

