/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tooltip;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class TooltipTextShadowUtils {
    public static boolean hasCustomShadows(FormattedText component) {
        return component.visit((style, s) -> {
            String ins = style.getInsertion();
            if (ins != null && ins.startsWith("ie_text_shadow:")) {
                return Optional.of(true);
            }
            return Optional.empty();
        }, Style.EMPTY).orElse(false);
    }

    public static FormattedText getShadowText(FormattedText component) {
        ArrayList list = new ArrayList();
        component.visit((style, text) -> {
            if (style.getColor() != null) {
                int color = style.getColor().getValue();
                String ins = style.getInsertion();
                if (ins != null && ins.startsWith("ie_text_shadow:")) {
                    color = Integer.parseInt(ins.substring("ie_text_shadow:".length()));
                } else {
                    int[] rgba = new int[]{Math.round((float)(color >> 16 & 0xFF) * 0.25f), Math.round((float)(color >> 8 & 0xFF) * 0.25f), Math.round((float)(color & 0xFF) * 0.25f), color >> 24 & 0xFF};
                    color = rgba[3] << 24 | rgba[0] << 16 | rgba[1] << 8 | rgba[2];
                }
                style = style.withColor(color);
            }
            list.add(FormattedText.of((String)text, (Style)style));
            return Optional.empty();
        }, Style.EMPTY);
        return FormattedText.composite(list);
    }

    public static void drawWithCustomShadows(Matrix4f matrix, FormattedText component, int x, int y, MultiBufferSource.BufferSource buffer) {
        FormattedText shadowed = TooltipTextShadowUtils.getShadowText(component);
        ClientUtils.font().drawInBatch(Language.getInstance().getVisualOrder(shadowed), (float)(x + 1), (float)(y + 1), -12566464, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrix.translate(0.0f, 0.0f, 0.03f);
        ClientUtils.font().drawInBatch(Language.getInstance().getVisualOrder(component), (float)x, (float)y, -1, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    @SubscribeEvent
    public static void onTooltipComponents(RenderTooltipEvent.GatherComponents ev) {
        ev.getTooltipElements().replaceAll(either -> (Either)either.map(formattedText -> {
            if (TooltipTextShadowUtils.hasCustomShadows(formattedText)) {
                return Either.right((Object)new TextShadowServerTooltip((FormattedText)formattedText));
            }
            return either;
        }, tooltipComponent -> either));
    }

    public record TextShadowServerTooltip(FormattedText component) implements TooltipComponent
    {
    }

    public record TextShadowClientTooltip(TextShadowServerTooltip data) implements ClientTooltipComponent
    {
        public int getWidth(Font font) {
            return font.width(this.data.component());
        }

        public int getHeight() {
            return 10;
        }

        public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
            TooltipTextShadowUtils.drawWithCustomShadows(matrix, this.data.component(), mouseX, mouseY, bufferSource);
        }
    }
}

