/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;

public abstract class ModelIEArmorBase
extends HumanoidModel<LivingEntity> {
    public ModelIEArmorBase(ModelPart p_170679_, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170679_, p_170680_);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.attackTime = entity.getAttackAnim(ClientUtils.partialTicks());
        if (entity instanceof ArmorStand) {
            this.setRotationAnglesStand(entity);
        } else if (entity instanceof Skeleton || entity instanceof Zombie) {
            this.setRotationAnglesZombie(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        this.young = entity.isBaby();
        this.crouching = entity.isShiftKeyDown();
        this.riding = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
    }

    public void setRotationAnglesZombie(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f6 = Mth.sin((float)(this.attackTime * 3.141593f));
        float f7 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * 3.141593f));
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.yRot = -(0.1f - f6 * 0.6f);
        this.leftArm.yRot = 0.1f - f6 * 0.6f;
        this.rightArm.xRot = -1.570796f;
        this.leftArm.xRot = -1.570796f;
        this.rightArm.xRot -= f6 * 1.2f - f7 * 0.4f;
        this.leftArm.xRot -= f6 * 1.2f - f7 * 0.4f;
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    private void setRotationAnglesStand(LivingEntity entity) {
        if (entity instanceof ArmorStand) {
            ArmorStand entityarmorstand = (ArmorStand)entity;
            this.head.xRot = 0.01745329f * entityarmorstand.getHeadPose().getX();
            this.head.yRot = 0.01745329f * entityarmorstand.getHeadPose().getY();
            this.head.zRot = 0.01745329f * entityarmorstand.getHeadPose().getZ();
            this.head.setPos(0.0f, 1.0f, 0.0f);
            this.body.xRot = 0.01745329f * entityarmorstand.getBodyPose().getX();
            this.body.yRot = 0.01745329f * entityarmorstand.getBodyPose().getY();
            this.body.zRot = 0.01745329f * entityarmorstand.getBodyPose().getZ();
            this.leftArm.xRot = 0.01745329f * entityarmorstand.getLeftArmPose().getX();
            this.leftArm.yRot = 0.01745329f * entityarmorstand.getLeftArmPose().getY();
            this.leftArm.zRot = 0.01745329f * entityarmorstand.getLeftArmPose().getZ();
            this.rightArm.xRot = 0.01745329f * entityarmorstand.getRightArmPose().getX();
            this.rightArm.yRot = 0.01745329f * entityarmorstand.getRightArmPose().getY();
            this.rightArm.zRot = 0.01745329f * entityarmorstand.getRightArmPose().getZ();
            this.leftLeg.xRot = 0.01745329f * entityarmorstand.getLeftLegPose().getX();
            this.leftLeg.yRot = 0.01745329f * entityarmorstand.getLeftLegPose().getY();
            this.leftLeg.zRot = 0.01745329f * entityarmorstand.getLeftLegPose().getZ();
            this.leftLeg.setPos(1.9f, 11.0f, 0.0f);
            this.rightLeg.xRot = 0.01745329f * entityarmorstand.getRightLegPose().getX();
            this.rightLeg.yRot = 0.01745329f * entityarmorstand.getRightLegPose().getY();
            this.rightLeg.zRot = 0.01745329f * entityarmorstand.getRightLegPose().getZ();
            this.rightLeg.setPos(-1.9f, 11.0f, 0.0f);
            this.hat.copyFrom(this.head);
        }
    }
}

