/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.client.BlockOverlayUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.IEKeybinds;
import blusunrize.immersiveengineering.client.LevelStageRenders;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.render.tile.BlueprintRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WindowBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableBlockEntity;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ShaderItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.client.WorldRendererAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Quaternionf;

public class ClientEventHandler
implements ResourceManagerReloadListener {
    private boolean shieldToggleButton = false;
    private int shieldToggleTimer = 0;

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        ImmersiveEngineering.proxy.clearRenderCaches();
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        ItemStack held;
        Player player = event.getEntity();
        if (!player.level().isClientSide || player != ClientUtils.mc().player) {
            return;
        }
        if (this.shieldToggleTimer > 0) {
            --this.shieldToggleTimer;
        }
        if (IEKeybinds.keybind_magnetEquip.isDown() && !this.shieldToggleButton) {
            if (this.shieldToggleTimer <= 0) {
                this.shieldToggleTimer = 7;
            } else {
                held = player.getItemInHand(InteractionHand.OFF_HAND);
                if (!held.isEmpty() && held.getItem() instanceof IEShieldItem) {
                    if (UpgradeableToolItem.getUpgradesStatic(held).get(UpgradeEffect.MAGNET).prevSlot().isPresent()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new MessageMagnetEquip(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    for (int i = 0; i < player.getInventory().items.size(); ++i) {
                        ItemStack s = (ItemStack)player.getInventory().items.get(i);
                        if (s.isEmpty() || !(s.getItem() instanceof IEShieldItem) || !((IEShieldItem)s.getItem()).getUpgrades(s).has(UpgradeEffect.MAGNET)) continue;
                        PacketDistributor.sendToServer((CustomPacketPayload)new MessageMagnetEquip(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
        if (this.shieldToggleButton != ClientUtils.mc().options.keyDown.isDown()) {
            this.shieldToggleButton = ClientUtils.mc().options.keyDown.isDown();
        }
        if (!IEKeybinds.keybind_chemthrowerSwitch.isUnbound() && IEKeybinds.keybind_chemthrowerSwitch.consumeClick() && (held = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof IEItemInterfaces.IScrollwheel) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageScrollwheelItem(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!IEKeybinds.keybind_railgunZoom.isUnbound() && IEKeybinds.keybind_railgunZoom.consumeClick()) {
            for (InteractionHand hand : InteractionHand.values()) {
                float[] steps;
                ItemStack held2 = player.getItemInHand(hand);
                if (!(held2.getItem() instanceof ZoomHandler.IZoomTool) || !((ZoomHandler.IZoomTool)held2.getItem()).canZoom(held2, player)) continue;
                boolean bl = ZoomHandler.isZooming = !ZoomHandler.isZooming;
                if (!ZoomHandler.isZooming || (steps = ((ZoomHandler.IZoomTool)held2.getItem()).getZoomSteps(held2, player)) == null || steps.length <= 0) break;
                ZoomHandler.fovZoom = steps[ZoomHandler.getCurrentZoomStep(steps)];
                break;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        LevelStageRenders.FAILED_CONNECTIONS.entrySet().removeIf(entry -> ((MutableInt)((Pair)entry.getValue()).getSecond()).decrementAndGet() <= 0);
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            GlobalWireNetwork.getNetwork((Level)world).update((Level)world);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack earmuffs;
        ResourceLocation shader;
        if (event.getItemStack().isEmpty()) {
            return;
        }
        CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)event.getItemStack().getCapability(CapabilityShader.ITEM);
        if (wrapper != null && (shader = wrapper.getShader()) != null) {
            event.getToolTip().add(TextUtils.applyFormat(ShaderItem.getShaderName(shader), ChatFormatting.DARK_GRAY));
        }
        if (event.getItemStack().has(IEDataComponents.CONTAINED_EARMUFF) && !(earmuffs = ((AttachedItem)event.getItemStack().get(IEDataComponents.CONTAINED_EARMUFF)).attached()).isEmpty()) {
            event.getToolTip().add(TextUtils.applyFormat(earmuffs.getHoverName(), ChatFormatting.GRAY));
        }
        if (event.getItemStack().has(IEDataComponents.CONTAINED_POWERPACK)) {
            ItemStack powerpack = ((AttachedItem)event.getItemStack().get(IEDataComponents.CONTAINED_POWERPACK)).attached();
            IEnergyStorage packStorage = (IEnergyStorage)powerpack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (!powerpack.isEmpty() && packStorage != null) {
                List tooltip = event.getToolTip();
                int idx = IntStream.range(0, tooltip.size()).filter(i -> tooltip.get(i) == CommonComponents.EMPTY).findFirst().orElse(tooltip.size() - 1);
                tooltip.add(idx++, CommonComponents.EMPTY);
                tooltip.add(idx++, TextUtils.applyFormat(powerpack.getHoverName(), ChatFormatting.GRAY));
                tooltip.add(idx++, TextUtils.applyFormat((Component)Component.literal((String)(packStorage.getEnergyStored() + "/" + packStorage.getMaxEnergyStored() + " IF")), ChatFormatting.GRAY));
                tooltip.add(idx, TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.noChargeOnArmor"), ChatFormatting.DARK_GRAY));
            }
        }
        ClientLevel clientLevel = ClientUtils.mc().level;
        if (ClientUtils.mc().screen != null && ClientUtils.mc().screen instanceof BlastFurnaceScreen && BlastFurnaceFuel.isValidBlastFuel((Level)clientLevel, event.getItemStack())) {
            event.getToolTip().add(TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceFuel.getBlastFuelTime((Level)clientLevel, event.getItemStack())}), ChatFormatting.GRAY));
        }
        if (((Boolean)IEClientConfig.tagTooltips.get()).booleanValue() && event.getFlags().isAdvanced()) {
            event.getItemStack().getItem().builtInRegistryHolder().tags().map(TagKey::location).forEach(oid -> event.getToolTip().add(TextUtils.applyFormat((Component)Component.literal((String)oid.toString()), ChatFormatting.GRAY)));
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes;
        double playerDistanceSq;
        if (event.getItemStack().getItem() instanceof EngineersBlueprintItem && (playerDistanceSq = ClientUtils.mc().player.distanceToSqr((Entity)event.getItemFrameEntity())) < 1000.0 && !(recipes = BlueprintCraftingRecipe.findRecipes(event.getItemFrameEntity().level(), IEApiDataComponents.getBlueprintType(event.getItemStack()))).isEmpty()) {
            BlueprintRenderer.BlueprintLines blueprint;
            int i = event.getItemFrameEntity().getRotation();
            BlueprintCraftingRecipe recipe = (BlueprintCraftingRecipe)recipes.get(i % recipes.size()).value();
            BlueprintRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : BlueprintRenderer.getBlueprintDrawable(recipe, event.getItemFrameEntity().getCommandSenderWorld());
            if (blueprint != null) {
                PoseStack transform = event.getPoseStack();
                transform.pushPose();
                MultiBufferSource buffer = event.getMultiBufferSource();
                transform.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, (float)(-i) * (float)Math.PI / 4.0f));
                transform.translate(-0.5, 0.5, -0.001);
                VertexConsumer builder = buffer.getBuffer(IERenderTypes.getGui(ImmersiveEngineering.rl("textures/models/blueprint_frame.png")));
                GuiHelper.drawTexturedColoredRect(builder, transform, 0.125f, -0.875f, 0.75f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                transform.translate(0.75, -0.25, -0.002);
                float scale = 0.0375f / ((float)blueprint.getTextureScale() / 16.0f);
                transform.scale(-scale, -scale, scale);
                blueprint.draw(transform, buffer, event.getPackedLight());
                transform.popPose();
                event.setCanceled(true);
            }
        }
    }

    private static void handleSubtitleOffset(boolean pre) {
        float offset = 0.0f;
        LocalPlayer player = ClientUtils.mc().player;
        for (InteractionHand hand : InteractionHand.values()) {
            if (player.getItemInHand(hand).isEmpty()) continue;
            Item equipped = player.getItemInHand(hand).getItem();
            if (equipped instanceof RevolverItem || equipped instanceof SpeedloaderItem) {
                offset = 50.0f;
                continue;
            }
            if (equipped instanceof DrillItem || equipped instanceof ChemthrowerItem || equipped instanceof BuzzsawItem) {
                offset = 50.0f;
                continue;
            }
            if (!(equipped instanceof RailgunItem) && !(equipped instanceof IEShieldItem)) continue;
            offset = 20.0f;
        }
        if (offset != 0.0f) {
            if (pre) {
                offset *= -1.0f;
            }
            RenderSystem.getModelViewStack().translate(0.0f, offset, 0.0f);
            RenderSystem.applyModelViewMatrix();
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGuiLayerEvent.Pre event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) || !ZoomHandler.isZooming) {
            return;
        }
        LocalPlayer player = ClientUtils.mc().player;
        float[] zoomSteps = Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).mapMulti((arg_0, arg_1) -> ClientEventHandler.lambda$onRenderOverlayPre$3((Player)player, arg_0, arg_1)).findFirst().orElse(null);
        if (zoomSteps == null || zoomSteps.length <= 1) {
            return;
        }
        event.setCanceled(true);
        GuiGraphics graphics = event.getGuiGraphics();
        PoseStack transform = graphics.pose();
        transform.pushPose();
        int width = ClientUtils.mc().getWindow().getGuiScaledWidth();
        int height = ClientUtils.mc().getWindow().getGuiScaledHeight();
        int resMin = Math.min(width, height);
        float offsetX = Math.round((float)(width - resMin) / 2.0f);
        float offsetY = Math.round((float)(height - resMin) / 2.0f);
        if (resMin == width) {
            graphics.fill(0, 0, width, (int)offsetY + 1, -16777216);
            graphics.fill(0, (int)offsetY + resMin, width, (int)(offsetY + (float)resMin + offsetY + 1.0f), -16777216);
        } else {
            graphics.fill(0, 0, (int)offsetX + 1, height, -16777216);
            graphics.fill((int)offsetX + resMin, 0, (int)(offsetX + (float)resMin + offsetX + 1.0f), height, -16777216);
        }
        transform.translate(offsetX, offsetY, 0.0f);
        RenderSystem.enableBlend();
        graphics.blitSprite(IEApi.ieLoc("hud/scope"), 0, 0, resMin, resMin);
        RenderSystem.disableBlend();
        transform.translate(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.0f);
        graphics.blitSprite(IEApi.ieLoc("hud/gauge_vertical"), 0, 0, Math.round(0.09375f * (float)resMin), Math.round(0.5f * (float)resMin));
        float stepLength = 118.0f / (float)zoomSteps.length;
        float stepOffset = (stepLength - 7.0f) / 2.0f;
        RenderSystem.enableBlend();
        transform.translate(0.01953125f * (float)resMin, (5.0f + stepOffset) / 256.0f * (float)resMin, 0.0f);
        int curStep = -1;
        float dist = 0.0f;
        int innerWidth = Math.round(0.0546875f * (float)resMin);
        int innerHeight = Math.round(0.02734375f * (float)resMin);
        for (int i = 0; i < zoomSteps.length; ++i) {
            graphics.blitSprite(IEApi.ieLoc("hud/gauge_vertical_step"), 0, 0, innerWidth, innerHeight);
            transform.translate(0.0f, stepLength / 256.0f * (float)resMin, 0.0f);
            if (curStep != -1 && !(Math.abs(zoomSteps[i] - ZoomHandler.fovZoom) < dist)) continue;
            curStep = i;
            dist = Math.abs(zoomSteps[i] - ZoomHandler.fovZoom);
        }
        transform.translate(0.0f, -0.4609375f * (float)resMin, 0.0f);
        transform.translate(0.0f, (float)curStep * stepLength / 256.0f * (float)resMin, 0.0f);
        graphics.blitSprite(IEApi.ieLoc("hud/gauge_vertical_pointer"), 0, 0, innerWidth, innerHeight);
        transform.translate(0.0625f * (float)resMin, 0.00390625f * (float)resMin, 0.0f);
        graphics.drawString(ClientUtils.font(), 1.0f / zoomSteps[curStep] + "x", 0, 0, 0xFFFFFF, false);
        RenderSystem.disableBlend();
        transform.popPose();
    }

    @SubscribeEvent
    public void onFogUpdate(ViewportEvent.RenderFog event) {
        LivingEntity living;
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(IEPotions.FLASHED)) {
            MobEffectInstance effect = living.getEffect(IEPotions.FLASHED);
            int timeLeft = effect.getDuration();
            float saturation = Math.max(0.25f, 1.0f - (float)timeLeft / (float)(80 + 40 * effect.getAmplifier()));
            float f1 = -2.5f + 15.0f * saturation;
            if (timeLeft < 20) {
                f1 += event.getFarPlaneDistance() / 4.0f * (1.0f - (float)timeLeft / 20.0f);
            }
            RenderSystem.setShaderFogStart((float)(0.25f * f1));
            RenderSystem.setShaderFogEnd((float)f1);
        }
    }

    @SubscribeEvent
    public void onFogColourUpdate(ViewportEvent.ComputeFogColor event) {
        Entity e = event.getCamera().getEntity();
        if (e instanceof LivingEntity && ((LivingEntity)e).hasEffect(IEPotions.FLASHED)) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(ComputeFovModifierEvent event) {
        LocalPlayer player = ClientUtils.mc().player;
        boolean mayZoom = Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).anyMatch(arg_0 -> ClientEventHandler.lambda$onFOVUpdate$4((Player)player, arg_0));
        if (ZoomHandler.isZooming) {
            if (mayZoom) {
                event.setNewFovModifier(ZoomHandler.fovZoom);
            } else {
                ZoomHandler.isZooming = false;
            }
        }
        if (player.getEffect(IEPotions.CONCRETE_FEET) != null) {
            event.setNewFovModifier(1.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerTurn(CalculatePlayerTurnEvent event) {
        if (event.getCinematicCameraEnabled()) {
            return;
        }
        LocalPlayer player = ClientUtils.mc().player;
        boolean mayZoom = Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).anyMatch(arg_0 -> ClientEventHandler.lambda$onPlayerTurn$5((Player)player, arg_0));
        if (ZoomHandler.isZooming && mayZoom) {
            double mouseSensitivity = event.getMouseSensitivity();
            double mod = 0.5 - 1.0 / (6.0 * mouseSensitivity);
            double fovMod = 0.1 / (double)ZoomHandler.fovZoom;
            event.setMouseSensitivity(mod * mouseSensitivity / fovMod);
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = ClientUtils.mc().player;
        if (event.getScrollDeltaY() != 0.0 && ClientUtils.mc().screen == null && player != null) {
            if (ZoomHandler.isZooming) {
                float[] zoomSteps = Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).mapMulti((arg_0, arg_1) -> ClientEventHandler.lambda$onMouseEvent$6((Player)player, arg_0, arg_1)).findFirst().orElse(null);
                if (zoomSteps != null && zoomSteps.length > 0) {
                    int curStep = ZoomHandler.getCurrentZoomStep(zoomSteps);
                    int newStep = curStep + (event.getScrollDeltaY() > 0.0 ? -1 : 1);
                    if (newStep >= 0 && newStep < zoomSteps.length) {
                        ZoomHandler.fovZoom = zoomSteps[newStep];
                    }
                    event.setCanceled(true);
                }
            }
            ItemStack equipped = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (player.isShiftKeyDown()) {
                if (((Boolean)IEServerConfig.TOOLS.chemthrower_scroll.get()).booleanValue() && equipped.getItem() instanceof IEItemInterfaces.IScrollwheel) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageScrollwheelItem(event.getScrollDeltaY() < 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.setCanceled(true);
                }
                if (equipped.getItem() instanceof RevolverItem) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageRevolverRotate(event.getScrollDeltaY() < 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(RenderHighlightEvent.Block event) {
        Entity entity;
        if (event.getTarget().getType() == HitResult.Type.BLOCK && (entity = event.getCamera().getEntity()) instanceof LivingEntity) {
            ItemStack head;
            DrillItem drillItem;
            Item shape;
            LivingEntity living = (LivingEntity)entity;
            PoseStack transform = event.getPoseStack();
            MultiBufferSource buffer = event.getMultiBufferSource();
            BlockHitResult rtr = event.getTarget();
            BlockPos pos = rtr.getBlockPos();
            Level world = living.level();
            BlockState targetBlock = world.getBlockState(rtr.getBlockPos());
            Vec3 renderView = event.getCamera().getPosition();
            transform.pushPose();
            transform.translate(-renderView.x, -renderView.y, -renderView.z);
            transform.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            BlockEntity tile = living.level().getBlockEntity(rtr.getBlockPos());
            ItemStack stack = living.getItemInHand(InteractionHand.MAIN_HAND);
            if (tile instanceof TurntableBlockEntity) {
                TurntableBlockEntity turntableTile = (TurntableBlockEntity)tile;
                if (Utils.isHammer(stack)) {
                    Direction side = rtr.getDirection();
                    Direction facing = turntableTile.getFacing();
                    if (side.getAxis() != facing.getAxis()) {
                        transform.pushPose();
                        transform.translate(0.5, 0.5, 0.5);
                        transform.pushTransformation(ClientUtils.toModelRotation(side).getRotation());
                        transform.mulPose(new Quaternionf().rotateXYZ(-1.5707964f, 0.0f, 0.0f));
                        Rotation rotation = turntableTile.getRotationFromSide(side);
                        boolean cw180 = rotation == Rotation.CLOCKWISE_180;
                        double angle = cw180 ? (double)(living.tickCount % 40) / 20.0 : (double)(living.tickCount % 80) / 40.0;
                        double stepDistance = (double)(cw180 ? 2 : 4) * Math.PI;
                        angle = -(angle - Math.sin(angle * stepDistance) / stepDistance) * Math.PI;
                        BlockOverlayUtils.drawCircularRotationArrows(buffer, transform, (float)angle, rotation == Rotation.COUNTERCLOCKWISE_90, cw180);
                        transform.popPose();
                        transform.popPose();
                    }
                }
            }
            if (!stack.isEmpty() && ConveyorHandler.isConveyorBlock(Block.byItem((Item)stack.getItem())) && rtr.getDirection().getAxis() == Direction.Axis.Y) {
                Direction side = rtr.getDirection();
                shape = world.getBlockState(pos).getBlockSupportShape((BlockGetter)world, pos);
                AABB targetedBB = null;
                if (!shape.isEmpty()) {
                    targetedBB = shape.bounds();
                }
                BlockOverlayUtils.drawQuadrantX(transform, buffer, side, targetedBB, 0.002f);
                float xFromMid = side.getAxis() == Direction.Axis.X ? 0.0f : (float)rtr.getLocation().x - (float)pos.getX() - 0.5f;
                float yFromMid = side.getAxis() == Direction.Axis.Y ? 0.0f : (float)rtr.getLocation().y - (float)pos.getY() - 0.5f;
                float zFromMid = side.getAxis() == Direction.Axis.Z ? 0.0f : (float)rtr.getLocation().z - (float)pos.getZ() - 0.5f;
                float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
                Vec3 dir = new Vec3(max == Math.abs(xFromMid) ? (double)Math.signum(xFromMid) : 0.0, max == Math.abs(yFromMid) ? (double)Math.signum(yFromMid) : 0.0, max == Math.abs(zFromMid) ? (double)Math.signum(zFromMid) : 0.0);
                BlockOverlayUtils.drawBlockOverlayArrow(transform.last(), buffer, dir, side, targetedBB);
            }
            if (targetBlock.getBlock() instanceof CatwalkBlock && Utils.isHammer(stack) && rtr.getDirection() == Direction.UP && living.isShiftKeyDown()) {
                AABB targetedBB = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
                BlockOverlayUtils.drawQuadrantX(transform, buffer, Direction.UP, targetedBB, 0.002f);
            }
            transform.popPose();
            if (targetBlock.getBlock() instanceof WindowBlock) {
                ((WorldRendererAccess)event.getLevelRenderer()).callRenderHitOutline(transform, buffer.getBuffer(IERenderTypes.LINES_NONTRANSLUCENT), (Entity)living, renderView.x, renderView.y, renderView.z, pos, targetBlock);
                event.setCanceled(true);
            }
            if ((shape = stack.getItem()) instanceof DrillItem && (drillItem = (DrillItem)shape).isEffective(stack, targetBlock) && !(head = drillItem.getHead(stack)).isEmpty() && living instanceof Player) {
                Player player = (Player)living;
                if (!living.isShiftKeyDown() && !DrillItem.isSingleBlockMode(stack)) {
                    ImmutableList<BlockPos> potentialBlocks = ((IDrillHead)head.getItem()).getExtraBlocksDug(head, world, player, (HitResult)event.getTarget());
                    ArrayList<BlockPos> breakingBlocks = new ArrayList<BlockPos>();
                    for (BlockPos candidate : potentialBlocks) {
                        BlockState targetState;
                        if (!drillItem.canBreakExtraBlock(world, candidate, targetState = world.getBlockState(candidate), player, stack, head)) continue;
                        breakingBlocks.add(candidate);
                    }
                    BlockOverlayUtils.drawAdditionalBlockbreak(event, player, breakingBlocks);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity().getPersistentData().contains("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.getEntity().getPersistentData().contains("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), true);
        }
    }

    private static void enableHead(LivingEntityRenderer renderer, boolean shouldEnable) {
        EntityModel m = renderer.getModel();
        if (m instanceof HeadedModel) {
            ((HeadedModel)m).getHead().visible = shouldEnable;
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinLevelEvent event) {
        if (event.getEntity().level().isClientSide && event.getEntity() instanceof AbstractMinecart) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageMinecartShaderSync(event.getEntity().getId(), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static /* synthetic */ void lambda$onMouseEvent$6(Player player, ItemStack itemStack, Consumer consumer) {
        ZoomHandler.IZoomTool zoomTool;
        Item patt0$temp = itemStack.getItem();
        if (patt0$temp instanceof ZoomHandler.IZoomTool && (zoomTool = (ZoomHandler.IZoomTool)patt0$temp).canZoom(itemStack, player)) {
            consumer.accept(zoomTool.getZoomSteps(itemStack, player));
        }
    }

    private static /* synthetic */ boolean lambda$onPlayerTurn$5(Player player, ItemStack s) {
        ZoomHandler.IZoomTool zoomTool;
        Item patt0$temp = s.getItem();
        return patt0$temp instanceof ZoomHandler.IZoomTool && (zoomTool = (ZoomHandler.IZoomTool)patt0$temp).canZoom(s, player);
    }

    private static /* synthetic */ boolean lambda$onFOVUpdate$4(Player player, ItemStack s) {
        ZoomHandler.IZoomTool zoomTool;
        Item patt0$temp = s.getItem();
        return patt0$temp instanceof ZoomHandler.IZoomTool && (zoomTool = (ZoomHandler.IZoomTool)patt0$temp).canZoom(s, player);
    }

    private static /* synthetic */ void lambda$onRenderOverlayPre$3(Player player, ItemStack itemStack, Consumer consumer) {
        ZoomHandler.IZoomTool zoomTool;
        Item patt0$temp = itemStack.getItem();
        if (patt0$temp instanceof ZoomHandler.IZoomTool && (zoomTool = (ZoomHandler.IZoomTool)patt0$temp).canZoom(itemStack, player)) {
            consumer.accept(zoomTool.getZoomSteps(itemStack, player));
        }
    }
}

