/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.register.IEEntityDataSerializers;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import java.util.UUID;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class RevolvershotEntity
extends IEProjectileEntity {
    private static final EntityDataAccessor<BulletData<?>> DATAMARKER_BULLET = SynchedEntityData.defineId(RevolvershotEntity.class, IEEntityDataSerializers.BULLET.get());
    private BulletData<?> bullet;
    public boolean bulletElectro = false;
    private float gravity;
    private float movementDecay;

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> type, Level world) {
        super(type, world);
    }

    public <T> RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity shooter, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet<T> bullet, T bulletData) {
        super(eType, world, shooter, x, y, z, ax, ay, az);
        this.setPos(x, y, z);
        this.bullet = new BulletData<T>(bullet, bulletData);
        this.entityData.set(DATAMARKER_BULLET, this.bullet);
    }

    public <T> RevolvershotEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet<T> bullet, T bulletData) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, bullet, bulletData);
    }

    public <T> RevolvershotEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet<T> bullet, T bulletData) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, living, ax, ay, az, bullet, bulletData);
    }

    public <T> RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet<T> bullet, T bulletData) {
        this(eType, world, living, living.getX() + ax, living.getY() + (double)living.getEyeHeight() + ay, living.getZ() + az, ax, ay, az, bullet, bulletData);
        this.setDeltaMovement(Vec3.ZERO);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATAMARKER_BULLET, new BulletData(BulletHandler.getBullet(IEBullets.CASULL)));
    }

    public BulletData<?> getBullet() {
        if (this.level().isClientSide) {
            return (BulletData)this.entityData.get(DATAMARKER_BULLET);
        }
        return this.bullet;
    }

    public void onHit(HitResult mop) {
        Entity hitEntity;
        boolean headshot = false;
        if (mop instanceof EntityHitResult && (hitEntity = ((EntityHitResult)mop).getEntity()) instanceof LivingEntity) {
            headshot = Utils.isVecInEntityHead((LivingEntity)hitEntity, this.position());
        }
        if (this.bullet != null) {
            Entity owner = this.getOwner();
            UUID shooterUUID = owner != null ? owner.getUUID() : null;
            this.bullet.onHitTarget(this.level(), mop, shooterUUID, this, headshot);
            if (mop instanceof EntityHitResult) {
                Entity hitEntity2 = ((EntityHitResult)mop).getEntity();
                if (shooterUUID != null && headshot && hitEntity2 instanceof LivingEntity && ((LivingEntity)hitEntity2).isBaby() && ((LivingEntity)hitEntity2).getHealth() <= 0.0f) {
                    Player shooter = this.level().getPlayerByUUID(shooterUUID);
                    if (shooter != null) {
                        Utils.unlockIEAdvancement(shooter, "tools/secret_birthdayparty");
                    }
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)IESounds.birthdayParty.value(), SoundSource.PLAYERS, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)hitEntity2, (CustomPacketPayload)new MessageBirthdayParty(hitEntity2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        if (!this.level().isClientSide) {
            this.secondaryImpact(mop);
        }
        if (mop instanceof BlockHitResult) {
            this.onHitBlock((BlockHitResult)mop);
        }
        this.discard();
    }

    public void secondaryImpact(HitResult mop) {
        UUID shooterUUID;
        if (!(mop instanceof EntityHitResult)) {
            return;
        }
        Entity hitEntity = ((EntityHitResult)mop).getEntity();
        Entity owner = this.getOwner();
        UUID uUID = shooterUUID = owner != null ? owner.getUUID() : null;
        if (this.bulletElectro && hitEntity instanceof LivingEntity && shooterUUID != null) {
            Player shooter = this.level().getPlayerByUUID(shooterUUID);
            float percentualDrain = 0.15f / (float)(this.bullet == null ? 1 : this.bullet.bullet.getProjectileCount(shooter));
            ((LivingEntity)hitEntity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 15, 4));
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                int actualDrain;
                ItemStack stack = ((LivingEntity)hitEntity).getItemBySlot(slot);
                if (!EnergyHelper.isFluxReceiver(stack) || EnergyHelper.getEnergyStored(stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored(stack), (float)EnergyHelper.getMaxEnergyStored(stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.put("bullet", BulletData.CODECS.toNBT(this.bullet));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.bullet = (BulletData)BulletData.CODECS.fromNBT(nbt.get("bullet"));
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean isPickable() {
        return false;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getDefaultGravity() {
        return this.gravity;
    }

    public void setMovementDecay(float movementDecay) {
        this.movementDecay = movementDecay;
    }

    @Override
    protected float getMotionDecayFactor() {
        return this.movementDecay;
    }

    public record BulletData<T>(BulletHandler.IBullet<T> bullet, T data) {
        public static final DualCodec<RegistryFriendlyByteBuf, BulletData<?>> CODECS = DualCodecs.RESOURCE_LOCATION.castStream().dispatch(bd -> BulletHandler.findRegistryName(bd.bullet), rl -> BulletData.specificCodec(BulletHandler.getBullet(rl)));

        public BulletData(BulletHandler.IBullet<T> bullet) {
            this(bullet, bullet.getCodec().defaultValue());
        }

        public void onHitTarget(Level level, HitResult mop, UUID shooterUUID, RevolvershotEntity revolvershotEntity, boolean headshot) {
            this.bullet.onHitTarget(level, mop, shooterUUID, (Entity)revolvershotEntity, headshot, this.data);
        }

        public <T1> T1 getForOptional(BulletHandler.IBullet<T1> type) {
            return type == this.bullet ? (T1)this.data : null;
        }

        public <T1> T1 getFor(BulletHandler.IBullet<T1> type) {
            return (T1)Preconditions.checkNotNull(this.getForOptional(type));
        }

        private static <T> DualMapCodec<RegistryFriendlyByteBuf, BulletData<?>> specificCodec(BulletHandler.IBullet<T> bullet) {
            DualCodec codec = bullet.getCodec().codecs().map(t -> new BulletData<Object>(bullet, t), bd -> bd.data);
            return codec.castStream().fieldOf("data");
        }
    }
}

