/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class ConnectorBlock<T extends BlockEntity>
extends IEEntityBlock<T> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).noOcclusion().dynamicShape();
    public static final EnumProperty<Direction> DEFAULT_FACING_PROP = IEProperties.FACING_ALL;

    public ConnectorBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<T>> entityType) {
        super(entityType, props.pushReaction(PushReaction.BLOCK));
        this.lightOpacity = 0;
    }

    public ConnectorBlock(BlockBehaviour.Properties props, BiFunction<BlockPos, BlockState, T> entityType) {
        super(entityType, props.pushReaction(PushReaction.BLOCK));
        this.lightOpacity = 0;
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnergyConnectorBlockEntity connector;
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof EnergyConnectorBlockEntity && world.isEmptyBlock(pos.relative((connector = (EnergyConnectorBlockEntity)te).getFacing()))) {
            ConnectorBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
            connector.getLevelNonnull().removeBlock(pos, false);
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult targetIn, LevelReader world, BlockPos pos, Player player) {
        if (player != null && player.isShiftKeyDown() && world instanceof Level && targetIn instanceof BlockHitResult) {
            BlockHitResult target = (BlockHitResult)targetIn;
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof IImmersiveConnectable) {
                ConnectionPoint cp;
                TargetingInfo subTarget = new TargetingInfo(target.getDirection(), (float)target.getLocation().x - (float)pos.getX(), (float)target.getLocation().y - (float)pos.getY(), (float)target.getLocation().z - (float)pos.getZ());
                BlockPos masterPos = ((IImmersiveConnectable)te).getConnectionMaster(null, subTarget);
                if (masterPos != pos) {
                    te = world.getBlockEntity(masterPos);
                }
                if (te instanceof IImmersiveConnectable && (cp = ((IImmersiveConnectable)te).getTargetedPoint(subTarget, (Vec3i)masterPos.subtract((Vec3i)pos))) != null) {
                    for (Connection c : GlobalWireNetwork.getNetwork((Level)world).getLocalNet(cp).getConnections(cp)) {
                        if (c.isInternal()) continue;
                        return c.type.getWireCoil(c);
                    }
                }
            }
        }
        return super.getCloneItemStack(state, targetIn, world, pos, player);
    }
}

