/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import com.google.common.base.Preconditions;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Connection {
    public static final int RENDER_POINTS_PER_WIRE = 16;
    @Nonnull
    public final WireType type;
    @Nonnull
    private final ConnectionPoint endA;
    @Nonnull
    private final ConnectionPoint endB;
    private final boolean internal;
    private double length;
    private Vec3 endAOffset;
    private Vec3 endBOffset;
    @Nullable
    private CatenaryData catData;
    boolean blockDataGenerated = false;
    @Nullable
    private LocalWireNetwork cachedLocalNet;
    private int cachedNetVersion = -1;

    private Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, Vec3 endAOffset, Vec3 endBOffset, boolean internal) {
        Preconditions.checkState((!endA.equals(endB) ? 1 : 0) != 0);
        this.type = type;
        if (endA.compareTo(endB) < 0) {
            this.endA = endB;
            this.endB = endA;
            this.resetCatenaryData(endBOffset, endAOffset);
        } else {
            this.endA = endA;
            this.endB = endB;
            this.resetCatenaryData(endAOffset, endBOffset);
        }
        this.internal = internal;
    }

    public Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, Vec3 endAOffset, Vec3 endBOffset) {
        this(type, endA, endB, endAOffset, endBOffset, false);
    }

    public Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, GlobalWireNetwork netForOffsets) {
        this(type, endA, endB, WireUtils.getConnectionOffset(netForOffsets, endA, endB, type), WireUtils.getConnectionOffset(netForOffsets, endB, endA, type), false);
    }

    public Connection(BlockPos pos, int idA, int idB) {
        this(WireType.INTERNAL_CONNECTION, new ConnectionPoint(pos, idA), new ConnectionPoint(pos, idB), Vec3.ZERO, Vec3.ZERO, true);
    }

    public Connection(CompoundTag nbt) {
        this(WireType.getValue(nbt.getString("type")), new ConnectionPoint(nbt.getCompound("endA")), new ConnectionPoint(nbt.getCompound("endB")), WireUtils.loadVec3(nbt.get("endAOffset")), WireUtils.loadVec3(nbt.get("endBOffset")), nbt.getBoolean("internal"));
    }

    public ConnectionPoint getOtherEnd(ConnectionPoint known) {
        if (known.equals(this.endA)) {
            return this.endB;
        }
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndA() {
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndB() {
        return this.endB;
    }

    public LocalWireNetwork getContainingNet(GlobalWireNetwork global) {
        if (this.cachedLocalNet == null || this.cachedLocalNet.getVersion() != this.cachedNetVersion && !this.cachedLocalNet.isValid(this.getEndA())) {
            this.cachedLocalNet = global.getLocalNet(this.getEndA());
        }
        if (this.cachedLocalNet != null) {
            this.cachedNetVersion = this.cachedLocalNet.getVersion();
        }
        return this.cachedLocalNet;
    }

    public boolean isPositiveEnd(ConnectionPoint p) {
        return p.equals(this.endA);
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("endA", (Tag)this.endA.createTag());
        nbt.put("endB", (Tag)this.endB.createTag());
        nbt.putString("type", this.type.getUniqueName());
        nbt.putBoolean("internal", this.internal);
        nbt.put("endAOffset", WireUtils.storeVec3(this.endAOffset));
        nbt.put("endBOffset", WireUtils.storeVec3(this.endBOffset));
        return nbt;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public static CatenaryData makeCatenaryData(Vec3 vecA, Vec3 vecB, double slack) {
        Vec3 delta = vecB.subtract(vecA);
        double horLength = Math.sqrt(delta.x * delta.x + delta.z * delta.z);
        if (Math.abs(delta.x) < 0.05 && Math.abs(delta.z) < 0.05) {
            return new CatenaryData(true, 0.0, 0.0, 1.0, delta, 0.0, vecA);
        }
        double wireLength = delta.length() * slack;
        double goal = Math.sqrt(wireLength * wireLength - delta.y * delta.y) / horLength;
        double lower = 0.0;
        double upper = 1.0;
        while (Math.sinh(upper) / upper < goal) {
            lower = upper;
            upper *= 2.0;
        }
        int iterations = 20;
        for (int i = 0; i < 20; ++i) {
            double middleL = (lower + upper) / 2.0;
            double middleVal = Math.sinh(middleL) / middleL;
            if (middleVal < goal) {
                lower = middleL;
                continue;
            }
            if (middleVal > goal) {
                upper = middleL;
                continue;
            }
            upper = lower = middleL;
            break;
        }
        double l = (lower + upper) / 2.0;
        double scale = horLength / (2.0 * l);
        double offsetX = (0.0 + horLength - scale * Math.log((wireLength + delta.y) / (wireLength - delta.y))) * 0.5;
        double offsetY = (delta.y + 0.0 - wireLength * Math.cosh(l) / Math.sinh(l)) * 0.5;
        return new CatenaryData(false, offsetX, offsetY, scale, delta, horLength, vecA);
    }

    public boolean isEnd(ConnectionPoint p) {
        return p.equals(this.endA) || p.equals(this.endB);
    }

    public Vec3 getPoint(double pos, ConnectionPoint from) {
        pos = this.transformPosition(pos, from);
        Vec3 basic = this.getCatenaryData().getPoint(pos);
        Vec3 add = Vec3.ZERO;
        if (this.endB.equals(from)) {
            add = Vec3.atLowerCornerOf((Vec3i)this.endA.position().subtract((Vec3i)this.endB.position()));
        }
        return basic.add(add);
    }

    public double getSlope(double pos, ConnectionPoint from) {
        pos = this.transformPosition(pos, from);
        double slope = this.getCatenaryData().getSlope(pos);
        if (this.endB.equals(from)) {
            slope *= -1.0;
        }
        return slope;
    }

    public double transformPosition(double pos, ConnectionPoint from) {
        if (this.endB.equals(from)) {
            return 1.0 - pos;
        }
        return pos;
    }

    public ConnectionPoint getEndFor(BlockPos pos) {
        return this.endA.position().equals((Object)pos) ? this.endA : this.endB;
    }

    @Nonnull
    public CatenaryData getCatenaryData() {
        if (this.catData == null) {
            this.catData = Connection.makeCatenaryData(this.endAOffset, Vec3.atLowerCornerOf((Vec3i)this.endB.position().subtract((Vec3i)this.endA.position())).add(this.endBOffset), this.type.getSlack());
        }
        return this.catData;
    }

    void resetCatenaryData(Vec3 newOffsetA, Vec3 newOffsetB) {
        this.catData = null;
        this.endAOffset = newOffsetA;
        this.endBOffset = newOffsetB;
        this.length = Math.sqrt(this.endA.position().distSqr((Vec3i)this.endB.position()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.endA.equals(that.endA)) {
            return false;
        }
        return this.endB.equals(that.endB);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.endA.hashCode();
        result = 31 * result + this.endB.hashCode();
        result = 31 * result + (this.internal ? 1 : 0);
        return result;
    }

    public String toString() {
        StringJoiner ret = new StringJoiner(", ", Connection.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("endA=" + String.valueOf(this.endA)).add("endB=" + String.valueOf(this.endB));
        if (this.internal) {
            ret.add("internal");
        }
        return ret.toString();
    }

    public ConnectionPoint[] getEnds() {
        return new ConnectionPoint[]{this.endA, this.endB};
    }

    public double getLength() {
        return this.length;
    }

    public Vec3 getEndAOffset() {
        return this.endAOffset;
    }

    public Vec3 getEndBOffset() {
        return this.endBOffset;
    }

    public record CatenaryData(boolean isVertical, double offsetX, double offsetY, double scale, Vec3 delta, double horLength, Vec3 vecA) {
        public CatenaryData reverse(Vec3 otherEndAVec) {
            Vec3 delta = this.delta().scale(-1.0);
            double offsetX = this.horLength - this.offsetX();
            double offsetY = -this.scale * Math.cosh(-offsetX / this.scale);
            return new CatenaryData(this.isVertical, offsetX, offsetY, this.scale, delta, this.horLength, otherEndAVec);
        }

        public double getSlope(double pos) {
            pos = Mth.clamp((double)pos, (double)0.0, (double)1.0);
            if (this.isVertical) {
                return Double.POSITIVE_INFINITY * Math.signum(this.getDeltaY());
            }
            return Math.sinh((pos * this.horLength - this.offsetX) / this.scale);
        }

        public Vec3 getPoint(double pos) {
            if (pos == 1.0) {
                return this.vecA.add(this.delta);
            }
            double x = this.delta.x * pos;
            double y = this.isVertical ? this.delta.y * pos : this.scale * Math.cosh((this.horLength * pos - this.offsetX) / this.scale) + this.offsetY;
            double z = this.delta.z * pos;
            return this.vecA.add(x, y, z);
        }

        public double getDeltaX() {
            return this.delta.x;
        }

        public double getDeltaY() {
            return this.delta.y;
        }

        public double getDeltaZ() {
            return this.delta.z;
        }

        public Vec3 getRenderPoint(int index) {
            return this.getPoint((double)index / 16.0);
        }
    }
}

