/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.pkpcpbp;

import at.petrak.pkpcpbp.MiscUtil;
import at.petrak.pkpcpbp.cfg.CurseforgeInfoExtension;
import at.petrak.pkpcpbp.cfg.ModInfoExtension;
import at.petrak.pkpcpbp.cfg.ModrinthInfoExtension;
import at.petrak.pkpcpbp.cfg.PKExtension;
import at.petrak.pkpcpbp.cfg.SubprojExtension;
import com.modrinth.minotaur.Minotaur;
import com.modrinth.minotaur.ModrinthExtension;
import com.modrinth.minotaur.TaskModrinthUpload;
import com.modrinth.minotaur.dependencies.DependencyType;
import com.modrinth.minotaur.dependencies.VersionDependency;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.darkhax.curseforgegradle.CurseForgeGradlePlugin;
import net.darkhax.curseforgegradle.TaskPublishCurseForge;
import net.darkhax.curseforgegradle.UploadArtifact;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PKSubprojPlugin
implements Plugin<Project> {
    private SubprojExtension cfg;
    private PKExtension rootCfg;
    private String artifactId;
    private String versionDisplayName;

    public void apply(Project project) {
        this.cfg = (SubprojExtension)project.getExtensions().create("pkSubproj", SubprojExtension.class, new Object[0]);
        project.afterEvaluate(this::setupReal);
    }

    private void setupReal(Project project) {
        this.rootCfg = (PKExtension)project.getRootProject().getExtensions().getByType(PKExtension.class);
        ModInfoExtension modInfo = this.rootCfg.getModInfo();
        String changelog = MiscUtil.getMostRecentPush(project.getRootProject());
        boolean isRelease = MiscUtil.isRelease(changelog);
        if (this.rootCfg.superDebugInfo) {
            project.getLogger().warn(modInfo.toString());
            project.getLogger().warn(this.cfg.toString());
            project.getLogger().warn("isRelease: " + isRelease + "; do publish: " + this.cfg.pkPublish);
            project.getLogger().warn(changelog);
        }
        if (this.rootCfg.doProjectMetadata) {
            String ver;
            project.setGroup((Object)"at.petra-k");
            this.versionDisplayName = ver = this.getFullVersionString(project, isRelease);
            project.setVersion((Object)this.versionDisplayName);
            this.artifactId = modInfo.modID;
            project.setProperty("archivesBaseName", (Object)this.artifactId);
        } else {
            this.artifactId = this.cfg.artifactId;
            this.versionDisplayName = this.cfg.versionDisplayName;
        }
        if (this.rootCfg.setupJarMetadata) {
            this.configJava(project);
        }
        if (this.rootCfg.setupMavenMetadata) {
            this.configMaven(project);
        }
        project.getPlugins().apply(CurseForgeGradlePlugin.class);
        project.getPlugins().apply(Minotaur.class);
        project.getTasks().register("publishCurseForge", TaskPublishCurseForge.class, t -> this.setupCurseforge((TaskPublishCurseForge)t, changelog)).configure(t -> t.onlyIf($ -> isRelease && this.cfg.pkPublish));
        project.getTasks().register("publishModrinth", TaskModrinthUpload.class).configure(t -> t.onlyIf($ -> isRelease && this.cfg.pkPublish));
        this.setupModrinth(project, changelog);
    }

    private void configJava(Project project) {
        ModInfoExtension modInfo = this.rootCfg.getModInfo();
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        java.getToolchain().getLanguageVersion().set((Object)JavaLanguageVersion.of((int)this.rootCfg.javaVersion));
        java.withSourcesJar();
        java.withJavadocJar();
        project.getTasks().withType(JavaCompile.class).configureEach(it -> {
            it.getOptions().setEncoding("UTF-8");
            it.getOptions().getRelease().set((Object)this.rootCfg.javaVersion);
        });
        project.getTasks().named("jar", Jar.class).configure(jar -> {
            jar.manifest(mani -> {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("Specification-Title", modInfo.modID);
                attrs.put("Specification-Vendor", "petra-kat");
                attrs.put("Specification-Version", jar.getArchiveVersion().get());
                attrs.put("Implementation-Title", project.getName());
                attrs.put("Implementation-Version", jar.getArchiveVersion().get());
                attrs.put("Implementation-Vendor", "petra-kat");
                attrs.put("Implementation-Timestamp", LocalDateTime.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH)));
                attrs.put("Timestamp", System.currentTimeMillis());
                attrs.put("Built-On-Java", System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor"));
                attrs.put("Built-On-Minecraft", modInfo.mcVersion);
                mani.attributes(attrs);
            });
            if (this.rootCfg.superDebugInfo) {
                project.getLogger().warn("Jar manifest for {}:", jar.getArchiveFileName().get());
                jar.getManifest().getAttributes().forEach((k, v) -> project.getLogger().warn("  {} : {}", k, v));
            }
        });
    }

    private void configMaven(Project project) {
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        project.getTasks().withType(GenerateModuleMetadata.class).configureEach(it -> it.setEnabled(false));
        publishing.getPublications().register("mavenJava", MavenPublication.class, pub -> {
            pub.setArtifactId(this.artifactId);
            pub.from((SoftwareComponent)project.getComponents().getByName("java"));
            pub.getPom().withXml(xmlProvider -> {
                NodeList found;
                Element xml = xmlProvider.asElement();
                try {
                    found = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//dependencies/*", xml, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException(e);
                }
                for (int i = 0; i < found.getLength(); ++i) {
                    Node dep = found.item(i);
                    if (this.rootCfg.superDebugInfo) {
                        project.getLogger().warn("Removing dep: {}", (Object)dep);
                    }
                    dep.getParentNode().removeChild(dep);
                }
                if (this.rootCfg.superDebugInfo) {
                    project.getLogger().warn("Final XML: {}", (Object)xml);
                }
            });
        });
        publishing.repositories(it -> it.maven(maven -> {
            try {
                maven.setUrl((Object)new URL("file:///" + System.getenv("local_maven")));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void setupCurseforge(TaskPublishCurseForge task, String changelog) {
        CurseforgeInfoExtension userCfg = this.rootCfg.getCfInfo();
        task.apiToken = userCfg.token;
        Object mainJar = this.cfg.curseforgeJar;
        UploadArtifact mainUpload = task.upload((Object)userCfg.id, mainJar);
        mainUpload.displayName = this.versionDisplayName;
        mainUpload.addGameVersion((Object)this.rootCfg.getModInfo().mcVersion);
        mainUpload.addJavaVersion((Object)("Java " + this.rootCfg.javaVersion));
        mainUpload.releaseType = userCfg.stability;
        for (String dep : this.cfg.getCurseforgeDependencies()) {
            mainUpload.addRequirement((Object)dep);
        }
        mainUpload.addModLoader((Object)this.cfg.platform);
        mainUpload.changelog = "# " + changelog;
        mainUpload.changelogType = "markdown";
    }

    private void setupModrinth(Project project, String changelog) {
        ModrinthExtension modrinthExt = (ModrinthExtension)project.getExtensions().getByType(ModrinthExtension.class);
        ModrinthInfoExtension userCfg = this.rootCfg.getModrinthInfo();
        modrinthExt.getToken().set((Object)userCfg.token);
        modrinthExt.getUploadFile().set(this.cfg.modrinthJar);
        modrinthExt.getProjectId().set((Object)userCfg.id);
        modrinthExt.getVersionNumber().set((Object)this.rootCfg.getModInfo().modVersion);
        modrinthExt.getVersionName().set((Object)this.versionDisplayName);
        modrinthExt.getVersionType().set((Object)userCfg.stability);
        ArrayList<VersionDependency> deps = new ArrayList<VersionDependency>();
        for (String s : this.cfg.getModrinthDependencies()) {
            String[] split = s.split(":");
            String id = split[0];
            String version = split[1];
            DependencyType ty = split.length == 2 ? DependencyType.REQUIRED : DependencyType.valueOf((String)split[2]);
            deps.add(new VersionDependency(id, version, ty));
        }
        modrinthExt.getDependencies().addAll(deps);
        modrinthExt.getChangelog().set((Object)("# " + changelog));
    }

    private String getFullVersionString(Project project, boolean isRelease) {
        ModInfoExtension info = this.rootCfg.getModInfo();
        Object version = info.modVersion;
        if (!isRelease && System.getenv("BUILD_NUMBER") != null) {
            version = (String)version + "-pre-" + System.getenv("BUILD_NUMBER");
        }
        version = (String)version + "+%s-%s".formatted(info.mcVersion, this.cfg.platform);
        if (System.getenv("TAG_NAME") != null) {
            version = System.getenv("TAG_NAME").substring(1);
            project.getLogger().info("Version overridden to tag version " + (String)version);
        }
        return version;
    }
}

