/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.pkpcpbp;

import at.petrak.pkpcpbp.MiscUtil;
import at.petrak.pkpcpbp.cfg.PKExtension;
import com.diluv.schoomp.Webhook;
import com.diluv.schoomp.message.Message;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class PKPlugin
implements Plugin<Project> {
    private String changelog = "";
    private PKExtension cfg;

    public void apply(Project project) {
        this.cfg = (PKExtension)project.getExtensions().create("pkpcpbp", PKExtension.class, new Object[0]);
        project.afterEvaluate(this::applyReal);
    }

    private void applyReal(Project project) {
        if (this.cfg.superDebugInfo) {
            project.getLogger().warn(this.cfg.toString());
        }
        this.changelog = MiscUtil.getRawGitChangelogList(project);
        project.task("publishToDiscord", t -> t.doLast(this::pushWebhook));
    }

    private void pushWebhook(Task task) {
        try {
            String discordWebhook = System.getenv("discordWebhook");
            String buildUrl = System.getenv("BUILD_URL");
            if (discordWebhook == null || buildUrl == null) {
                task.getLogger().warn("Cannot send the webhook without the webhook url or the build url");
                return;
            }
            Webhook webhook = new Webhook(discordWebhook, "Petrak@ Patreon Gradle");
            Message message = new Message();
            message.setUsername("Patreon Early Access");
            message.setContent("New `%s` prerelease -- build #%s for %s!\nDownload it here: %s\nChangelog: ```\n%s\n```".formatted(this.cfg.getModInfo().modID, System.getenv("BUILD_NUMBER"), this.cfg.getModInfo().mcVersion, buildUrl, this.changelog));
            webhook.sendMessage(message);
        }
        catch (Exception exn) {
            task.getLogger().error("Failed to push Discord webhook.", (Throwable)exn);
        }
    }
}

