/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.pkpcpbp;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.gradle.api.Project;

public class MiscUtil {
    public static String getRawGitChangelogList(Project project) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        String gitHash = System.getenv("GIT_COMMIT");
        String gitPrevHash = System.getenv("GIT_PREVIOUS_COMMIT");
        String travisRange = System.getenv("TRAVIS_COMMIT_RANGE");
        if (gitHash != null && gitPrevHash != null) {
            project.exec(spec -> {
                spec.commandLine(new Object[]{"git", "log", "--pretty=tformat:- %s", gitPrevHash + "..." + gitHash});
                spec.setStandardOutput((OutputStream)stdout);
            });
        } else if (travisRange != null) {
            project.exec(spec -> {
                spec.commandLine(new Object[]{"git", "log", "--pretty=tformat:- %s", travisRange});
                spec.setStandardOutput((OutputStream)stdout);
            });
        } else {
            return "";
        }
        return stdout.toString();
    }

    public static String getMostRecentPush(Project project) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        project.exec(spec -> {
            spec.commandLine(new Object[]{"git", "log", "--pretty=tformat:%s", "HEAD~..HEAD"});
            spec.setStandardOutput((OutputStream)stdout);
        });
        return stdout.toString();
    }

    public static boolean isRelease(String changelog) {
        Pattern pat = Pattern.compile("^\\[release", 2);
        return pat.asPredicate().test(changelog);
    }
}

