/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat.common.command;

import at.petrak.paucal.xplat.PaucalGamerules;
import at.petrak.paucal.xplat.common.misc.PatPat;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CommandPatSound {
    public static void add(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"patsound").then(Commands.argument((String)"pattee", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> {
            Collection pattees = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"pattee");
            if (pattees.size() != 1) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.paucal.patSelf.bad_count", (Object[])new Object[]{pattees.size()}));
                return 0;
            }
            return CommandPatSound.execute(((GameProfile)pattees.iterator().next()).getId(), (CommandContext<CommandSourceStack>)ctx);
        }))).executes(ctx -> CommandPatSound.execute(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID(), (CommandContext<CommandSourceStack>)ctx)));
    }

    private static int execute(UUID target, CommandContext<CommandSourceStack> ctx) {
        boolean enabled = ((CommandSourceStack)ctx.getSource()).getLevel().getGameRules().getBoolean(PaucalGamerules.ALLOW_HEADPATS);
        if (!enabled) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.paucal.patSelf.disabled"));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        Vec3 pos = player != null ? player.getEyePosition() : ((CommandSourceStack)ctx.getSource()).getPosition();
        boolean ok = PatPat.tryPlayPatSound(target, pos, null, (Level)((CommandSourceStack)ctx.getSource()).getLevel());
        if (ok) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.paucal.patSelf.ok", (Object[])new Object[]{target.toString()}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.paucal.patSelf.err", (Object[])new Object[]{target.toString()}));
        return 0;
    }
}

