package at.petrak.paucal.xplat.common.sounds;

import at.petrak.paucal.xplat.common.ContributorsManifest;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import net.minecraft.class_4237;
import net.minecraft.class_5819;
import net.minecraft.client.sounds.*;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.CompletableFuture;

import static at.petrak.paucal.api.PaucalAPI.modLoc;

public class HeadpatSoundInstance implements class_1113 {

  // We need a dummy sound instance to get Minecraft with the program; duck-impling the CompletableFuture
  // below should prevent MC from playing the sound but just in case the supplied ogg is silent
  public static final String DUMMY_LOCATION = "dummy_headpat";

  protected final boolean isGithub;
  protected final String soundName;
  @Nullable
  // jorbis
  protected class_4228 stream;

  protected final class_243 pos;
  protected final float pitch;

  protected class_1111 dummySound;

  protected final class_5819 random;

  public HeadpatSoundInstance(String name, boolean isGithub, class_243 pos, float pitch,
      class_5819 random) {
    this.soundName = name;
    this.isGithub = isGithub;
    if (this.isGithub) {
      this.stream = ContributorsManifest.getSound(this.soundName);
    } else {
      this.stream = null;
    }

    this.pos = pos;
    this.pitch = pitch;
    this.random = random;
  }

  @Override
  public class_2960 method_4775() {
    return modLoc(DUMMY_LOCATION);
  }

  @Nullable
  @Override
  public class_1146 method_4783(class_1144 manager) {
    var weightedSounds = manager.method_4869(modLoc(DUMMY_LOCATION));
    if (weightedSounds == null) {
      this.dummySound = class_1144.field_5592;
    } else {
      this.dummySound = weightedSounds.method_4887(this.random);
    }

    return weightedSounds;
  }

  @Override
  public class_1111 method_4776() {
    return this.dummySound;
  }

  @Override
  public float method_4782() {
    return this.pitch;
  }

  @Override
  public double method_4784() {
    return this.pos.field_1352;
  }

  @Override
  public double method_4779() {
    return this.pos.field_1351;
  }

  @Override
  public double method_4778() {
    return this.pos.field_1350;
  }

  // Duck-implement Forge ...
  public CompletableFuture<class_4234> getStream(class_4237 soundBuffers, class_1111 sound, boolean looping) {
    return this.getXplatAudioStreamCommon(soundBuffers, looping);
  }

  // and fabric
  public CompletableFuture<class_4234> getAudioStream(class_4237 soundBuffers, class_2960 id,
      boolean looping) {
    return this.getXplatAudioStreamCommon(soundBuffers, looping);
  }

  protected CompletableFuture<class_4234> getXplatAudioStreamCommon(class_4237 soundBuffers,
      boolean looping) {
    if (this.isGithub) {
      if (this.stream == null) {
        return soundBuffers.method_19744(modLoc(DUMMY_LOCATION), looping);
      }

      var loadTheWholeStreamNow = new ImmediateAudioStream(this.stream);
      return CompletableFuture.completedFuture(loadTheWholeStreamNow);
    } else {
      var decompose = class_2960.method_12829(this.soundName);
      var actualSoundPath = class_2960.method_43902(decompose.method_12836(),
          "sounds/" + decompose.method_12832() + ".ogg");
      return soundBuffers.method_19744(actualSoundPath, looping);
    }
  }

  //

  @Override
  public float method_4781() {
    return 1f;
  }

  @Override
  public class_1114 method_4777() {
    return class_1114.field_5476;
  }

  @Override
  public class_3419 method_4774() {
    return class_3419.field_15248;
  }

  @Override
  public boolean method_4786() {
    return false;
  }

  @Override
  public boolean method_4787() {
    return false;
  }

  @Override
  public int method_4780() {
    return 0;
  }
}
