package at.petrak.paucal.api.contrib;

import F;
import I;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.networking.NetworkManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3518;

public class Contributor {
  private final UUID uuid;
  private final int level;
  private final boolean isDev;

  private final float pitchCenter, pitchVariance;
  private final List<HeadpatSpec> headpats;

  private final JsonObject otherVals;

  @ApiStatus.Internal
  public Contributor(UUID uuid, JsonObject cfg) {
    this.uuid = uuid;
    this.otherVals = cfg;

    this.level = this.getInt("paucal:contributor_level", 0);
    this.isDev = this.getBool("paucal:is_dev", false);
    this.pitchCenter = this.getFloat("paucal:pat_pitch", 1f);
    this.pitchVariance = this.getFloat("paucal:pat_variance", 0.5f);

    var patsRaw = this.otherVals.get("paucal:pat_sound");
    this.headpats = HeadpatSpec.loadFromJson(patsRaw);
  }

  public int getLevel() {
    return level;
  }

  public boolean isDev() {
    return isDev;
  }

  public UUID getUuid() {
    return uuid;
  }

  @ApiStatus.Internal
  public Collection<String> neededGithubSounds() {
    var out = new ArrayList<String>();
    for (var hp : this.headpats) {
      if (hp.type == HeadpatSpec.Type.GITHUB) {
        out.add(hp.location);
      }
    }
    return out;
  }

  /**
   * Logic happens clientside to the <em>patter</em>, the pattee gets a packet like everyone else
   *
   * @param patter
   */
  public boolean doHeadpatSound(class_243 patteePos, @Nullable class_1657 patter, class_1937 level) {
    if (this.headpats.isEmpty()) {
      return false;
    }

    if (level instanceof class_3218 slevel) {
      var idx = level.field_9229.method_43048(this.headpats.size());
      var patspec = this.headpats.get(idx);
      var pitch = this.pitchCenter + (float) (Math.random() - 0.5) * this.pitchVariance;

      var closeBy = slevel.method_18766(pl -> pl.method_19538().method_1025(patteePos) <= 64 * 64);
      NetworkManager.sendToPlayers(closeBy, patspec.makePacket(patteePos, pitch, patter));
    } // Otherwise, they will play the sound once they get the packet

    return true;
  }

  // =====

  @Nullable
  public String getString(String key) {
    return this.getString(key, null);
  }

  public String getString(String key, String fallback) {
    return class_3518.method_15253(otherVals, key, fallback);
  }

  @Nullable
  public Integer getInt(String key) {
    if (otherVals.has(key)) {
      return class_3518.method_15260(otherVals, key);
    } else {
      return null;
    }
  }

  public int getInt(String key, int fallback) {
    return class_3518.method_15282(otherVals, key, fallback);
  }

  @Nullable
  public Float getFloat(String key) {
    if (otherVals.has(key)) {
      return class_3518.method_15259(otherVals, key);
    } else {
      return null;
    }
  }

  public float getFloat(String key, float fallback) {
    return class_3518.method_15277(otherVals, key, fallback);
  }

  @Nullable
  public Boolean getBool(String key) {
    if (otherVals.has(key)) {
      return class_3518.method_15270(otherVals, key);
    } else {
      return null;
    }
  }

  public boolean getBool(String key, boolean fallback) {
    return class_3518.method_15258(this.otherVals, key, fallback);
  }


  public Set<String> allKeys() {
    return this.otherVals.keySet();
  }

  public JsonObject otherVals() {
    return this.otherVals;
  }
}
