/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat.common.advancement;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import at.petrak.paucal.xplat.common.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class BeContributorTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(i -> i.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)MinMaxBounds.Ints.CODEC.fieldOf("patron_level").forGetter(Instance::patronLevel), (App)Codec.BOOL.optionalFieldOf("is_dev").forGetter(Instance::isDev)).apply((Applicative)i, Instance::new));

    public void trigger(ServerPlayer player) {
        super.trigger(player, inst -> {
            UUID uuid = player.getUUID();
            Contributor profile = ContributorsManifest.getContributor(uuid);
            if (profile == null) {
                return false;
            }
            return inst.patronLevel.matches(profile.getLevel()) && (inst.isDev.isEmpty() || inst.isDev.get().booleanValue() == profile.isDev());
        });
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints patronLevel, Optional<Boolean> isDev) implements SimpleCriterionTrigger.SimpleInstance
    {
        public Criterion<Instance> criterion() {
            return ((BeContributorTrigger)((Object)ModRegistries.BE_CONTRIBUTOR_TRIGGER.get())).createCriterion((CriterionTriggerInstance)this);
        }
    }
}

