/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.xplat.common.msg.MsgHeadpatSoundS2C;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HeadpatSpec {
    protected final String location;
    protected final Type type;

    protected HeadpatSpec(String location) {
        this.location = location;
        this.type = location.contains(":") && ResourceLocation.tryParse((String)location) != null ? Type.VANILLA : Type.GITHUB;
    }

    public static List<HeadpatSpec> loadFromJson(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (GsonHelper.isStringValue((JsonElement)element)) {
            String loc = element.getAsString();
            HeadpatSpec single = new HeadpatSpec(loc);
            return List.of(single);
        }
        if (element instanceof JsonArray) {
            JsonArray arr = (JsonArray)element;
            ArrayList<HeadpatSpec> out = new ArrayList<HeadpatSpec>();
            for (JsonElement elt : arr) {
                if (GsonHelper.isStringValue((JsonElement)elt)) {
                    out.add(new HeadpatSpec(elt.getAsString()));
                    continue;
                }
                throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
            }
            return out;
        }
        throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
    }

    public MsgHeadpatSoundS2C makePacket(Vec3 pos, float pitch, @Nullable Player patter) {
        Optional<UUID> optUuid = Optional.ofNullable(patter).map(Entity::getUUID);
        return new MsgHeadpatSoundS2C(this.location, this.type == Type.GITHUB, pos, pitch, optUuid);
    }

    public static enum Type {
        VANILLA,
        GITHUB;

    }
}

