/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.jei;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.interop.utils.PatternDrawingUtil;
import at.petrak.hexcasting.interop.utils.PatternEntry;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class PatternDrawable
implements IDrawable {
    private final int width;
    private final int height;
    private boolean strokeOrder;
    private final List<PatternEntry> patterns;
    private final List<Vec2> pathfinderDots;

    public PatternDrawable(ResourceLocation pattern, int w, int h) {
        Registry<ActionRegistryEntry> regi = IXplatAbstractions.INSTANCE.getActionRegistry();
        ActionRegistryEntry entry = (ActionRegistryEntry)regi.m_7745_(pattern);
        this.strokeOrder = !HexUtils.isOfTag(regi, pattern, HexTags.Actions.PER_WORLD_PATTERN);
        PatternDrawingUtil.PatternRenderingData data = PatternDrawingUtil.loadPatterns(List.of(new Pair((Object)entry.prototype(), (Object)HexCoord.getOrigin())), 0.0f, 1.0f);
        this.patterns = data.patterns();
        this.pathfinderDots = data.pathfinderDots();
        this.width = w;
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PatternDrawable strokeOrder(boolean order) {
        this.strokeOrder = order;
        return this;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack ps = guiGraphics.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)xOffset - 0.5f + (float)this.width / 2.0f, (float)yOffset + (float)this.height / 2.0f, 0.0f);
        ps.m_85841_((float)this.width / 64.0f, (float)this.height / 64.0f, 1.0f);
        PatternDrawingUtil.drawPattern(guiGraphics, 0, 0, this.patterns, this.pathfinderDots, this.strokeOrder, -13422544, -15132648, -938735092, -2140773533);
        ps.m_85849_();
    }
}

