/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge;

import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.common.blocks.behavior.HexComposting;
import at.petrak.hexcasting.common.blocks.behavior.HexStrippables;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.casting.actions.spells.OpFlight;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpAltiora;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlockSetTypes;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexCommands;
import at.petrak.hexcasting.common.lib.HexCreativeTabs;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexLootFunctions;
import at.petrak.hexcasting.common.lib.HexMobEffects;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.common.lib.HexPotions;
import at.petrak.hexcasting.common.lib.HexRegistries;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.lib.hex.HexActions;
import at.petrak.hexcasting.common.lib.hex.HexArithmetics;
import at.petrak.hexcasting.common.lib.hex.HexContinuationTypes;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.common.lib.hex.HexSpecialHandlers;
import at.petrak.hexcasting.common.misc.AkashicTreeGrower;
import at.petrak.hexcasting.common.misc.BrainsweepingEvents;
import at.petrak.hexcasting.common.misc.PlayerPositionRecorder;
import at.petrak.hexcasting.common.misc.RegisterMisc;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import at.petrak.hexcasting.forge.ForgeHexClientInitializer;
import at.petrak.hexcasting.forge.ForgeHexConfig;
import at.petrak.hexcasting.forge.cap.CapSyncers;
import at.petrak.hexcasting.forge.cap.ForgeCapabilityHandler;
import at.petrak.hexcasting.forge.cap.adimpl.CapClientCastingStack;
import at.petrak.hexcasting.forge.datagen.ForgeHexDataGenerators;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.forge.interop.curios.CuriosRenderers;
import at.petrak.hexcasting.forge.lib.ForgeHexArgumentTypeRegistry;
import at.petrak.hexcasting.forge.lib.ForgeHexLootMods;
import at.petrak.hexcasting.forge.network.ForgePacketHandler;
import at.petrak.hexcasting.forge.network.MsgBrainsweepAck;
import at.petrak.hexcasting.forge.recipe.ForgeModConditionalIngredient;
import at.petrak.hexcasting.forge.recipe.ForgeUnsealedIngredient;
import at.petrak.hexcasting.interop.HexInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hexcasting")
public class ForgeHexInitializer {
    public ForgeHexInitializer() {
        ForgeHexInitializer.initConfig();
        ForgeHexInitializer.initRegistries();
        ForgeHexInitializer.initRegistry();
        ForgeHexInitializer.initListeners();
    }

    private static void initConfig() {
        Pair config = new ForgeConfigSpec.Builder().configure(ForgeHexConfig::new);
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Client::new);
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Server::new);
        HexConfig.setCommon((HexConfig.CommonConfigAccess)config.getLeft());
        HexConfig.setClient((HexConfig.ClientConfigAccess)clientConfig.getLeft());
        HexConfig.setServer((HexConfig.ServerConfigAccess)serverConfig.getLeft());
        ModLoadingContext mlc = ModLoadingContext.get();
        mlc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getRight());
        mlc.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        mlc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    public static void initRegistries() {
        Registry registry = BuiltInRegistries.f_257047_;
        if (!(registry instanceof MappedRegistry)) {
            return;
        }
        MappedRegistry rootRegistry = (MappedRegistry)registry;
        rootRegistry.unfreeze();
        IXplatAbstractions.INSTANCE.getActionRegistry();
        IXplatAbstractions.INSTANCE.getSpecialHandlerRegistry();
        IXplatAbstractions.INSTANCE.getIotaTypeRegistry();
        IXplatAbstractions.INSTANCE.getArithmeticRegistry();
        IXplatAbstractions.INSTANCE.getContinuationTypeRegistry();
        IXplatAbstractions.INSTANCE.getEvalSoundRegistry();
        rootRegistry.m_203521_();
    }

    private static void initRegistry() {
        ForgeHexInitializer.bind(Registries.f_256840_, HexSounds::registerSounds);
        HexBlockSetTypes.registerBlocks(BlockSetType::m_272115_);
        ForgeHexInitializer.bind(Registries.f_279569_, HexCreativeTabs::registerCreativeTabs);
        ForgeHexInitializer.bind(Registries.f_256747_, HexBlocks::registerBlocks);
        ForgeHexInitializer.bind(Registries.f_256913_, HexBlocks::registerBlockItems);
        ForgeHexInitializer.bind(Registries.f_256922_, HexBlockEntities::registerTiles);
        ForgeHexInitializer.bind(Registries.f_256913_, HexItems::registerItems);
        ForgeHexInitializer.bind(Registries.f_256764_, HexRecipeStuffRegistry::registerSerializers);
        ForgeHexInitializer.bind(Registries.f_256954_, HexRecipeStuffRegistry::registerTypes);
        ForgeHexInitializer.bind(Registries.f_256939_, HexEntities::registerEntities);
        ForgeHexInitializer.bind(Registries.f_256728_, HexAttributes::register);
        ForgeHexInitializer.bind(Registries.f_256929_, HexMobEffects::register);
        ForgeHexInitializer.bind(Registries.f_256973_, HexPotions::register);
        HexPotions.addRecipes();
        ForgeHexInitializer.bind(Registries.f_256890_, HexParticles::registerParticles);
        ForgeHexInitializer.bind(HexRegistries.IOTA_TYPE, HexIotaTypes::registerTypes);
        ForgeHexInitializer.bind(HexRegistries.ACTION, HexActions::register);
        ForgeHexInitializer.bind(HexRegistries.SPECIAL_HANDLER, HexSpecialHandlers::register);
        ForgeHexInitializer.bind(HexRegistries.ARITHMETIC, HexArithmetics::register);
        ForgeHexInitializer.bind(HexRegistries.CONTINUATION_TYPE, HexContinuationTypes::registerContinuations);
        ForgeHexInitializer.bind(HexRegistries.EVAL_SOUND, HexEvalSounds::register);
        ForgeHexArgumentTypeRegistry.ARGUMENT_TYPES.register(ForgeHexInitializer.getModEventBus());
        ForgeHexLootMods.REGISTRY.register(ForgeHexInitializer.getModEventBus());
        HexAdvancementTriggers.registerTriggers();
        RegisterMisc.register();
    }

    private static <T> void bind(ResourceKey<? extends Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeHexInitializer.getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void initListeners() {
        IEventBus modBus = ForgeHexInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.register(ForgeHexClientInitializer.class));
        modBus.addListener(evt -> evt.enqueueWork(() -> {
            ForgePacketHandler.init();
            HexComposting.setup();
            HexStrippables.init();
            AkashicTreeGrower.init();
            HexInterop.init();
        }));
        modBus.addListener(evt -> {
            HexBlocks.registerBlockCreativeTab(arg_0 -> ((BuildCreativeModeTabContentsEvent)evt).m_246326_(arg_0), evt.getTab());
            HexItems.registerItemCreativeTab((CreativeModeTab.Output)evt, evt.getTab());
        });
        modBus.addListener(evt -> {
            if (evt.getRegistryKey().equals((Object)Registries.f_256913_)) {
                CraftingHelper.register((ResourceLocation)ForgeUnsealedIngredient.ID, (IIngredientSerializer)ForgeUnsealedIngredient.Serializer.INSTANCE);
                CraftingHelper.register((ResourceLocation)ForgeModConditionalIngredient.ID, (IIngredientSerializer)ForgeModConditionalIngredient.Serializer.INSTANCE);
                HexStatistics.register();
                HexLootFunctions.registerSerializers((lift, id) -> Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)id, (Object)lift));
            }
        });
        evBus.register(CapClientCastingStack.class);
        evBus.addListener(evt -> {
            InteractionResult res = BrainsweepingEvents.interactWithBrainswept(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), null);
            if (res.m_19077_()) {
                evt.setCanceled(true);
                evt.setCancellationResult(res);
            }
        });
        evBus.addListener(evt -> BrainsweepingEvents.copyBrainsweepPostTransformation(evt.getEntity(), evt.getOutcome()));
        evBus.addListener(evt -> {
            LivingEntity patt10448$temp = evt.getEntity();
            if (patt10448$temp instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)patt10448$temp;
                OpFlight.tickDownFlight(splayer);
                OpAltiora.checkPlayerCollision(splayer);
            }
        });
        evBus.addListener(evt -> {
            Level patt10741$temp;
            if (evt.phase == TickEvent.Phase.END && (patt10741$temp = evt.level) instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)patt10741$temp;
                PlayerPositionRecorder.updateAllPlayers(world);
            }
        });
        evBus.addListener(evt -> PatternRegistryManifest.processRegistry(evt.getServer().m_129783_()));
        evBus.addListener(evt -> HexCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher()));
        evBus.addListener(evt -> {
            Optional pos = evt.getPosition();
            if (pos.isEmpty()) {
                return;
            }
            evt.setCanceled(ItemJewelerHammer.shouldFailToBreak(evt.getEntity(), evt.getState(), (BlockPos)pos.get()));
        });
        evBus.addListener(evt -> {
            Entity target = evt.getTarget();
            Entity patt11909$temp = evt.getTarget();
            if (patt11909$temp instanceof ServerPlayer) {
                Mob mob;
                ServerPlayer serverPlayer = (ServerPlayer)patt11909$temp;
                if (target instanceof Mob && IXplatAbstractions.INSTANCE.isBrainswept(mob = (Mob)target)) {
                    ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)MsgBrainsweepAck.of((Entity)mob));
                }
            }
        });
        evBus.addListener(evt -> {
            BlockState bs;
            Block output;
            if (!evt.isSimulated() && evt.getToolAction() == ToolActions.AXE_STRIP && (output = HexStrippables.STRIPPABLES.get((bs = evt.getState()).m_60734_())) != null) {
                evt.setFinalState(output.m_152465_(bs));
            }
        });
        modBus.addListener(ForgeCapabilityHandler::registerCaps);
        evBus.addGenericListener(ItemStack.class, ForgeCapabilityHandler::attachItemCaps);
        evBus.addGenericListener(BlockEntity.class, ForgeCapabilityHandler::attachBlockEntityCaps);
        evBus.addGenericListener(Entity.class, ForgeCapabilityHandler::attachEntityCaps);
        modBus.register(ForgeHexDataGenerators.class);
        modBus.register(ForgeCapabilityHandler.class);
        evBus.register(CapSyncers.class);
        modBus.addListener(e -> {
            e.add(EntityType.f_20532_, HexAttributes.GRID_ZOOM);
            e.add(EntityType.f_20532_, HexAttributes.SCRY_SIGHT);
        });
        if (ModList.get().isLoaded("curios")) {
            modBus.addListener(CuriosApiInterop::onInterModEnqueue);
            modBus.addListener(CuriosApiInterop::onClientSetup);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(CuriosRenderers::onLayerRegister));
        }
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

