/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.misc.HexMobEffect;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class HexMobEffects {
    private static final Map<ResourceLocation, MobEffect> EFFECTS = new LinkedHashMap<ResourceLocation, MobEffect>();
    public static final MobEffect ENLARGE_GRID = HexMobEffects.make("enlarge_grid", new HexMobEffect(MobEffectCategory.BENEFICIAL, 13137407)).m_19472_(HexAttributes.GRID_ZOOM, "d4afaf0f-df37-4253-9fa7-029e8e4415d9", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final MobEffect SHRINK_GRID = HexMobEffects.make("shrink_grid", new HexMobEffect(MobEffectCategory.HARMFUL, 15445276)).m_19472_(HexAttributes.GRID_ZOOM, "1ce492a9-8bf5-4091-a482-c6d9399e448a", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public static void register(BiConsumer<MobEffect, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, MobEffect> e : EFFECTS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends MobEffect> T make(String id, T effect) {
        MobEffect old = EFFECTS.put(HexAPI.modLoc(id), effect);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return effect;
    }
}

