/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpAddMotion;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "MAX_MOTION", "", "getMAX_MOTION", "()D", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "executeWithUserdata", "userData", "Lnet/minecraft/nbt/CompoundTag;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpAddMotion
implements SpellAction {
    @NotNull
    public static final OpAddMotion INSTANCE = new OpAddMotion();
    private static final double MAX_MOTION = 8192.0;

    private OpAddMotion() {
    }

    @Override
    public int getArgc() {
        return 2;
    }

    public final double getMAX_MOTION() {
        return MAX_MOTION;
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)userData, (String)"userData");
        Entity target = OperatorUtils.getEntity(args, 0, this.getArgc());
        Vec3 motion = OperatorUtils.getVec3(args, 1, this.getArgc());
        env.assertEntityInRange(target);
        double motionForCost = motion.m_82556_();
        if (CastingImage.Companion.checkAndMarkGivenMotion(userData, target)) {
            double d = motionForCost;
            motionForCost = d + 1.0;
        }
        Vec3 shrunkMotion = motion.m_82556_() > MAX_MOTION * MAX_MOTION ? motion.m_82541_().m_82490_(MAX_MOTION) : motion;
        Intrinsics.checkNotNullExpressionValue((Object)shrunkMotion, (String)"shrunkMotion");
        RenderedSpell renderedSpell = new Spell(target, shrunkMotion);
        long l = (long)(motionForCost * (double)10000L);
        Vec3 vec3 = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position().add(0.\u2026get.eyeHeight / 2.0, 0.0)");
        Vec3 vec32 = motion.m_82541_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"motion.normalize()");
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)new ParticleSpray(vec3, vec32, 0.0, 0.1, 0, 16, null)), 0L, 8, null);
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        throw new IllegalStateException();
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpAddMotion$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "target", "Lnet/minecraft/world/entity/Entity;", "motion", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)V", "getMotion", "()Lnet/minecraft/world/phys/Vec3;", "getTarget", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Entity target;
        @NotNull
        private final Vec3 motion;

        public Spell(@NotNull Entity target, @NotNull Vec3 motion) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
            this.target = target;
            this.motion = motion;
        }

        @NotNull
        public final Entity getTarget() {
            return this.target;
        }

        @NotNull
        public final Vec3 getMotion() {
            return this.motion;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.target.m_5997_(this.motion.f_82479_, this.motion.f_82480_, this.motion.f_82481_);
            this.target.f_19864_ = true;
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Entity component1() {
            return this.target;
        }

        @NotNull
        public final Vec3 component2() {
            return this.motion;
        }

        @NotNull
        public final Spell copy(@NotNull Entity target, @NotNull Vec3 motion) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
            return new Spell(target, motion);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Entity entity, Vec3 vec3, int n, Object object) {
            if ((n & 1) != 0) {
                entity = spell.target;
            }
            if ((n & 2) != 0) {
                vec3 = spell.motion;
            }
            return spell.copy(entity, vec3);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ", motion=" + this.motion + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + this.motion.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.motion, (Object)spell.motion);
        }
    }
}

