/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render.be;

import at.petrak.hexcasting.client.render.PatternTextureManager;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class BlockEntitySlateRenderer
implements BlockEntityRenderer<BlockEntitySlate> {
    public BlockEntitySlateRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BlockEntitySlate tile, float pPartialTick, PoseStack ps, MultiBufferSource buffer, int light, int overlay) {
        if (tile.pattern == null) {
            return;
        }
        BlockState bs = tile.m_58900_();
        if (PatternTextureManager.useTextures && !((Boolean)bs.m_61143_((Property)BlockSlate.ENERGIZED)).booleanValue()) {
            PatternTextureManager.renderPatternForSlate(tile, tile.pattern, ps, buffer, light, bs);
            return;
        }
        ShaderInstance oldShader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableDepthTest();
        ps.m_85836_();
        ps.m_85837_(0.5, 0.5, 0.5);
        AttachFace attchFace = (AttachFace)bs.m_61143_(BlockSlate.ATTACH_FACE);
        if (attchFace == AttachFace.WALL) {
            int quarters = -((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122416_() % 4;
            ps.m_252781_(Axis.f_252436_.m_252961_(1.5707964f * (float)quarters));
            ps.m_252781_(Axis.f_252403_.m_252961_((float)Math.PI));
        } else {
            int neg = attchFace == AttachFace.FLOOR ? -1 : 1;
            ps.m_252781_(Axis.f_252529_.m_252961_((float)neg * 1.5707964f));
            int quarters = (((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122416_() + 2) % 4;
            ps.m_252781_(Axis.f_252403_.m_252961_((float)neg * 1.5707964f * (float)quarters));
        }
        int resolution = 16;
        int padding = resolution * PatternTextureManager.paddingByBlockSize / PatternTextureManager.resolutionByBlockSize;
        ps.m_85837_(0.0, 0.0, -0.5);
        ps.m_85841_(1.0f / (float)resolution, 1.0f / (float)resolution, 1.0f / (float)resolution);
        ps.m_85837_(0.0, 0.0, 1.01);
        Boolean isLit = (Boolean)bs.m_61143_((Property)BlockSlate.ENERGIZED);
        float variance = isLit != false ? 2.5f : 0.5f;
        float speed = isLit != false ? 0.1f : 0.0f;
        List<Vec2> lines1 = tile.pattern.toLines(1.0f, Vec2.f_82462_);
        int stupidHash = tile.m_58899_().hashCode();
        List<Vec2> zappyPattern = RenderLib.makeZappy(lines1, RenderLib.findDupIndices(tile.pattern.positions()), 10, variance, speed, 0.2f, 0.0f, 1.0f, stupidHash);
        List<Vec2> zappyPatternSpace = RenderLib.makeZappy(lines1, RenderLib.findDupIndices(tile.pattern.positions()), 10, 0.5f, 0.0f, 0.2f, 0.0f, 1.0f, stupidHash);
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Vec2 point : zappyPatternSpace) {
            minX = Math.min(minX, (double)point.f_82470_);
            maxX = Math.max(maxX, (double)point.f_82470_);
            minY = Math.min(minY, (double)point.f_82471_);
            maxY = Math.max(maxY, (double)point.f_82471_);
        }
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        double scale = Math.min((double)(resolution - 2 * padding) / rangeX, (double)(resolution - 2 * padding) / rangeY);
        double offsetX = ((double)(-2 * padding) - rangeX * scale) / 2.0;
        double offsetY = ((double)(-2 * padding) - rangeY * scale) / 2.0;
        ArrayList<Vec2> zappyRenderSpace = new ArrayList<Vec2>();
        for (Vec2 point : zappyPattern) {
            zappyRenderSpace.add(new Vec2((float)(((double)point.f_82470_ - minX) * scale + offsetX + (double)padding), (float)(((double)point.f_82471_ - minY) * scale + offsetY + (double)padding)));
        }
        for (int i = 0; i < zappyRenderSpace.size(); ++i) {
            Vec2 v = (Vec2)zappyRenderSpace.get(i);
            zappyRenderSpace.set(i, new Vec2(-v.f_82470_, v.f_82471_));
        }
        int outer = isLit != false ? -10172161 : -2963256;
        int inner = isLit != false ? RenderLib.screenCol(outer) : -936236237;
        RenderLib.drawLineSeq(ps.m_85850_().m_252922_(), zappyRenderSpace, 1.0f, 0.0f, outer, outer);
        RenderLib.drawLineSeq(ps.m_85850_().m_252922_(), zappyRenderSpace, 0.4f, 0.01f, inner, inner);
        ps.m_85849_();
        RenderSystem.setShader(() -> oldShader);
    }
}

