/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlocks;
import com.mojang.datafixers.util.Pair;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.MapColor;

public class ScryingLensOverlays {
    public static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60734_() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt1640$temp = world.m_7702_(pos);
            if (patt1640$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt1640$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50065_, (lines, state, pos, observer, world, direction) -> {
            int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            float rCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | Mth.m_14159_((float)rCol, (float)gCol, (float)bCol);
            NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42703_), (Object)Component.m_237113_((String)String.valueOf(instrument.ordinal())).m_130938_(ScryingLensOverlays.color(ScryingLensOverlays.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41859_), (Object)Component.m_237113_((String)String.valueOf(note)).m_130938_(ScryingLensOverlays.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction) -> {
            BlockEntityAkashicBookshelf tile;
            CompoundTag iotaTag;
            BlockEntity patt3143$temp = world.m_7702_(pos);
            if (patt3143$temp instanceof BlockEntityAkashicBookshelf && (iotaTag = (tile = (BlockEntityAkashicBookshelf)patt3143$temp).getIotaTag()) != null) {
                Component display = IotaType.getDisplay(iotaTag);
                lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42517_), (Object)display));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50328_, (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = state.m_60674_(world, pos);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)Component.m_237113_((String)(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))).m_130938_(ScryingLensOverlays.redstoneColor(comparatorValue))));
            boolean compare = state.m_61143_((Property)ComparatorBlock.f_51854_) == ComparatorMode.COMPARE;
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41978_), (Object)Component.m_237113_((String)(compare ? ">=" : "-")).m_130938_(ScryingLensOverlays.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50030_, (lines, state, pos, observer, world, direction) -> {
            int power = ScryingLensOverlays.getPoweredRailStrength(world, pos, state);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41860_), (Object)Component.m_237113_((String)String.valueOf(power)).m_130938_(ScryingLensOverlays.redstoneColor(power, 9))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50146_, (lines, state, pos, observer, world, direction) -> lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42524_), (Object)Component.m_237113_((String)String.valueOf(state.m_61143_((Property)RepeaterBlock.f_55798_))).m_130940_(ChatFormatting.YELLOW))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60803_() && !state.m_60713_(Blocks.f_50328_), (lines, state, pos, observer, world, direction) -> {
            int signalStrength = 0;
            if (state.m_60734_() instanceof RedStoneWireBlock) {
                signalStrength = (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
            } else {
                for (Direction dir : Direction.values()) {
                    signalStrength = Math.max(signalStrength, state.m_60746_((BlockGetter)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)Component.m_237113_((String)String.valueOf(signalStrength)).m_130938_(ScryingLensOverlays.redstoneColor(signalStrength))));
        });
    }

    private static int getPoweredRailStrength(Level level, BlockPos pos, BlockState state) {
        if (level.m_276867_(pos)) {
            return 9;
        }
        int positiveValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, true, 0);
        int negativeValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, false, 0);
        return Math.max(positiveValue, negativeValue);
    }

    private static int findPoweredRailSignal(Level level, BlockPos pos, BlockState state, boolean travelPositive, int depth) {
        if (depth >= 8) {
            return 0;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        boolean descending = true;
        RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
        switch (shape) {
            case NORTH_SOUTH: {
                if (travelPositive) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case EAST_WEST: {
                if (travelPositive) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case ASCENDING_EAST: {
                if (travelPositive) {
                    --x;
                } else {
                    ++x;
                    ++y;
                    descending = false;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (travelPositive) {
                    --x;
                    ++y;
                    descending = false;
                } else {
                    ++x;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (travelPositive) {
                    ++z;
                } else {
                    --z;
                    ++y;
                    descending = false;
                }
                shape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (travelPositive) {
                    ++z;
                    ++y;
                    descending = false;
                } else {
                    --z;
                }
                shape = RailShape.NORTH_SOUTH;
            }
        }
        int power = ScryingLensOverlays.getPowerFromRail(level, new BlockPos(x, y, z), travelPositive, depth, shape);
        if (power > 0) {
            return power;
        }
        if (descending) {
            return ScryingLensOverlays.getPowerFromRail(level, new BlockPos(x, y - 1, z), travelPositive, depth, shape);
        }
        return 0;
    }

    private static UnaryOperator<Style> color(int color) {
        return style -> style.m_131148_(TextColor.m_131266_((int)color));
    }

    private static UnaryOperator<Style> redstoneColor(int power) {
        return ScryingLensOverlays.redstoneColor(power, 15);
    }

    private static UnaryOperator<Style> redstoneColor(int power, int max) {
        return ScryingLensOverlays.color(RedStoneWireBlock.m_55606_((int)Mth.m_14045_((int)(power * max / 15), (int)0, (int)15)));
    }

    private static int instrumentColor(NoteBlockInstrument instrument) {
        return switch (instrument) {
            case NoteBlockInstrument.BASEDRUM -> MapColor.f_283947_.f_283871_;
            case NoteBlockInstrument.SNARE, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.PLING -> MapColor.f_283761_.f_283871_;
            case NoteBlockInstrument.HAT -> MapColor.f_283942_.f_283871_;
            case NoteBlockInstrument.BASS -> MapColor.f_283825_.f_283871_;
            case NoteBlockInstrument.FLUTE -> MapColor.f_283744_.f_283871_;
            case NoteBlockInstrument.BELL -> MapColor.f_283757_.f_283871_;
            case NoteBlockInstrument.GUITAR -> MapColor.f_283930_.f_283871_;
            case NoteBlockInstrument.CHIME -> MapColor.f_283828_.f_283871_;
            case NoteBlockInstrument.IRON_XYLOPHONE -> MapColor.f_283906_.f_283871_;
            case NoteBlockInstrument.COW_BELL -> MapColor.f_283748_.f_283871_;
            case NoteBlockInstrument.DIDGERIDOO -> MapColor.f_283750_.f_283871_;
            case NoteBlockInstrument.BIT -> MapColor.f_283812_.f_283871_;
            case NoteBlockInstrument.BANJO -> MapColor.f_283832_.f_283871_;
            default -> -1;
        };
    }

    private static int getPowerFromRail(Level level, BlockPos pos, boolean travelPositive, int depth, RailShape shape) {
        BlockState otherState = level.m_8055_(pos);
        if (!otherState.m_60713_(Blocks.f_50030_)) {
            return 0;
        }
        RailShape otherShape = (RailShape)otherState.m_61143_((Property)PoweredRailBlock.f_55214_);
        if (shape == RailShape.EAST_WEST && (otherShape == RailShape.NORTH_SOUTH || otherShape == RailShape.ASCENDING_NORTH || otherShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (otherShape == RailShape.EAST_WEST || otherShape == RailShape.ASCENDING_EAST || otherShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        if (((Boolean)otherState.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            return level.m_276867_(pos) ? 8 - depth : ScryingLensOverlays.findPoweredRailSignal(level, pos, otherState, travelPositive, depth + 1);
        }
        return 0;
    }
}

