/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PatternTextureManager {
    public static boolean useTextures = true;
    public static int repaintIndex = 0;
    public static int resolutionScaler = 4;
    public static int fastRenderScaleFactor = 8;
    public static int resolutionByBlockSize = 128 * resolutionScaler;
    public static int paddingByBlockSize = 16 * resolutionScaler;
    public static int circleRadiusByBlockSize = 2 * resolutionScaler;
    public static int scaleLimit = 4 * resolutionScaler;
    public static int scrollLineWidth = 3 * resolutionScaler;
    public static int otherLineWidth = 4 * resolutionScaler;
    private static final ConcurrentMap<String, ResourceLocation> patternTexturesToAdd = new ConcurrentHashMap<String, ResourceLocation>();
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private static final HashMap<String, ResourceLocation> patternTextures = new HashMap();

    public static void setResolutionScaler(int resolutionScaler) {
        PatternTextureManager.resolutionScaler = resolutionScaler;
        resolutionByBlockSize = 128 * resolutionScaler;
        paddingByBlockSize = 16 * resolutionScaler;
        circleRadiusByBlockSize = 2 * resolutionScaler;
        scaleLimit = 4 * resolutionScaler;
        scrollLineWidth = 3 * resolutionScaler;
        otherLineWidth = 4 * resolutionScaler;
    }

    public static String getPointsKey(List<Vec2> zappyPoints) {
        return zappyPoints.stream().map(p -> String.format("(%f,%f)", Float.valueOf(p.f_82470_), Float.valueOf(p.f_82471_))).collect(Collectors.joining(";"));
    }

    public static HexPatternPoints generateHexPatternPoints(HexBlockEntity tile, HexPattern pattern, float flowIrregular) {
        int stupidHash = tile.m_58899_().hashCode();
        List<Vec2> lines1 = pattern.toLines(1.0f, Vec2.f_82462_);
        List<Vec2> zappyPoints = RenderLib.makeZappy(lines1, RenderLib.findDupIndices(pattern.positions()), 10, 0.5f, 0.0f, flowIrregular, 0.0f, 1.0f, stupidHash);
        return new HexPatternPoints(zappyPoints);
    }

    public static void renderPatternForScroll(String pointsKey, PoseStack ps, MultiBufferSource bufSource, int light, List<Vec2> zappyPoints, int blockSize, boolean showStrokeOrder) {
        PatternTextureManager.renderPattern(pointsKey, ps, bufSource, light, zappyPoints, blockSize, showStrokeOrder, false, true, false, false, true, -1);
    }

    public static void renderPatternForSlate(BlockEntitySlate tile, HexPattern pattern, PoseStack ps, MultiBufferSource buffer, int light, BlockState bs) {
        if (tile.points == null) {
            tile.points = PatternTextureManager.generateHexPatternPoints(tile, pattern, 0.2f);
        }
        boolean isOnWall = bs.m_61143_(BlockSlate.ATTACH_FACE) == AttachFace.WALL;
        boolean isOnCeiling = bs.m_61143_(BlockSlate.ATTACH_FACE) == AttachFace.CEILING;
        int facing = ((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122416_();
        PatternTextureManager.renderPatternForBlockEntity(tile.points, ps, buffer, light, isOnWall, isOnCeiling, true, facing);
    }

    public static void renderPatternForAkashicBookshelf(BlockEntityAkashicBookshelf tile, HexPattern pattern, PoseStack ps, MultiBufferSource buffer, int light, BlockState bs) {
        if (tile.points == null) {
            tile.points = PatternTextureManager.generateHexPatternPoints(tile, pattern, 0.0f);
        }
        int facing = ((Direction)bs.m_61143_((Property)BlockAkashicBookshelf.FACING)).m_122416_();
        PatternTextureManager.renderPatternForBlockEntity(tile.points, ps, buffer, light, true, false, false, facing);
    }

    public static void renderPatternForBlockEntity(HexPatternPoints points, PoseStack ps, MultiBufferSource buffer, int light, boolean isOnWall, boolean isOnCeiling, boolean isSlate, int facing) {
        ShaderInstance oldShader = RenderSystem.getShader();
        ps.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        PatternTextureManager.renderPattern(points.pointsKey, ps, buffer, light, points.zappyPoints, 1, false, true, isOnWall, isOnCeiling, isSlate, false, facing);
        ps.m_85849_();
        RenderSystem.setShader(() -> oldShader);
    }

    public static void renderPattern(String pointsKey, PoseStack ps, MultiBufferSource bufSource, int light, List<Vec2> zappyPoints, int blockSize, boolean showStrokeOrder, boolean useFullSize, boolean isOnWall, boolean isOnCeiling, boolean isSlate, boolean isScroll, int facing) {
        ps.m_85836_();
        PoseStack.Pose last = ps.m_85850_();
        Matrix4f mat = last.m_252922_();
        Matrix3f normal = last.m_252943_();
        float x = blockSize;
        float y = blockSize;
        float z = -0.0725f;
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        if (isOnWall) {
            if (isScroll) {
                ps.m_252880_((float)(-blockSize) / 2.0f, (float)(-blockSize) / 2.0f, 0.03125f);
                nz = -1.0f;
            } else {
                ps.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                if (isSlate) {
                    if (facing == 0) {
                        ps.m_252880_(0.0f, -1.0f, 0.0f);
                    }
                    if (facing == 1) {
                        ps.m_252880_(-1.0f, -1.0f, 0.0f);
                    }
                    if (facing == 2) {
                        ps.m_252880_(-1.0f, -1.0f, 1.0f);
                    }
                    if (facing == 3) {
                        ps.m_252880_(0.0f, -1.0f, 1.0f);
                    }
                } else {
                    z = -0.01f;
                    if (facing == 0) {
                        ps.m_252880_(0.0f, -1.0f, 1.0f);
                    }
                    if (facing == 1) {
                        ps.m_252880_(0.0f, -1.0f, 0.0f);
                    }
                    if (facing == 2) {
                        ps.m_252880_(-1.0f, -1.0f, 0.0f);
                    }
                    if (facing == 3) {
                        ps.m_252880_(-1.0f, -1.0f, 1.0f);
                    }
                }
                if (facing == 0) {
                    ps.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                }
                if (facing == 1) {
                    ps.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                }
                if (facing == 3) {
                    ps.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                }
                if (facing == 0 || facing == 2) {
                    nz = -1.0f;
                }
                if (facing == 1 || facing == 3) {
                    nx = -1.0f;
                }
                ps.m_252880_(0.0f, 0.0f, 0.0f);
            }
        } else {
            if (facing == 0) {
                ps.m_252880_(0.0f, 0.0f, 0.0f);
            }
            if (facing == 1) {
                ps.m_252880_(1.0f, 0.0f, 0.0f);
            }
            if (facing == 2) {
                ps.m_252880_(1.0f, 0.0f, 1.0f);
            }
            if (facing == 3) {
                ps.m_252880_(0.0f, 0.0f, 1.0f);
            }
            ps.m_252781_(Axis.f_252436_.m_252977_((float)(facing * -90)));
            if (isOnCeiling) {
                ps.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                ps.m_252880_(0.0f, -1.0f, 1.0f);
            } else {
                ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            nz = -1.0f;
        }
        int lineWidth = otherLineWidth;
        int outerColor = -2963256;
        int innerColor = -936236237;
        if (isScroll) {
            lineWidth = scrollLineWidth;
        }
        ResourceLocation texture = PatternTextureManager.getTexture(zappyPoints, pointsKey, blockSize, showStrokeOrder, lineWidth, useFullSize, new Color(innerColor), new Color(outerColor));
        VertexConsumer verts = bufSource.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        PatternTextureManager.vertex(mat, normal, light, verts, 0.0f, 0.0f, z, 0.0f, 0.0f, nx, ny, nz);
        PatternTextureManager.vertex(mat, normal, light, verts, 0.0f, y, z, 0.0f, 1.0f, nx, ny, nz);
        PatternTextureManager.vertex(mat, normal, light, verts, x, y, z, 1.0f, 1.0f, nx, ny, nz);
        PatternTextureManager.vertex(mat, normal, light, verts, x, 0.0f, z, 1.0f, 0.0f, nx, ny, nz);
        ps.m_85849_();
    }

    private static void vertex(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        verts.m_252986_(mat, x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
    }

    public static ResourceLocation getTexture(List<Vec2> points, String pointsKey, int blockSize, boolean showsStrokeOrder, float lineWidth, boolean useFullSize, Color innerColor, Color outerColor) {
        if (patternTexturesToAdd.containsKey(pointsKey)) {
            ResourceLocation patternTexture = (ResourceLocation)patternTexturesToAdd.remove(pointsKey);
            ResourceLocation oldPatternTexture = patternTextures.put(pointsKey, patternTexture);
            if (oldPatternTexture != null) {
                Minecraft.m_91087_().m_91097_().m_118506_(oldPatternTexture).close();
            }
            return patternTexture;
        }
        if (patternTextures.containsKey(pointsKey)) {
            return patternTextures.get(pointsKey);
        }
        executor.submit(() -> {
            DynamicTexture slowTexture = PatternTextureManager.createTexture(points, blockSize, showsStrokeOrder, lineWidth, useFullSize, innerColor, outerColor, false);
            Minecraft.m_91087_().execute(() -> PatternTextureManager.registerTexture(points, pointsKey, slowTexture, true));
        });
        DynamicTexture fastTexture = PatternTextureManager.createTexture(points, blockSize, showsStrokeOrder, lineWidth, useFullSize, innerColor, outerColor, true);
        return PatternTextureManager.registerTexture(points, pointsKey, fastTexture, false);
    }

    private static DynamicTexture createTexture(List<Vec2> points, int blockSize, boolean showsStrokeOrder, float lineWidth, boolean useFullSize, Color innerColor, Color outerColor, boolean fastRender) {
        int resolution = resolutionByBlockSize * blockSize;
        int padding = paddingByBlockSize * blockSize;
        if (fastRender) {
            resolution /= fastRenderScaleFactor;
            padding /= fastRenderScaleFactor;
            lineWidth /= (float)fastRenderScaleFactor;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Vec2 point : points) {
            minX = Math.min(minX, (double)point.f_82470_);
            maxX = Math.max(maxX, (double)point.f_82470_);
            minY = Math.min(minY, (double)point.f_82471_);
            maxY = Math.max(maxY, (double)point.f_82471_);
        }
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        double scale = Math.min((double)(resolution - 2 * padding) / rangeX, (double)(resolution - 2 * padding) / rangeY);
        double limit = blockSize * scaleLimit;
        if (!useFullSize && scale > limit) {
            scale = limit;
        }
        double offsetX = ((double)(resolution - 2 * padding) - rangeX * scale) / 2.0;
        double offsetY = ((double)(resolution - 2 * padding) - rangeY * scale) / 2.0;
        BufferedImage img = new BufferedImage(resolution, resolution, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(outerColor);
        g2d.setStroke(new BasicStroke((float)blockSize * 5.0f / 3.0f * lineWidth, 1, 1));
        PatternTextureManager.drawLines(g2d, points, minX, minY, scale, offsetX, offsetY, padding);
        g2d.setColor(innerColor);
        g2d.setStroke(new BasicStroke((float)blockSize * 2.0f / 3.0f * lineWidth, 1, 1));
        PatternTextureManager.drawLines(g2d, points, minX, minY, scale, offsetX, offsetY, padding);
        if (showsStrokeOrder) {
            g2d.setColor(new Color(-2655397));
            Tuple<Integer, Integer> point = PatternTextureManager.getTextureCoordinates(points.get(0), minX, minY, scale, offsetX, offsetY, padding);
            int spotRadius = circleRadiusByBlockSize * blockSize;
            PatternTextureManager.drawHexagon(g2d, (Integer)point.m_14418_(), (Integer)point.m_14419_(), spotRadius);
        }
        g2d.dispose();
        NativeImage nativeImage = new NativeImage(img.getWidth(), img.getHeight(), true);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                nativeImage.m_84988_(x, y, img.getRGB(x, y));
            }
        }
        return new DynamicTexture(nativeImage);
    }

    private static ResourceLocation registerTexture(List<Vec2> points, String pointsKey, DynamicTexture dynamicTexture, boolean isSlow) {
        String name = "hex_pattern_texture_" + points.hashCode() + "_" + repaintIndex + "_" + (isSlow ? "slow" : "fast") + ".png";
        ResourceLocation resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_(name, dynamicTexture);
        patternTexturesToAdd.put(pointsKey, resourceLocation);
        return resourceLocation;
    }

    private static void drawLines(Graphics2D g2d, List<Vec2> points, double minX, double minY, double scale, double offsetX, double offsetY, int padding) {
        for (int i = 0; i < points.size() - 1; ++i) {
            Tuple<Integer, Integer> pointFrom = PatternTextureManager.getTextureCoordinates(points.get(i), minX, minY, scale, offsetX, offsetY, padding);
            Tuple<Integer, Integer> pointTo = PatternTextureManager.getTextureCoordinates(points.get(i + 1), minX, minY, scale, offsetX, offsetY, padding);
            g2d.drawLine((Integer)pointFrom.m_14418_(), (Integer)pointFrom.m_14419_(), (Integer)pointTo.m_14418_(), (Integer)pointTo.m_14419_());
        }
    }

    private static Tuple<Integer, Integer> getTextureCoordinates(Vec2 point, double minX, double minY, double scale, double offsetX, double offsetY, int padding) {
        int x = (int)(((double)point.f_82470_ - minX) * scale + offsetX) + padding;
        int y = (int)(((double)point.f_82471_ - minY) * scale + offsetY) + padding;
        return new Tuple((Object)x, (Object)y);
    }

    private static void drawHexagon(Graphics2D g2d, int x, int y, int radius) {
        int fracOfCircle = 6;
        Polygon hexagon = new Polygon();
        for (int i = 0; i < fracOfCircle; ++i) {
            double theta = (double)i / (double)fracOfCircle * Math.PI * 2.0;
            int hx = (int)((double)x + Math.cos(theta) * (double)radius);
            int hy = (int)((double)y + Math.sin(theta) * (double)radius);
            hexagon.addPoint(hx, hy);
        }
        g2d.fill(hexagon);
    }

    public static void repaint() {
        ++repaintIndex;
        patternTexturesToAdd.clear();
        patternTextures.clear();
    }
}

