/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.entity;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.client.render.PatternTextureManager;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WallScrollRenderer
extends EntityRenderer<EntityWallScroll> {
    private static final ResourceLocation PRISTINE_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_large.png");
    private static final ResourceLocation PRISTINE_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_medium.png");
    private static final ResourceLocation PRISTINE_BG_SMOL = HexAPI.modLoc("textures/block/scroll_paper.png");
    private static final ResourceLocation ANCIENT_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_ancient_large.png");
    private static final ResourceLocation ANCIENT_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_ancient_medium.png");
    private static final ResourceLocation ANCIENT_BG_SMOL = HexAPI.modLoc("textures/block/ancient_scroll_paper.png");
    private static final ResourceLocation WHITE = HexAPI.modLoc("textures/entity/white.png");

    public WallScrollRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(EntityWallScroll wallScroll, float yaw, float partialTicks, PoseStack ps, MultiBufferSource bufSource, int packedLight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        ps.m_85836_();
        ps.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        ps.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)wallScroll.m_9236_(), (BlockPos)wallScroll.m_31748_());
        ps.m_85836_();
        ps.m_252880_((float)(-wallScroll.blockSize) / 2.0f, (float)(-wallScroll.blockSize) / 2.0f, 0.03125f);
        float dx = wallScroll.blockSize;
        float dy = wallScroll.blockSize;
        float dz = -0.0625f;
        float margin = 0.020833334f;
        PoseStack.Pose last = ps.m_85850_();
        Matrix4f mat = last.m_252922_();
        Matrix3f norm = last.m_252943_();
        VertexConsumer verts = bufSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(wallScroll)));
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, margin, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, margin, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f - margin, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f - margin, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        ps.m_85849_();
        if (PatternTextureManager.useTextures && wallScroll.points != null) {
            PatternTextureManager.renderPatternForScroll(wallScroll.points.pointsKey, ps, bufSource, light, wallScroll.points.zappyPoints, wallScroll.blockSize, wallScroll.getShowsStrokeOrder());
        }
        if (!PatternTextureManager.useTextures && wallScroll.points != null) {
            List<Vec2> points = wallScroll.points.zappyPoints;
            ps.m_85836_();
            ps.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            ps.m_252880_(0.0f, 0.0f, 0.06875f);
            float unCharlieKirk = Mth.m_14116_((float)(wallScroll.blockSize * wallScroll.blockSize + 60));
            float scale = 0.0033333334f * unCharlieKirk;
            ps.m_85841_(scale, scale, 0.01f);
            PoseStack.Pose last2 = ps.m_85850_();
            Matrix4f mat2 = last2.m_252922_();
            Matrix3f norm2 = last2.m_252943_();
            int outer = -2963256;
            int inner = -936236237;
            VertexConsumer verts2 = bufSource.m_6299_(RenderType.m_110452_((ResourceLocation)WHITE));
            WallScrollRenderer.theCoolerDrawLineSeq(mat2, norm2, light, verts2, points, (float)wallScroll.blockSize * 5.0f / 3.0f, outer);
            ps.m_85837_(0.0, 0.0, 0.01);
            WallScrollRenderer.theCoolerDrawLineSeq(mat2, norm2, light, verts2, points, (float)wallScroll.blockSize * 2.0f / 3.0f, inner);
            if (wallScroll.getShowsStrokeOrder()) {
                ps.m_85837_(0.0, 0.0, 0.01);
                float spotFrac = 0.8f * (float)wallScroll.blockSize;
                WallScrollRenderer.theCoolerDrawSpot(mat2, norm2, light, verts2, points.get(0), 0.6666667f * spotFrac, -10781737);
            }
            ps.m_85849_();
        }
        ps.m_85849_();
        super.m_7392_((Entity)wallScroll, yaw, partialTicks, ps, bufSource, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityWallScroll wallScroll) {
        if (wallScroll.isAncient) {
            if (wallScroll.blockSize <= 1) {
                return ANCIENT_BG_SMOL;
            }
            if (wallScroll.blockSize == 2) {
                return ANCIENT_BG_MEDIUM;
            }
            return ANCIENT_BG_LARGE;
        }
        if (wallScroll.blockSize <= 1) {
            return PRISTINE_BG_SMOL;
        }
        if (wallScroll.blockSize == 2) {
            return PRISTINE_BG_MEDIUM;
        }
        return PRISTINE_BG_LARGE;
    }

    private static void vertex(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        verts.m_252986_(mat, x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
    }

    private static void vertexCol(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, int col, Vec2 pos) {
        verts.m_252986_(mat, -pos.f_82470_, pos.f_82471_, 0.0f).m_193479_(col).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void theCoolerDrawLineSeq(Matrix4f mat, Matrix3f normalMat, int light, VertexConsumer verts, List<Vec2> points, float width, int color) {
        int i;
        if (points.size() <= 1) {
            return;
        }
        float[] joinAngles = new float[points.size()];
        float[] joinOffsets = new float[points.size()];
        for (i = 2; i < points.size(); ++i) {
            float angle;
            Vec2 p0 = points.get(i - 2);
            Vec2 p1 = points.get(i - 1);
            Vec2 p2 = points.get(i);
            Vec2 prev = p1.m_165910_(p0.m_165913_());
            Vec2 next = p2.m_165910_(p1.m_165913_());
            joinAngles[i - 1] = angle = (float)Mth.m_14136_((double)(prev.f_82470_ * next.f_82471_ - prev.f_82471_ * next.f_82470_), (double)(prev.f_82470_ * next.f_82470_ + prev.f_82471_ * next.f_82471_));
            float clamp = Math.min(prev.m_165907_(), next.m_165907_()) / (width * 0.5f);
            joinOffsets[i - 1] = Mth.m_14036_((float)(Mth.m_14031_((float)angle) / (1.0f + Mth.m_14089_((float)angle))), (float)(-clamp), (float)clamp);
        }
        for (i = 0; i < points.size() - 1; ++i) {
            Vec2 p1 = points.get(i);
            Vec2 p2 = points.get(i + 1);
            Vec2 tangent = p2.m_165910_(p1.m_165913_()).m_165902_().m_165903_(width * 0.5f);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            float jlow = joinOffsets[i];
            float jhigh = joinOffsets[i + 1];
            Vec2 p1Down = p1.m_165910_(tangent.m_165903_(Math.max(0.0f, jlow))).m_165910_(normal);
            Vec2 p1Up = p1.m_165910_(tangent.m_165903_(Math.max(0.0f, -jlow))).m_165910_(normal.m_165913_());
            Vec2 p2Down = p2.m_165910_(tangent.m_165903_(Math.max(0.0f, jhigh)).m_165913_()).m_165910_(normal);
            Vec2 p2Up = p2.m_165910_(tangent.m_165903_(Math.max(0.0f, -jhigh)).m_165913_()).m_165910_(normal.m_165913_());
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p2);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p2Up);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1Up);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1Down);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p2Down);
            WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p2);
            if (i <= 0) continue;
            float sangle = joinAngles[i];
            float angle = Math.abs(sangle);
            Vec2 rnormal = normal.m_165913_();
            int joinSteps = Mth.m_14167_((float)(angle * 180.0f / 56.548668f));
            if (joinSteps < 1) continue;
            if (sangle < 0.0f) {
                Vec2 prevVert = new Vec2(p1.f_82470_ - rnormal.f_82470_, p1.f_82471_ - rnormal.f_82471_);
                for (int j = 1; j <= joinSteps; ++j) {
                    Vec2 fan = RenderLib.rotate(rnormal, -sangle * ((float)j / (float)joinSteps));
                    Vec2 fanShift = new Vec2(p1.f_82470_ - fan.f_82470_, p1.f_82471_ - fan.f_82471_);
                    WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
                    WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
                    WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, fanShift);
                    WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, prevVert);
                    prevVert = fanShift;
                }
                continue;
            }
            Vec2 startFan = RenderLib.rotate(normal, -sangle);
            Vec2 prevVert = new Vec2(p1.f_82470_ - startFan.f_82470_, p1.f_82471_ - startFan.f_82471_);
            for (int j = joinSteps - 1; j >= 0; --j) {
                Vec2 fan = RenderLib.rotate(normal, -sangle * ((float)j / (float)joinSteps));
                Vec2 fanShift = new Vec2(p1.f_82470_ - fan.f_82470_, p1.f_82471_ - fan.f_82471_);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, p1);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, fanShift);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, prevVert);
                prevVert = fanShift;
            }
        }
        for (Vec2[] pair : new Vec2[][]{{points.get(0), points.get(1)}, {points.get(points.size() - 1), points.get(points.size() - 2)}}) {
            int joinSteps;
            Vec2 point = pair[0];
            Vec2 prev = pair[1];
            Vec2 tangent = point.m_165910_(prev.m_165913_()).m_165902_().m_165903_(0.5f * width);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            for (int j = joinSteps = Mth.m_14167_((float)10.0f); j > 0; --j) {
                Vec2 fan0 = RenderLib.rotate(normal, (float)(-Math.PI) * ((float)j / (float)joinSteps));
                Vec2 fan1 = RenderLib.rotate(normal, (float)(-Math.PI) * ((float)(j - 1) / (float)joinSteps));
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, point);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, point);
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, point.m_165910_(fan1));
                WallScrollRenderer.vertexCol(mat, normalMat, light, verts, color, point.m_165910_(fan0));
            }
        }
    }

    private static void theCoolerDrawSpot(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, Vec2 point, float radius, int color) {
        int fracOfCircle = 6;
        for (int i = 0; i < fracOfCircle; ++i) {
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, point);
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, point);
            for (int j = 0; j <= 1; ++j) {
                float theta = (float)(i - j) / (float)fracOfCircle * ((float)Math.PI * 2);
                float rx = Mth.m_14089_((float)theta) * radius + point.f_82470_;
                float ry = Mth.m_14031_((float)theta) * radius + point.f_82471_;
                WallScrollRenderer.vertexCol(mat, normal, light, verts, color, new Vec2(rx, ry));
            }
        }
    }
}

