/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.misc;

import com.mojang.datafixers.util.Unit;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Result<T, E> {
    public boolean isOk() {
        return this instanceof Ok;
    }

    public boolean isErr() {
        return this instanceof Err;
    }

    public T unwrap() {
        Result result = this;
        if (result instanceof Ok) {
            Ok ok = (Ok)result;
            return ok.ok;
        }
        throw new IllegalStateException("tried to unwrap an Err");
    }

    public E unwrapErr() {
        Result result = this;
        if (result instanceof Err) {
            Err err = (Err)result;
            return err.err;
        }
        throw new IllegalStateException("tried to unwrapErr an Ok");
    }

    public <T2, E2> Result<T2, E2> match(Function<T, T2> okBranch, Function<E, E2> errBranch) {
        Result result = this;
        if (result instanceof Ok) {
            Ok ok = (Ok)result;
            return new Ok(okBranch.apply(ok.ok));
        }
        result = this;
        if (result instanceof Err) {
            Err err = (Err)result;
            return new Err(errBranch.apply(err.err));
        }
        throw new IllegalStateException();
    }

    public void matchVoid(Consumer<T> okBranch, Consumer<E> errBranch) {
        this.match(ok -> {
            okBranch.accept(ok);
            return Unit.INSTANCE;
        }, err -> {
            errBranch.accept(err);
            return Unit.INSTANCE;
        });
    }

    public <U> U collapse(Function<T, U> okBranch, Function<E, U> errBranch) {
        Result result = this;
        if (result instanceof Ok) {
            Ok ok = (Ok)result;
            return okBranch.apply(ok.ok);
        }
        result = this;
        if (result instanceof Err) {
            Err err = (Err)result;
            return errBranch.apply(err.err);
        }
        throw new IllegalStateException();
    }

    public static final class Ok<T, E>
    extends Result<T, E> {
        public final T ok;

        public Ok(T ok) {
            this.ok = ok;
        }
    }

    public static final class Err<T, E>
    extends Result<T, E> {
        public final E err;

        public Err(E err) {
            this.err = err;
        }
    }
}

