/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.client;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class ScryingLensOverlayRegistry {
    private static final ConcurrentMap<ResourceLocation, OverlayBuilder> ID_LOOKUP = new ConcurrentHashMap<ResourceLocation, OverlayBuilder>();
    private static final List<Pair<OverlayPredicate, OverlayBuilder>> PREDICATE_LOOKUP = new Vector<Pair<OverlayPredicate, OverlayBuilder>>();

    public static void addDisplayer(Block block, OverlayBuilder displayer) {
        ScryingLensOverlayRegistry.addDisplayer(BuiltInRegistries.f_256975_.m_7981_((Object)block), displayer);
    }

    public static void addDisplayer(ResourceLocation blockID, OverlayBuilder displayer) {
        if (ID_LOOKUP.containsKey(blockID)) {
            throw new IllegalArgumentException("Already have a displayer for " + blockID);
        }
        ID_LOOKUP.put(blockID, displayer);
    }

    public static void addPredicateDisplayer(OverlayPredicate predicate, OverlayBuilder displayer) {
        PREDICATE_LOOKUP.add((Pair<OverlayPredicate, OverlayBuilder>)new Pair((Object)predicate, (Object)displayer));
    }

    @NotNull
    public static List<Pair<ItemStack, Component>> getLines(BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        ArrayList lines = Lists.newArrayList();
        OverlayBuilder idLookedup = (OverlayBuilder)ID_LOOKUP.get(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()));
        if (idLookedup != null) {
            idLookedup.addLines(lines, state, pos, observer, world, hitFace);
        }
        for (Pair<OverlayPredicate, OverlayBuilder> pair : PREDICATE_LOOKUP) {
            if (!((OverlayPredicate)pair.getFirst()).test(state, pos, observer, world, hitFace)) continue;
            ((OverlayBuilder)pair.getSecond()).addLines(lines, state, pos, observer, world, hitFace);
        }
        return lines;
    }

    @FunctionalInterface
    public static interface OverlayBuilder {
        public void addLines(List<Pair<ItemStack, Component>> var1, BlockState var2, BlockPos var3, Player var4, Level var5, Direction var6);
    }

    @FunctionalInterface
    public static interface OverlayPredicate {
        public boolean test(BlockState var1, BlockPos var2, Player var3, Level var4, Direction var5);
    }
}

