/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIota
extends Iota {
    public static IotaType<EntityIota> TYPE = new IotaType<EntityIota>(){

        @Override
        @Nullable
        public EntityIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast(tag, CompoundTag.f_128326_);
            Tag uuidTag = ctag.m_128423_("uuid");
            if (uuidTag == null) {
                return null;
            }
            UUID uuid = NbtUtils.m_129233_((Tag)uuidTag);
            Entity entity = world.m_8791_(uuid);
            if (entity == null) {
                return null;
            }
            return new EntityIota(entity);
        }

        @Override
        public Component display(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.entity.whoknows");
            }
            CompoundTag ctag = (CompoundTag)tag;
            if (!ctag.m_128425_("name", 8)) {
                return Component.m_237115_((String)"hexcasting.spelldata.entity.whoknows");
            }
            String nameJson = ctag.m_128461_("name");
            return Component.Serializer.m_130714_((String)nameJson).m_130940_(ChatFormatting.AQUA);
        }

        @Override
        public int color() {
            return -11141121;
        }
    };

    public EntityIota(@NotNull Entity e) {
        super(HexIotaTypes.ENTITY, e);
    }

    public Entity getEntity() {
        return (Entity)this.payload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!EntityIota.typesMatch(this, that)) return false;
        if (!(that instanceof EntityIota)) return false;
        EntityIota dent = (EntityIota)that;
        if (this.getEntity() != dent.getEntity()) return false;
        return true;
    }

    @Override
    public boolean isTruthy() {
        return true;
    }

    @Override
    @NotNull
    public Tag serialize() {
        CompoundTag out = new CompoundTag();
        out.m_128362_("uuid", this.getEntity().m_20148_());
        out.m_128359_("name", Component.Serializer.m_130703_((Component)this.getEntity().m_7755_()));
        return out;
    }

    @Override
    public Component display() {
        return this.getEntity().m_7755_().m_6881_().m_130940_(ChatFormatting.AQUA);
    }
}

