/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.CircleMishapEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CircleCastEnv
extends CastingEnvironment {
    protected final CircleExecutionState execState;

    public CircleCastEnv(ServerLevel world, CircleExecutionState execState) {
        super(world);
        this.execState = execState;
    }

    @Override
    @Nullable
    public LivingEntity getCastingEntity() {
        return this.execState.getCaster(this.world);
    }

    @Override
    @Nullable
    public ServerPlayer getCaster() {
        return this.execState.getCaster(this.world);
    }

    @Nullable
    public BlockEntityAbstractImpetus getImpetus() {
        BlockEntity entity = this.world.m_7702_(this.execState.impetusPos);
        if (entity instanceof BlockEntityAbstractImpetus) {
            return (BlockEntityAbstractImpetus)entity;
        }
        return null;
    }

    public CircleExecutionState circleState() {
        return this.execState;
    }

    @Override
    public MishapEnvironment getMishapEnvironment() {
        return new CircleMishapEnv(this.world, this.execState);
    }

    @Override
    public void precheckAction(PatternShapeMatch match) throws Mishap {
        super.precheckAction(match);
        ResourceLocation key = this.actionKey(match);
        if (!HexConfig.server().isActionAllowedInCircles(key)) {
            throw new MishapDisallowedSpell("disallowed_circle");
        }
    }

    @Override
    public void postExecution(CastResult result) {
        BlockEntityAbstractImpetus imp;
        super.postExecution(result);
        SoundEvent sound = result.getSound().sound();
        if (sound != null) {
            BlockPos soundPos = this.execState.currentPos;
            this.world.m_5594_(null, soundPos, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((imp = this.getImpetus()) != null) {
            for (OperatorSideEffect sideEffect : result.getSideEffects()) {
                OperatorSideEffect.DoMishap doMishap;
                Component msg;
                if (!(sideEffect instanceof OperatorSideEffect.DoMishap) || (msg = (doMishap = (OperatorSideEffect.DoMishap)sideEffect).getMishap().errorMessageWithName(this, doMishap.getErrorCtx())) == null) continue;
                imp.postMishap(msg);
            }
        }
    }

    @Override
    public Vec3 mishapSprayPos() {
        return Vec3.m_82512_((Vec3i)this.execState.currentPos);
    }

    @Override
    public long extractMediaEnvironment(long cost) {
        BlockEntityAbstractImpetus entity = this.getImpetus();
        if (entity == null) {
            return cost;
        }
        long mediaAvailable = entity.getMedia();
        if (mediaAvailable < 0L) {
            return 0L;
        }
        long mediaToTake = Math.min(cost, mediaAvailable);
        entity.setMedia(mediaAvailable - mediaToTake);
        return cost -= mediaToTake;
    }

    @Override
    public boolean isVecInRangeEnvironment(Vec3 vec) {
        ServerPlayer caster = this.execState.getCaster(this.world);
        if (caster != null) {
            if (vec.m_82557_(caster.m_20182_()) <= (double)(caster.m_20206_() * caster.m_20206_())) {
                return true;
            }
            Sentinel sentinel = HexAPI.instance().getSentinel(caster);
            if (sentinel != null && sentinel.extendsRange() && caster.m_9236_().m_46472_() == sentinel.dimension() && vec.m_82557_(sentinel.position()) <= 256.0) {
                return true;
            }
        }
        return this.execState.bounds.m_82390_(vec);
    }

    @Override
    public boolean hasEditPermissionsAtEnvironment(BlockPos pos) {
        return true;
    }

    @Override
    public InteractionHand getCastingHand() {
        return InteractionHand.MAIN_HAND;
    }

    @Override
    protected List<ItemStack> getUsableStacks(CastingEnvironment.StackDiscoveryMode mode) {
        return new ArrayList<ItemStack>();
    }

    @Override
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        return List.of();
    }

    @Override
    public boolean replaceItem(Predicate<ItemStack> stackOk, ItemStack replaceWith, @Nullable InteractionHand hand) {
        return false;
    }

    @Override
    public FrozenPigment getPigment() {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return FrozenPigment.DEFAULT.get();
        }
        return impetus.getPigment();
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return null;
        }
        return impetus.setPigment(pigment);
    }

    @Override
    public void produceParticles(ParticleSpray particles, FrozenPigment pigment) {
        particles.sprayParticles(this.world, pigment);
    }

    @Override
    public void printMessage(Component message) {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return;
        }
        impetus.postPrint(message);
    }
}

