/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.curios;

import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.common.items.magic.DebugUnlockerHolder;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.forge.interop.curios.CuriosRenderers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosApiInterop {
    public static void init() {
        DiscoveryHandlers.addLensPredicate(player -> {
            AtomicBoolean hasLens = new AtomicBoolean(false);
            player.getCapability(CuriosCapability.INVENTORY).ifPresent(handler -> {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get("head");
                if (stacksHandler != null) {
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        if (!stacks.getStackInSlot(i).m_150930_((Item)HexItems.SCRYING_LENS)) continue;
                        hasLens.set(true);
                        break;
                    }
                }
            });
            return hasLens.get();
        });
        DiscoveryHandlers.addManaHolderDiscoverer(harness -> {
            ArrayList holders = Lists.newArrayList();
            harness.getCtx().getCaster().getCapability(CuriosCapability.INVENTORY).ifPresent(handler -> {
                for (ICurioStacksHandler stacksHandler : handler.getCurios().values()) {
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ManaHolder holder;
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (!ManaHelper.isManaItem(stack) || (holder = IXplatAbstractions.INSTANCE.findManaHolder(stack)) == null) continue;
                        holders.add(holder);
                    }
                }
            });
            return holders;
        });
        DiscoveryHandlers.addManaHolderDiscoverer(harness -> {
            ArrayList holders = Lists.newArrayList();
            harness.getCtx().getCaster().getCapability(CuriosCapability.INVENTORY).ifPresent(handler -> {
                for (ICurioStacksHandler stacksHandler : handler.getCurios().values()) {
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (!ItemCreativeUnlocker.isDebug(stack)) continue;
                        holders.add(new DebugUnlockerHolder(stack));
                        return;
                    }
                }
            });
            return holders;
        });
    }

    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CuriosRenderers.register();
    }
}

