/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen.recipe.builders;

import at.petrak.hexcasting.datagen.recipe.builders.CompatProcessingOutput;
import at.petrak.hexcasting.datagen.recipe.builders.ItemProcessingOutput;
import at.petrak.hexcasting.datagen.recipe.builders.ProcessingOutput;
import at.petrak.hexcasting.datagen.recipe.builders.ToolIngredient;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmersDelightCuttingRecipeBuilder
implements RecipeBuilder {
    private String group = "";
    private final List<ProcessingOutput> outputs = Lists.newArrayList();
    private Ingredient input;
    private ToolIngredient toolAction;
    private SoundEvent sound;

    public FarmersDelightCuttingRecipeBuilder unlockedBy(String s, CriterionTriggerInstance criterionTriggerInstance) {
        return this;
    }

    @NotNull
    public FarmersDelightCuttingRecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public Item m_142372_() {
        return Items.f_41852_;
    }

    public FarmersDelightCuttingRecipeBuilder withInput(ItemLike item) {
        return this.withInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public FarmersDelightCuttingRecipeBuilder withInput(ItemStack stack) {
        return this.withInput(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public FarmersDelightCuttingRecipeBuilder withInput(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(ItemLike output) {
        return this.withOutput(1.0f, output, 1);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(float chance, ItemLike output) {
        return this.withOutput(chance, output, 1);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(ItemLike output, int count) {
        return this.withOutput(1.0f, output, count);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(float chance, ItemLike output, int count) {
        return this.withOutput(new ItemStack(output, count), chance);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(ItemStack output, float chance) {
        this.outputs.add(new ItemProcessingOutput(output, chance));
        return this;
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(String name) {
        return this.withOutput(1.0f, name, 1);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(String name, int count) {
        return this.withOutput(1.0f, name, count);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(float chance, String name) {
        return this.withOutput(chance, name, 1);
    }

    public FarmersDelightCuttingRecipeBuilder withOutput(float chance, String name, int count) {
        this.outputs.add(new CompatProcessingOutput(name, count, chance));
        return this;
    }

    public FarmersDelightCuttingRecipeBuilder withTool(ToolIngredient ingredient) {
        this.toolAction = ingredient;
        return this;
    }

    public FarmersDelightCuttingRecipeBuilder withSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public void m_142700_(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new CuttingRecipe(resourceLocation));
    }

    public class CuttingRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;

        public CuttingRecipe(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(@NotNull JsonObject json) {
            json.addProperty("type", "farmersdelight:cutting");
            if (!FarmersDelightCuttingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", FarmersDelightCuttingRecipeBuilder.this.group);
            }
            JsonArray jsonIngredients = new JsonArray();
            JsonArray jsonOutputs = new JsonArray();
            jsonIngredients.add(FarmersDelightCuttingRecipeBuilder.this.input.m_43942_());
            FarmersDelightCuttingRecipeBuilder.this.outputs.forEach(o -> jsonOutputs.add((JsonElement)o.serialize()));
            json.add("ingredients", (JsonElement)jsonIngredients);
            json.add("tool", (JsonElement)FarmersDelightCuttingRecipeBuilder.this.toolAction.serialize());
            json.add("result", (JsonElement)jsonOutputs);
            if (FarmersDelightCuttingRecipeBuilder.this.sound != null) {
                json.addProperty("sound", Registry.f_122821_.m_7981_((Object)FarmersDelightCuttingRecipeBuilder.this.sound).toString());
            }
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

