/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen.recipe.builders;

import at.petrak.hexcasting.datagen.recipe.builders.CompatProcessingOutput;
import at.petrak.hexcasting.datagen.recipe.builders.ItemProcessingOutput;
import at.petrak.hexcasting.datagen.recipe.builders.ProcessingOutput;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCrushingRecipeBuilder
implements RecipeBuilder {
    private String group = "";
    private Ingredient input;
    private final List<ProcessingOutput> results = new ArrayList<ProcessingOutput>();
    private int processingTime = 100;

    @NotNull
    public CreateCrushingRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance trigger) {
        return this;
    }

    @NotNull
    public CreateCrushingRecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public CreateCrushingRecipeBuilder duration(int duration) {
        this.processingTime = duration;
        return this;
    }

    public CreateCrushingRecipeBuilder withInput(ItemLike item) {
        return this.withInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CreateCrushingRecipeBuilder withInput(ItemStack stack) {
        return this.withInput(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public CreateCrushingRecipeBuilder withInput(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public CreateCrushingRecipeBuilder withOutput(ItemLike output) {
        return this.withOutput(1.0f, output, 1);
    }

    public CreateCrushingRecipeBuilder withOutput(float chance, ItemLike output) {
        return this.withOutput(chance, output, 1);
    }

    public CreateCrushingRecipeBuilder withOutput(ItemLike output, int count) {
        return this.withOutput(1.0f, output, count);
    }

    public CreateCrushingRecipeBuilder withOutput(float chance, ItemLike output, int count) {
        return this.withOutput(new ItemStack(output, count), chance);
    }

    public CreateCrushingRecipeBuilder withOutput(ItemStack output, float chance) {
        this.results.add(new ItemProcessingOutput(output, chance));
        return this;
    }

    public CreateCrushingRecipeBuilder withOutput(String name) {
        return this.withOutput(1.0f, name, 1);
    }

    public CreateCrushingRecipeBuilder withOutput(String name, int count) {
        return this.withOutput(1.0f, name, count);
    }

    public CreateCrushingRecipeBuilder withOutput(float chance, String name) {
        return this.withOutput(chance, name, 1);
    }

    public CreateCrushingRecipeBuilder withOutput(float chance, String name, int count) {
        this.results.add(new CompatProcessingOutput(name, count, chance));
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return Items.f_41852_;
    }

    public void m_142700_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation resourceLocation) {
        consumer.accept(new CrushingRecipe(resourceLocation));
    }

    public class CrushingRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;

        public CrushingRecipe(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(@NotNull JsonObject json) {
            json.addProperty("type", "create:crushing");
            if (!CreateCrushingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", CreateCrushingRecipeBuilder.this.group);
            }
            JsonArray jsonIngredients = new JsonArray();
            JsonArray jsonOutputs = new JsonArray();
            jsonIngredients.add(CreateCrushingRecipeBuilder.this.input.m_43942_());
            CreateCrushingRecipeBuilder.this.results.forEach(o -> jsonOutputs.add((JsonElement)o.serialize()));
            json.add("ingredients", (JsonElement)jsonIngredients);
            json.add("results", (JsonElement)jsonOutputs);
            int processingDuration = CreateCrushingRecipeBuilder.this.processingTime;
            if (processingDuration > 0) {
                json.addProperty("processingTime", (Number)processingDuration);
            }
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

