/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.loot;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.misc.ScrollQuantity;
import at.petrak.hexcasting.api.mod.HexConfig;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class HexLootHandler {
    public static final ResourceLocation FUNC_AMETHYST_SHARD_REDUCER = HexAPI.modLoc("amethyst_shard_reducer");
    public static final ResourceLocation TABLE_INJECT_AMETHYST_CLUSTER = HexAPI.modLoc("inject/amethyst_cluster");

    public static void lootLoad(ResourceLocation id, Consumer<LootPool> addPool) {
        if (id.equals((Object)Blocks.f_152492_.m_60589_())) {
            addPool.accept(HexLootHandler.getInjectPool(TABLE_INJECT_AMETHYST_CLUSTER));
        } else {
            ScrollQuantity scrolls = HexConfig.server().scrollsForLootTable(id);
            ResourceLocation injection = scrolls.getPool();
            if (injection != null) {
                addPool.accept(HexLootHandler.getInjectPool(injection));
            }
        }
    }

    public static LootPool getInjectPool(ResourceLocation entry) {
        return LootPool.m_79043_().m_79076_(HexLootHandler.getInjectEntry(entry, 1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(ResourceLocation table, int weight) {
        return LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight);
    }
}

