/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.HexTooltips;
import at.petrak.hexcasting.client.be.BlockEntityAkashicBookshelfRenderer;
import at.petrak.hexcasting.client.be.BlockEntitySlateRenderer;
import at.petrak.hexcasting.client.entity.WallScrollRenderer;
import at.petrak.hexcasting.client.particles.ConjureParticle;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.items.magic.ItemManaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public class RegisterClientStuff {
    public static void init() {
        RegisterClientStuff.registerDataHolderOverrides(HexItems.FOCUS);
        RegisterClientStuff.registerDataHolderOverrides(HexItems.SPELLBOOK);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.CYPHER);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.TRINKET);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.ARTIFACT);
        IClientXplatAbstractions x = IClientXplatAbstractions.INSTANCE;
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MANA_PREDICATE, (stack, level, holder, holderID) -> {
            ManaHolderItem item = (ManaHolderItem)stack.m_41720_();
            return item.getManaFullness(stack);
        });
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MAX_MANA_PREDICATE, (stack, level, holder, holderID) -> {
            ItemManaBattery item = (ItemManaBattery)stack.m_41720_();
            int max = item.getMaxMana(stack);
            return (float)Math.sqrt((float)max / 100000.0f / 10.0f);
        });
        RegisterClientStuff.registerScollOverrides(HexItems.SCROLL_SMOL);
        RegisterClientStuff.registerScollOverrides(HexItems.SCROLL_MEDIUM);
        RegisterClientStuff.registerScollOverrides(HexItems.SCROLL_LARGE);
        x.registerItemProperty((Item)HexItems.SLATE, ItemSlate.WRITTEN_PRED, (stack, level, holder, holderID) -> ItemSlate.hasPattern(stack) ? 1.0f : 0.0f);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_BIRCH);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_SPRUCE);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_JUNGLE);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_DARK_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_ACACIA);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_AKASHIC);
        HexTooltips.init();
        x.setRenderLayer(HexBlocks.CONJURED_LIGHT, RenderType.m_110463_());
        x.setRenderLayer(HexBlocks.CONJURED_BLOCK, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.AKASHIC_DOOR, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.AKASHIC_TRAPDOOR, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.SCONCE, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.AKASHIC_LEAVES1, RenderType.m_110457_());
        x.setRenderLayer((Block)HexBlocks.AKASHIC_LEAVES2, RenderType.m_110457_());
        x.setRenderLayer((Block)HexBlocks.AKASHIC_LEAVES3, RenderType.m_110457_());
        x.setRenderLayer(HexBlocks.AKASHIC_RECORD, RenderType.m_110466_());
        x.registerEntityRenderer(HexEntities.WALL_SCROLL, WallScrollRenderer::new);
        RegisterClientStuff.addScryingLensStuff();
    }

    private static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60734_() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt5759$temp = world.m_7702_(pos);
            if (patt5759$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt5759$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50065_, (lines, state, pos, observer, world, direction) -> {
            int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            float rCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | Mth.m_14159_((float)rCol, (float)gCol, (float)bCol);
            NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42703_), (Object)new TextComponent(String.valueOf(instrument.ordinal())).m_130938_(RegisterClientStuff.color(RegisterClientStuff.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41859_), (Object)new TextComponent(String.valueOf(note)).m_130938_(RegisterClientStuff.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt7262$temp = world.m_7702_(pos);
            if (patt7262$temp instanceof BlockEntityAkashicBookshelf) {
                BlockEntityAkashicBookshelf tile = (BlockEntityAkashicBookshelf)patt7262$temp;
                BlockPos recordPos = tile.getRecordPos();
                HexPattern pattern = tile.getPattern();
                if (recordPos != null && pattern != null) {
                    lines.add(new Pair((Object)new ItemStack((ItemLike)HexBlocks.AKASHIC_RECORD), (Object)new TranslatableComponent("hexcasting.tooltip.lens.akashic.bookshelf.location", new Object[]{recordPos.m_123344_()})));
                    BlockEntity patt7821$temp = world.m_7702_(recordPos);
                    if (patt7821$temp instanceof BlockEntityAkashicRecord) {
                        BlockEntityAkashicRecord record = (BlockEntityAkashicRecord)patt7821$temp;
                        lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42517_), (Object)record.getDisplayAt(pattern)));
                    }
                }
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_RECORD, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt8243$temp = world.m_7702_(pos);
            if (patt8243$temp instanceof BlockEntityAkashicRecord) {
                BlockEntityAkashicRecord tile = (BlockEntityAkashicRecord)patt8243$temp;
                int count = tile.getCount();
                lines.add(new Pair((Object)new ItemStack((ItemLike)HexBlocks.AKASHIC_BOOKSHELF), (Object)new TranslatableComponent("hexcasting.tooltip.lens.akashic.record.count" + (count == 1 ? ".single" : ""), new Object[]{count})));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50328_, (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(true);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)new TextComponent(comparatorValue == -1 ? "" : String.valueOf(comparatorValue)).m_130938_(RegisterClientStuff.redstoneColor(comparatorValue))));
            boolean compare = state.m_61143_((Property)ComparatorBlock.f_51854_) == ComparatorMode.COMPARE;
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41978_), (Object)new TextComponent(compare ? ">=" : "-").m_130938_(RegisterClientStuff.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50030_, (lines, state, pos, observer, world, direction) -> {
            int power = RegisterClientStuff.getPoweredRailStrength(world, pos, state);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41860_), (Object)new TextComponent(String.valueOf(power)).m_130938_(RegisterClientStuff.redstoneColor(power, 9))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50146_, (lines, state, pos, observer, world, direction) -> lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42524_), (Object)new TextComponent(String.valueOf(state.m_61143_((Property)RepeaterBlock.f_55798_))).m_130940_(ChatFormatting.YELLOW))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60734_() instanceof BeehiveBlock, (lines, state, pos, observer, world, direction) -> {
            int count = ScryingLensOverlayRegistry.getBeeValue();
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42785_), count == -1 ? new TextComponent("") : new TranslatableComponent("hexcasting.tooltip.lens.bee" + (count == 1 ? ".single" : ""), new Object[]{count})));
        });
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60803_() && !state.m_60713_(Blocks.f_50328_), (lines, state, pos, observer, world, direction) -> {
            int signalStrength = 0;
            if (state.m_60734_() instanceof RedStoneWireBlock) {
                signalStrength = (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
            } else {
                for (Direction dir : Direction.values()) {
                    signalStrength = Math.max(signalStrength, state.m_60746_((BlockGetter)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)new TextComponent(String.valueOf(signalStrength)).m_130938_(RegisterClientStuff.redstoneColor(signalStrength))));
        });
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60807_(), (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(false);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42351_), (Object)new TextComponent(comparatorValue == -1 ? "" : String.valueOf(comparatorValue)).m_130938_(RegisterClientStuff.redstoneColor(comparatorValue))));
        });
    }

    private static UnaryOperator<Style> color(int color) {
        return style -> style.m_131148_(TextColor.m_131266_((int)color));
    }

    private static UnaryOperator<Style> redstoneColor(int power) {
        return RegisterClientStuff.redstoneColor(power, 15);
    }

    private static UnaryOperator<Style> redstoneColor(int power, int max) {
        return RegisterClientStuff.color(RedStoneWireBlock.m_55606_((int)Mth.m_14045_((int)(power * max / 15), (int)0, (int)15)));
    }

    private static int instrumentColor(NoteBlockInstrument instrument) {
        return switch (instrument) {
            case NoteBlockInstrument.BASEDRUM -> MaterialColor.f_76409_.f_76396_;
            case NoteBlockInstrument.SNARE, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.PLING -> MaterialColor.f_76400_.f_76396_;
            case NoteBlockInstrument.HAT -> MaterialColor.f_76412_.f_76396_;
            case NoteBlockInstrument.BASS -> MaterialColor.f_76411_.f_76396_;
            case NoteBlockInstrument.FLUTE -> MaterialColor.f_76407_.f_76396_;
            case NoteBlockInstrument.BELL -> MaterialColor.f_76366_.f_76396_;
            case NoteBlockInstrument.GUITAR -> MaterialColor.f_76401_.f_76396_;
            case NoteBlockInstrument.CHIME -> MaterialColor.f_76403_.f_76396_;
            case NoteBlockInstrument.IRON_XYLOPHONE -> MaterialColor.f_76404_.f_76396_;
            case NoteBlockInstrument.COW_BELL -> MaterialColor.f_76362_.f_76396_;
            case NoteBlockInstrument.DIDGERIDOO -> MaterialColor.f_76413_.f_76396_;
            case NoteBlockInstrument.BIT -> MaterialColor.f_76369_.f_76396_;
            case NoteBlockInstrument.BANJO -> MaterialColor.f_76416_.f_76396_;
            default -> -1;
        };
    }

    private static int getPoweredRailStrength(Level level, BlockPos pos, BlockState state) {
        if (level.m_46753_(pos)) {
            return 9;
        }
        int positiveValue = RegisterClientStuff.findPoweredRailSignal(level, pos, state, true, 0);
        int negativeValue = RegisterClientStuff.findPoweredRailSignal(level, pos, state, false, 0);
        return Math.max(positiveValue, negativeValue);
    }

    private static int findPoweredRailSignal(Level level, BlockPos pos, BlockState state, boolean travelPositive, int depth) {
        if (depth >= 8) {
            return 0;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        boolean descending = true;
        RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
        switch (shape) {
            case NORTH_SOUTH: {
                if (travelPositive) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case EAST_WEST: {
                if (travelPositive) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case ASCENDING_EAST: {
                if (travelPositive) {
                    --x;
                } else {
                    ++x;
                    ++y;
                    descending = false;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (travelPositive) {
                    --x;
                    ++y;
                    descending = false;
                } else {
                    ++x;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (travelPositive) {
                    ++z;
                } else {
                    --z;
                    ++y;
                    descending = false;
                }
                shape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (travelPositive) {
                    ++z;
                    ++y;
                    descending = false;
                } else {
                    --z;
                }
                shape = RailShape.NORTH_SOUTH;
            }
        }
        int power = RegisterClientStuff.getPowerFromRail(level, new BlockPos(x, y, z), travelPositive, depth, shape);
        if (power > 0) {
            return power;
        }
        if (descending) {
            return RegisterClientStuff.getPowerFromRail(level, new BlockPos(x, y - 1, z), travelPositive, depth, shape);
        }
        return 0;
    }

    private static int getPowerFromRail(Level level, BlockPos pos, boolean travelPositive, int depth, RailShape shape) {
        BlockState otherState = level.m_8055_(pos);
        if (!otherState.m_60713_(Blocks.f_50030_)) {
            return 0;
        }
        RailShape otherShape = (RailShape)otherState.m_61143_((Property)PoweredRailBlock.f_55214_);
        if (shape == RailShape.EAST_WEST && (otherShape == RailShape.NORTH_SOUTH || otherShape == RailShape.ASCENDING_NORTH || otherShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (otherShape == RailShape.EAST_WEST || otherShape == RailShape.ASCENDING_EAST || otherShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        if (((Boolean)otherState.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            return level.m_46753_(pos) ? 8 - depth : RegisterClientStuff.findPoweredRailSignal(level, pos, otherState, travelPositive, depth + 1);
        }
        return 0;
    }

    private static void registerScollOverrides(ItemScroll scroll) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(scroll, ItemScroll.ANCIENT_PREDICATE, (stack, level, holder, holderID) -> NBTHelper.hasString(stack, "op_id") ? 1.0f : 0.0f);
    }

    private static void registerDataHolderOverrides(DataHolderItem item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((Item)item, ItemFocus.DATATYPE_PRED, (stack, level, holder, holderID) -> {
            float f;
            CompoundTag datum = item.readDatumTag(stack);
            String override = NBTHelper.getString(stack, "VisualOverride");
            String typename = null;
            if (override != null) {
                typename = override;
            } else if (datum != null) {
                typename = (String)datum.m_128431_().iterator().next();
            }
            if (typename == null) {
                f = 0.0f;
            } else {
                switch (typename) {
                    case "entity": {
                        f = 1.0f;
                        break;
                    }
                    case "double": {
                        f = 2.0f;
                        break;
                    }
                    case "vec3": {
                        f = 3.0f;
                        break;
                    }
                    case "widget": {
                        f = 4.0f;
                        break;
                    }
                    case "list": {
                        f = 5.0f;
                        break;
                    }
                    case "pattern": {
                        f = 6.0f;
                        break;
                    }
                    default: {
                        f = 0.0f;
                    }
                }
            }
            return f;
        });
        IClientXplatAbstractions.INSTANCE.registerItemProperty((Item)item, ItemFocus.SEALED_PRED, (stack, level, holder, holderID) -> item.canWrite(stack, SpellDatum.make(Widget.NULL)) ? 0.0f : 1.0f);
    }

    private static void registerPackagedSpellOverrides(ItemPackagedHex item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemPackagedHex.HAS_PATTERNS_PRED, (stack, level, holder, holderID) -> item.hasHex(stack) ? 1.0f : 0.0f);
    }

    private static void registerWandOverrides(ItemWand item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemWand.FUNNY_LEVEL_PREDICATE, (stack, level, holder, holderID) -> {
            if (!stack.m_41788_()) {
                return 0.0f;
            }
            String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT);
            if (name.contains("old")) {
                return 1.0f;
            }
            if (name.contains("wand of the forest")) {
                return 2.0f;
            }
            return 0.0f;
        });
    }

    public static void registerParticles() {
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.LIGHT_PARTICLE, ConjureParticle.Provider::new);
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.CONJURE_PARTICLE, ConjureParticle.Provider::new);
    }

    public static void registerBlockEntityRenderers(@NotNull BlockEntityRendererRegisterererer registerer) {
        registerer.registerBlockEntityRenderer(HexBlockEntities.SLATE_TILE, BlockEntitySlateRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, BlockEntityAkashicBookshelfRenderer::new);
    }

    @FunctionalInterface
    public static interface BlockEntityRendererRegisterererer {
        public <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<T> var1, BlockEntityRendererProvider<? super T> var2);
    }
}

