/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.utils;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.api.utils.WeakMappedValue;
import at.petrak.hexcasting.api.utils.WeakReferencedValue;
import at.petrak.hexcasting.api.utils.WeakValue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00c4\u0001\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020;\u001a\u0014\u0010@\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020;0B\u001a\u000e\u0010C\u001a\u00020\u00032\u0006\u0010D\u001a\u00020\u0003\u001a\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F\u001a\u001e\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020;2\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020;\u001a\u000e\u0010J\u001a\u00020;2\u0006\u0010K\u001a\u00020L\u001a\u000e\u0010M\u001a\u00020N2\u0006\u0010K\u001a\u00020L\u001a,\u0010O\u001a\b\u0012\u0004\u0012\u0002HQ0P\"\u0004\b\u0000\u0010Q\"\u0004\b\u0001\u0010R2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u0002HQ\u0012\u0004\u0012\u0002HR0T\u001a#\u0010U\u001a\b\u0012\u0004\u0012\u0002HQ0P\"\u0004\b\u0000\u0010Q2\n\b\u0002\u0010V\u001a\u0004\u0018\u0001HQ\u00a2\u0006\u0002\u0010W\u001a#\u0010\u000e\u001a\u00020\u000f*\u00020\u00062\u0012\u0010X\u001a\n\u0012\u0006\b\u0001\u0012\u00020Z0Y\"\u00020Z\u00a2\u0006\u0002\u0010[\u001a9\u0010\\\u001a\u0002HQ\"\u000e\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0]*\b\u0012\u0004\u0012\u0002HQ0Y2\u0006\u0010^\u001a\u00020_2\b\b\u0002\u0010`\u001a\u0002HQH\u0007\u00a2\u0006\u0002\u0010a\u001a9\u0010\\\u001a\u0002HQ\"\u000e\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0]*\b\u0012\u0004\u0012\u0002HQ0Y2\u0006\u0010^\u001a\u00020b2\b\b\u0002\u0010`\u001a\u0002HQH\u0007\u00a2\u0006\u0002\u0010c\u001a9\u0010\\\u001a\u0002HQ\"\u000e\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0]*\b\u0012\u0004\u0012\u0002HQ0Y2\u0006\u0010d\u001a\u00020\u00062\b\b\u0002\u0010`\u001a\u0002HQH\u0007\u00a2\u0006\u0002\u0010e\u001a6\u0010f\u001a\u0004\u0018\u0001HQ\"\u0004\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0P2\b\u0010g\u001a\u0004\u0018\u00010Z2\n\u0010h\u001a\u0006\u0012\u0002\b\u00030iH\u0086\n\u00a2\u0006\u0002\u0010j\u001a\u0015\u0010k\u001a\u00020l*\u00020\u00052\u0006\u0010m\u001a\u00020nH\u0086\u0002\u001a\u0014\u0010o\u001a\u00020p*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030r0q\u001a\n\u0010o\u001a\u00020s*\u00020t\u001a\n\u0010o\u001a\u00020u*\u00020;\u001a\n\u0010o\u001a\u00020u*\u00020N\u001a>\u0010v\u001a\u00020l\"\u0004\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0P2\b\u0010g\u001a\u0004\u0018\u00010Z2\n\u0010h\u001a\u0006\u0012\u0002\b\u00030i2\b\u0010V\u001a\u0004\u0018\u0001HQH\u0086\n\u00a2\u0006\u0002\u0010w\u001a!\u0010x\u001a\u00020\u0005*\u00020\u00062\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00020z\u0012\u0004\u0012\u00020z0TH\u0086\u0004\u001a\u0015\u0010x\u001a\u00020\u0005*\u00020\u00062\u0006\u0010{\u001a\u00020|H\u0086\u0004\u001a\u0015\u0010x\u001a\u00020\u0005*\u00020\u00062\u0006\u0010}\u001a\u00020zH\u0086\u0004\u001a!\u0010x\u001a\u00020\u0005*\u00020\u00052\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00020z\u0012\u0004\u0012\u00020z0TH\u0086\u0004\u001a\u0015\u0010x\u001a\u00020\u0005*\u00020\u00052\u0006\u0010{\u001a\u00020|H\u0086\u0004\u001a\u0015\u0010x\u001a\u00020\u0005*\u00020\u00052\u0006\u0010}\u001a\u00020zH\u0086\u0004\u001a\u001e\u0010~\u001a\u00020\u0005*\u00020\u00062\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00020z\u0012\u0004\u0012\u00020z0T\u001a#\u0010~\u001a\u00020\u0005*\u00020\u00062\u0012\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020|0Y\"\u00020|\u00a2\u0006\u0002\u0010\u007f\u001a\u0012\u0010~\u001a\u00020\u0005*\u00020\u00062\u0006\u0010{\u001a\u00020|\u001a\u0012\u0010~\u001a\u00020\u0005*\u00020\u00062\u0006\u0010}\u001a\u00020z\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\"\u0015\u0010\u0012\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\"\u0015\u0010\u0014\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\"\u0015\u0010\u0014\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\t\"\u0015\u0010\u0016\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\b\"\u0015\u0010\u0016\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\t\"\u0015\u0010\u0018\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\b\"\u0015\u0010\u0018\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\t\"\u0015\u0010\u001a\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\b\"\u0015\u0010\u001a\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\t\"\u0015\u0010\u001c\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\b\"\u0015\u0010\u001c\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\t\"\u0015\u0010\u001e\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\b\"\u0015\u0010\u001e\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\t\"\u0015\u0010 \u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\b\"\u0015\u0010 \u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\t\"\u0015\u0010\"\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\b\"\u0015\u0010\"\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\t\"\u0015\u0010$\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\b\"\u0015\u0010$\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\t\"\u0015\u0010&\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\b\"\u0015\u0010&\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\t\"\u0015\u0010(\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\b\"\u0015\u0010(\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\t\"\u0015\u0010*\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\b\"\u0015\u0010*\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\t\"\u0015\u0010,\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\b\"\u0015\u0010,\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\t\"\u0015\u0010.\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\b\"\u0015\u0010.\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\t\"\u0015\u00100\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\b\"\u0015\u00100\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\t\"\u0015\u00102\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\b\"\u0015\u00102\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\t\"\u0015\u00104\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\b\"\u0015\u00104\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\t\"\u0015\u00106\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\b\"\u0015\u00106\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\t\"\u0015\u00108\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\b\"\u0015\u00108\u001a\u00020\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\t\u00a8\u0006\u0080\u0001"}, d2={"SQRT_3", "", "TAU", "", "aqua", "Lnet/minecraft/network/chat/MutableComponent;", "", "getAqua", "(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", "(Lnet/minecraft/network/chat/MutableComponent;)Lnet/minecraft/network/chat/MutableComponent;", "asTextComponent", "Lnet/minecraft/network/chat/TextComponent;", "getAsTextComponent", "(Ljava/lang/String;)Lnet/minecraft/network/chat/TextComponent;", "asTranslatedComponent", "Lnet/minecraft/network/chat/TranslatableComponent;", "getAsTranslatedComponent", "(Ljava/lang/String;)Lnet/minecraft/network/chat/TranslatableComponent;", "black", "getBlack", "blue", "getBlue", "bold", "getBold", "darkAqua", "getDarkAqua", "darkBlue", "getDarkBlue", "darkGray", "getDarkGray", "darkGreen", "getDarkGreen", "darkPurple", "getDarkPurple", "darkRed", "getDarkRed", "gold", "getGold", "gray", "getGray", "green", "getGreen", "italic", "getItalic", "lightPurple", "getLightPurple", "obfuscated", "getObfuscated", "red", "getRed", "strikethrough", "getStrikethrough", "underline", "getUnderline", "white", "getWhite", "yellow", "getYellow", "coordToPx", "Lnet/minecraft/world/phys/Vec2;", "coord", "Lat/petrak/hexcasting/api/spell/math/HexCoord;", "size", "offset", "findCenter", "points", "", "fixNAN", "x", "otherHand", "Lnet/minecraft/world/InteractionHand;", "hand", "pxToCoord", "px", "vec2FromNBT", "tag", "", "vecFromNBT", "Lnet/minecraft/world/phys/Vec3;", "weakMapped", "Lat/petrak/hexcasting/api/utils/WeakValue;", "T", "K", "keyGen", "Lkotlin/Function1;", "weakReference", "value", "(Ljava/lang/Object;)Lat/petrak/hexcasting/api/utils/WeakValue;", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/network/chat/TranslatableComponent;", "getSafe", "", "index", "", "default", "([Ljava/lang/Enum;BLjava/lang/Enum;)Ljava/lang/Enum;", "", "([Ljava/lang/Enum;ILjava/lang/Enum;)Ljava/lang/Enum;", "key", "([Ljava/lang/Enum;Ljava/lang/String;Ljava/lang/Enum;)Ljava/lang/Enum;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Lat/petrak/hexcasting/api/utils/WeakValue;Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "plusAssign", "", "component", "Lnet/minecraft/network/chat/Component;", "serializeToNBT", "Lnet/minecraft/nbt/ListTag;", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/nbt/LongArrayTag;", "setValue", "(Lat/petrak/hexcasting/api/utils/WeakValue;Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "styledWith", "op", "Lnet/minecraft/network/chat/Style;", "formatting", "Lnet/minecraft/ChatFormatting;", "style", "withStyle", "(Ljava/lang/String;[Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", "hexcasting-forge-1.18.2"})
@JvmName(name="HexUtils")
public final class HexUtils {
    public static final double TAU = Math.PI * 2;
    public static final float SQRT_3 = 1.7320508f;

    @NotNull
    public static final LongArrayTag serializeToNBT(@NotNull Vec3 $this$serializeToNBT) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeToNBT, (String)"<this>");
        long[] lArray = new long[]{Double.doubleToRawLongBits($this$serializeToNBT.f_82479_), Double.doubleToRawLongBits($this$serializeToNBT.f_82480_), Double.doubleToRawLongBits($this$serializeToNBT.f_82481_)};
        return new LongArrayTag(lArray);
    }

    @NotNull
    public static final Vec3 vecFromNBT(@NotNull long[] tag) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.length != 3) {
            Vec3 vec32 = Vec3.f_82478_;
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        } else {
            vec3 = new Vec3(Double.longBitsToDouble(tag[0]), Double.longBitsToDouble(tag[1]), Double.longBitsToDouble(tag[2]));
        }
        return vec3;
    }

    @NotNull
    public static final LongArrayTag serializeToNBT(@NotNull Vec2 $this$serializeToNBT) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeToNBT, (String)"<this>");
        long[] lArray = new long[]{Double.doubleToRawLongBits($this$serializeToNBT.f_82470_), Double.doubleToRawLongBits($this$serializeToNBT.f_82471_)};
        return new LongArrayTag(lArray);
    }

    @NotNull
    public static final Vec2 vec2FromNBT(@NotNull long[] tag) {
        Vec2 vec2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.length != 2) {
            Vec2 vec22 = Vec2.f_82462_;
            vec2 = vec22;
            Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"ZERO");
        } else {
            vec2 = new Vec2((float)Double.longBitsToDouble(tag[0]), (float)Double.longBitsToDouble(tag[1]));
        }
        return vec2;
    }

    @NotNull
    public static final InteractionHand otherHand(@NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static final double fixNAN(double x) {
        double d = x;
        return !Double.isInfinite(d) && !Double.isNaN(d) ? x : 0.0;
    }

    @NotNull
    public static final Vec2 findCenter(@NotNull List<? extends Vec2> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (Vec2 vec2 : points) {
            minX = Math.min(minX, vec2.f_82470_);
            minY = Math.min(minY, vec2.f_82471_);
            maxX = Math.max(maxX, vec2.f_82470_);
            maxY = Math.max(maxY, vec2.f_82471_);
        }
        return new Vec2((minX + maxX) / 2.0f, (minY + maxY) / 2.0f);
    }

    @NotNull
    public static final Vec2 coordToPx(@NotNull HexCoord coord, float size, @NotNull Vec2 offset) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Vec2 vec2 = new Vec2(1.7320508f * (float)coord.getQ() + 0.8660254f * (float)coord.getR(), 1.5f * (float)coord.getR()).m_165903_(size).m_165910_(offset);
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"Vec2(\n        SQRT_3 * c\u2026).scale(size).add(offset)");
        return vec2;
    }

    @NotNull
    public static final HexCoord pxToCoord(@NotNull Vec2 px, float size, @NotNull Vec2 offset) {
        Intrinsics.checkNotNullParameter((Object)px, (String)"px");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Vec2 offsetted = px.m_165910_(offset.m_165913_());
        float qf = (0.57735026f * offsetted.f_82470_ - 0.33333f * offsetted.f_82471_) / size;
        float rf = 0.66666f * offsetted.f_82471_ / size;
        int q = MathKt.roundToInt((float)qf);
        int r = MathKt.roundToInt((float)rf);
        return Math.abs(q) >= Math.abs(r) ? new HexCoord(q + MathKt.roundToInt((float)(qf + 0.5f * rf)), r) : new HexCoord(q, r + MathKt.roundToInt((double)((double)(rf -= (float)r) + 0.5 * (double)(qf -= (float)q))));
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, @NotNull String key, @NotNull T t) {
        T t2;
        T t3;
        block2: {
            Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(t, (String)"default");
            String string = key;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            String lowercaseKey = string2;
            T[] $this$firstOrNull$iv = $this$getSafe;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                T element$iv;
                T it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                String string3 = ((Enum)it).name();
                Locale locale2 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                if (!Intrinsics.areEqual((Object)string4, (Object)lowercaseKey)) continue;
                t3 = element$iv;
                break block2;
            }
            t3 = t2 = null;
        }
        if (t3 == null) {
            t2 = t;
        }
        return t2;
    }

    public static /* synthetic */ Enum getSafe$default(Enum[] enumArray, String string, Enum enum_, int n, Object object) {
        if ((n & 2) != 0) {
            enum_ = enumArray[0];
        }
        return HexUtils.getSafe((Enum[])enumArray, (String)string, (Enum)enum_);
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, byte index, @NotNull T t) {
        Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"default");
        return (T)HexUtils.getSafe($this$getSafe, (int)index, t);
    }

    public static /* synthetic */ Enum getSafe$default(Enum[] enumArray, byte by, Enum enum_, int n, Object object) {
        if ((n & 2) != 0) {
            enum_ = enumArray[0];
        }
        return HexUtils.getSafe((Enum[])enumArray, (byte)by, (Enum)enum_);
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, int index, @NotNull T t) {
        Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"default");
        return (0 <= index ? index < $this$getSafe.length : false) ? $this$getSafe[index] : t;
    }

    public static /* synthetic */ Enum getSafe$default(Enum[] enumArray, int n, Enum enum_, int n2, Object object) {
        if ((n2 & 2) != 0) {
            enum_ = enumArray[0];
        }
        return HexUtils.getSafe((Enum[])enumArray, (int)n, (Enum)enum_);
    }

    @NotNull
    public static final MutableComponent withStyle(@NotNull String $this$withStyle, @NotNull Function1<? super Style, ? extends Style> op) {
        Intrinsics.checkNotNullParameter((Object)$this$withStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        MutableComponent mutableComponent = HexUtils.getAsTextComponent($this$withStyle).m_130938_(arg_0 -> HexUtils.withStyle$lambda-1(op, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTextComponent.withStyle(op)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent withStyle(@NotNull String $this$withStyle, @NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)$this$withStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        MutableComponent mutableComponent = HexUtils.getAsTextComponent($this$withStyle).m_130948_(style);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTextComponent.withStyle(style)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent withStyle(@NotNull String $this$withStyle, @NotNull ChatFormatting formatting) {
        Intrinsics.checkNotNullParameter((Object)$this$withStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formatting, (String)"formatting");
        MutableComponent mutableComponent = HexUtils.getAsTextComponent($this$withStyle).m_130940_(formatting);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTextComponent.withStyle(formatting)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent withStyle(@NotNull String $this$withStyle, ChatFormatting ... formatting) {
        Intrinsics.checkNotNullParameter((Object)$this$withStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formatting, (String)"formatting");
        MutableComponent mutableComponent = HexUtils.getAsTextComponent($this$withStyle).m_130944_(Arrays.copyOf(formatting, formatting.length));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTextComponent.withStyle(*formatting)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull String $this$styledWith, @NotNull Function1<? super Style, ? extends Style> op) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        return HexUtils.withStyle($this$styledWith, op);
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull String $this$styledWith, @NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return HexUtils.withStyle($this$styledWith, style);
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull String $this$styledWith, @NotNull ChatFormatting formatting) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formatting, (String)"formatting");
        return HexUtils.withStyle($this$styledWith, formatting);
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull MutableComponent $this$styledWith, @NotNull Function1<? super Style, ? extends Style> op) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        MutableComponent mutableComponent = $this$styledWith.m_130938_(arg_0 -> HexUtils.styledWith$lambda-2(op, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(op)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull MutableComponent $this$styledWith, @NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        MutableComponent mutableComponent = $this$styledWith.m_130948_(style);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(style)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent styledWith(@NotNull MutableComponent $this$styledWith, @NotNull ChatFormatting formatting) {
        Intrinsics.checkNotNullParameter((Object)$this$styledWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formatting, (String)"formatting");
        MutableComponent mutableComponent = $this$styledWith.m_130940_(formatting);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(formatting)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent getBlack(@NotNull String $this$black) {
        Intrinsics.checkNotNullParameter((Object)$this$black, (String)"<this>");
        return HexUtils.styledWith($this$black, ChatFormatting.BLACK);
    }

    @NotNull
    public static final MutableComponent getBlack(@NotNull MutableComponent $this$black) {
        Intrinsics.checkNotNullParameter((Object)$this$black, (String)"<this>");
        return HexUtils.styledWith($this$black, ChatFormatting.BLACK);
    }

    @NotNull
    public static final MutableComponent getDarkBlue(@NotNull String $this$darkBlue) {
        Intrinsics.checkNotNullParameter((Object)$this$darkBlue, (String)"<this>");
        return HexUtils.styledWith($this$darkBlue, ChatFormatting.DARK_BLUE);
    }

    @NotNull
    public static final MutableComponent getDarkBlue(@NotNull MutableComponent $this$darkBlue) {
        Intrinsics.checkNotNullParameter((Object)$this$darkBlue, (String)"<this>");
        return HexUtils.styledWith($this$darkBlue, ChatFormatting.DARK_BLUE);
    }

    @NotNull
    public static final MutableComponent getDarkGreen(@NotNull String $this$darkGreen) {
        Intrinsics.checkNotNullParameter((Object)$this$darkGreen, (String)"<this>");
        return HexUtils.styledWith($this$darkGreen, ChatFormatting.DARK_GREEN);
    }

    @NotNull
    public static final MutableComponent getDarkGreen(@NotNull MutableComponent $this$darkGreen) {
        Intrinsics.checkNotNullParameter((Object)$this$darkGreen, (String)"<this>");
        return HexUtils.styledWith($this$darkGreen, ChatFormatting.DARK_GREEN);
    }

    @NotNull
    public static final MutableComponent getDarkAqua(@NotNull String $this$darkAqua) {
        Intrinsics.checkNotNullParameter((Object)$this$darkAqua, (String)"<this>");
        return HexUtils.styledWith($this$darkAqua, ChatFormatting.DARK_AQUA);
    }

    @NotNull
    public static final MutableComponent getDarkAqua(@NotNull MutableComponent $this$darkAqua) {
        Intrinsics.checkNotNullParameter((Object)$this$darkAqua, (String)"<this>");
        return HexUtils.styledWith($this$darkAqua, ChatFormatting.DARK_AQUA);
    }

    @NotNull
    public static final MutableComponent getDarkRed(@NotNull String $this$darkRed) {
        Intrinsics.checkNotNullParameter((Object)$this$darkRed, (String)"<this>");
        return HexUtils.styledWith($this$darkRed, ChatFormatting.DARK_RED);
    }

    @NotNull
    public static final MutableComponent getDarkRed(@NotNull MutableComponent $this$darkRed) {
        Intrinsics.checkNotNullParameter((Object)$this$darkRed, (String)"<this>");
        return HexUtils.styledWith($this$darkRed, ChatFormatting.DARK_RED);
    }

    @NotNull
    public static final MutableComponent getDarkPurple(@NotNull String $this$darkPurple) {
        Intrinsics.checkNotNullParameter((Object)$this$darkPurple, (String)"<this>");
        return HexUtils.styledWith($this$darkPurple, ChatFormatting.DARK_PURPLE);
    }

    @NotNull
    public static final MutableComponent getDarkPurple(@NotNull MutableComponent $this$darkPurple) {
        Intrinsics.checkNotNullParameter((Object)$this$darkPurple, (String)"<this>");
        return HexUtils.styledWith($this$darkPurple, ChatFormatting.DARK_PURPLE);
    }

    @NotNull
    public static final MutableComponent getGold(@NotNull String $this$gold) {
        Intrinsics.checkNotNullParameter((Object)$this$gold, (String)"<this>");
        return HexUtils.styledWith($this$gold, ChatFormatting.GOLD);
    }

    @NotNull
    public static final MutableComponent getGold(@NotNull MutableComponent $this$gold) {
        Intrinsics.checkNotNullParameter((Object)$this$gold, (String)"<this>");
        return HexUtils.styledWith($this$gold, ChatFormatting.GOLD);
    }

    @NotNull
    public static final MutableComponent getGray(@NotNull String $this$gray) {
        Intrinsics.checkNotNullParameter((Object)$this$gray, (String)"<this>");
        return HexUtils.styledWith($this$gray, ChatFormatting.GRAY);
    }

    @NotNull
    public static final MutableComponent getGray(@NotNull MutableComponent $this$gray) {
        Intrinsics.checkNotNullParameter((Object)$this$gray, (String)"<this>");
        return HexUtils.styledWith($this$gray, ChatFormatting.GRAY);
    }

    @NotNull
    public static final MutableComponent getDarkGray(@NotNull String $this$darkGray) {
        Intrinsics.checkNotNullParameter((Object)$this$darkGray, (String)"<this>");
        return HexUtils.styledWith($this$darkGray, ChatFormatting.DARK_GRAY);
    }

    @NotNull
    public static final MutableComponent getDarkGray(@NotNull MutableComponent $this$darkGray) {
        Intrinsics.checkNotNullParameter((Object)$this$darkGray, (String)"<this>");
        return HexUtils.styledWith($this$darkGray, ChatFormatting.DARK_GRAY);
    }

    @NotNull
    public static final MutableComponent getBlue(@NotNull String $this$blue) {
        Intrinsics.checkNotNullParameter((Object)$this$blue, (String)"<this>");
        return HexUtils.styledWith($this$blue, ChatFormatting.BLUE);
    }

    @NotNull
    public static final MutableComponent getBlue(@NotNull MutableComponent $this$blue) {
        Intrinsics.checkNotNullParameter((Object)$this$blue, (String)"<this>");
        return HexUtils.styledWith($this$blue, ChatFormatting.BLUE);
    }

    @NotNull
    public static final MutableComponent getGreen(@NotNull String $this$green) {
        Intrinsics.checkNotNullParameter((Object)$this$green, (String)"<this>");
        return HexUtils.styledWith($this$green, ChatFormatting.GREEN);
    }

    @NotNull
    public static final MutableComponent getGreen(@NotNull MutableComponent $this$green) {
        Intrinsics.checkNotNullParameter((Object)$this$green, (String)"<this>");
        return HexUtils.styledWith($this$green, ChatFormatting.GREEN);
    }

    @NotNull
    public static final MutableComponent getAqua(@NotNull String $this$aqua) {
        Intrinsics.checkNotNullParameter((Object)$this$aqua, (String)"<this>");
        return HexUtils.styledWith($this$aqua, ChatFormatting.AQUA);
    }

    @NotNull
    public static final MutableComponent getAqua(@NotNull MutableComponent $this$aqua) {
        Intrinsics.checkNotNullParameter((Object)$this$aqua, (String)"<this>");
        return HexUtils.styledWith($this$aqua, ChatFormatting.AQUA);
    }

    @NotNull
    public static final MutableComponent getRed(@NotNull String $this$red) {
        Intrinsics.checkNotNullParameter((Object)$this$red, (String)"<this>");
        return HexUtils.styledWith($this$red, ChatFormatting.RED);
    }

    @NotNull
    public static final MutableComponent getRed(@NotNull MutableComponent $this$red) {
        Intrinsics.checkNotNullParameter((Object)$this$red, (String)"<this>");
        return HexUtils.styledWith($this$red, ChatFormatting.RED);
    }

    @NotNull
    public static final MutableComponent getLightPurple(@NotNull String $this$lightPurple) {
        Intrinsics.checkNotNullParameter((Object)$this$lightPurple, (String)"<this>");
        return HexUtils.styledWith($this$lightPurple, ChatFormatting.LIGHT_PURPLE);
    }

    @NotNull
    public static final MutableComponent getLightPurple(@NotNull MutableComponent $this$lightPurple) {
        Intrinsics.checkNotNullParameter((Object)$this$lightPurple, (String)"<this>");
        return HexUtils.styledWith($this$lightPurple, ChatFormatting.LIGHT_PURPLE);
    }

    @NotNull
    public static final MutableComponent getYellow(@NotNull String $this$yellow) {
        Intrinsics.checkNotNullParameter((Object)$this$yellow, (String)"<this>");
        return HexUtils.styledWith($this$yellow, ChatFormatting.YELLOW);
    }

    @NotNull
    public static final MutableComponent getYellow(@NotNull MutableComponent $this$yellow) {
        Intrinsics.checkNotNullParameter((Object)$this$yellow, (String)"<this>");
        return HexUtils.styledWith($this$yellow, ChatFormatting.YELLOW);
    }

    @NotNull
    public static final MutableComponent getWhite(@NotNull String $this$white) {
        Intrinsics.checkNotNullParameter((Object)$this$white, (String)"<this>");
        return HexUtils.styledWith($this$white, ChatFormatting.WHITE);
    }

    @NotNull
    public static final MutableComponent getWhite(@NotNull MutableComponent $this$white) {
        Intrinsics.checkNotNullParameter((Object)$this$white, (String)"<this>");
        return HexUtils.styledWith($this$white, ChatFormatting.WHITE);
    }

    @NotNull
    public static final MutableComponent getObfuscated(@NotNull String $this$obfuscated) {
        Intrinsics.checkNotNullParameter((Object)$this$obfuscated, (String)"<this>");
        return HexUtils.styledWith($this$obfuscated, ChatFormatting.OBFUSCATED);
    }

    @NotNull
    public static final MutableComponent getObfuscated(@NotNull MutableComponent $this$obfuscated) {
        Intrinsics.checkNotNullParameter((Object)$this$obfuscated, (String)"<this>");
        return HexUtils.styledWith($this$obfuscated, ChatFormatting.OBFUSCATED);
    }

    @NotNull
    public static final MutableComponent getBold(@NotNull String $this$bold) {
        Intrinsics.checkNotNullParameter((Object)$this$bold, (String)"<this>");
        return HexUtils.styledWith($this$bold, ChatFormatting.BOLD);
    }

    @NotNull
    public static final MutableComponent getBold(@NotNull MutableComponent $this$bold) {
        Intrinsics.checkNotNullParameter((Object)$this$bold, (String)"<this>");
        return HexUtils.styledWith($this$bold, ChatFormatting.BOLD);
    }

    @NotNull
    public static final MutableComponent getStrikethrough(@NotNull String $this$strikethrough) {
        Intrinsics.checkNotNullParameter((Object)$this$strikethrough, (String)"<this>");
        return HexUtils.styledWith($this$strikethrough, ChatFormatting.STRIKETHROUGH);
    }

    @NotNull
    public static final MutableComponent getStrikethrough(@NotNull MutableComponent $this$strikethrough) {
        Intrinsics.checkNotNullParameter((Object)$this$strikethrough, (String)"<this>");
        return HexUtils.styledWith($this$strikethrough, ChatFormatting.STRIKETHROUGH);
    }

    @NotNull
    public static final MutableComponent getUnderline(@NotNull String $this$underline) {
        Intrinsics.checkNotNullParameter((Object)$this$underline, (String)"<this>");
        return HexUtils.styledWith($this$underline, ChatFormatting.UNDERLINE);
    }

    @NotNull
    public static final MutableComponent getUnderline(@NotNull MutableComponent $this$underline) {
        Intrinsics.checkNotNullParameter((Object)$this$underline, (String)"<this>");
        return HexUtils.styledWith($this$underline, ChatFormatting.UNDERLINE);
    }

    @NotNull
    public static final MutableComponent getItalic(@NotNull String $this$italic) {
        Intrinsics.checkNotNullParameter((Object)$this$italic, (String)"<this>");
        return HexUtils.styledWith($this$italic, ChatFormatting.ITALIC);
    }

    @NotNull
    public static final MutableComponent getItalic(@NotNull MutableComponent $this$italic) {
        Intrinsics.checkNotNullParameter((Object)$this$italic, (String)"<this>");
        return HexUtils.styledWith($this$italic, ChatFormatting.ITALIC);
    }

    public static final void plusAssign(@NotNull MutableComponent $this$plusAssign, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        $this$plusAssign.m_7220_(component);
    }

    @NotNull
    public static final TextComponent getAsTextComponent(@NotNull String $this$asTextComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$asTextComponent, (String)"<this>");
        return new TextComponent($this$asTextComponent);
    }

    @NotNull
    public static final TranslatableComponent getAsTranslatedComponent(@NotNull String $this$asTranslatedComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$asTranslatedComponent, (String)"<this>");
        return new TranslatableComponent($this$asTranslatedComponent);
    }

    @NotNull
    public static final TranslatableComponent asTranslatedComponent(@NotNull String $this$asTranslatedComponent, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)$this$asTranslatedComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new TranslatableComponent($this$asTranslatedComponent, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public static final <T> WeakValue<T> weakReference(@Nullable T value) {
        WeakReference<T> weakReference;
        T t = value;
        if (t != null) {
            T it = t;
            boolean bl = false;
            weakReference = new WeakReference<T>(it);
        } else {
            weakReference = null;
        }
        WeakReference<T> weakReference2 = weakReference;
        return new WeakReferencedValue<T>(weakReference2);
    }

    public static /* synthetic */ WeakValue weakReference$default(Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        return HexUtils.weakReference(object);
    }

    @NotNull
    public static final <T, K> WeakValue<T> weakMapped(@NotNull Function1<? super T, ? extends K> keyGen) {
        Intrinsics.checkNotNullParameter(keyGen, (String)"keyGen");
        return new WeakMappedValue<K, T>(keyGen);
    }

    @Nullable
    public static final <T> T getValue(@NotNull WeakValue<T> $this$getValue, @Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter($this$getValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        boolean $i$f$getValue = false;
        return $this$getValue.getValue();
    }

    public static final <T> void setValue(@NotNull WeakValue<T> $this$setValue, @Nullable Object thisRef, @NotNull KProperty<?> property, @Nullable T value) {
        Intrinsics.checkNotNullParameter($this$setValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        boolean $i$f$setValue = false;
        $this$setValue.setValue(value);
    }

    @NotNull
    public static final ListTag serializeToNBT(@NotNull Iterable<? extends SpellDatum<?>> $this$serializeToNBT) {
        Intrinsics.checkNotNullParameter($this$serializeToNBT, (String)"<this>");
        CompoundTag out = SpellDatum.Companion.make(new SpellList.LList(0, CollectionsKt.toList($this$serializeToNBT))).serializeToNBT();
        return out.m_128441_("widget") ? new ListTag() : NBTHelper.getListByByte(out, "list", (byte)10);
    }

    @NotNull
    public static final CompoundTag serializeToNBT(@NotNull ItemStack $this$serializeToNBT) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeToNBT, (String)"<this>");
        CompoundTag out = new CompoundTag();
        $this$serializeToNBT.m_41739_(out);
        return out;
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (T)HexUtils.getSafe$default($this$getSafe, key, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, byte index) {
        Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
        return (T)HexUtils.getSafe$default($this$getSafe, index, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T extends Enum<T>> T getSafe(@NotNull T[] $this$getSafe, int index) {
        Intrinsics.checkNotNullParameter($this$getSafe, (String)"<this>");
        return (T)HexUtils.getSafe$default($this$getSafe, index, null, 2, null);
    }

    private static final Style withStyle$lambda-1(Function1 $tmp0, Style p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Style)$tmp0.invoke((Object)p0);
    }

    private static final Style styledWith$lambda-2(Function1 $tmp0, Style p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Style)$tmp0.invoke((Object)p0);
    }
}

